// Fragment program for distorting a texture using a 3D noise texture

varying vec3 noiseCoord;//			: TEXCOORD0,
varying vec4 projectionCoord;//		: TEXCOORD1,
varying vec3 eyeDir;//				: TEXCOORD2,
varying vec3 normal;//				: TEXCOORD3,
		
//out float4 col		: COLOR,
		
uniform vec4 tintColour;
uniform float noiseScale; 
uniform float fresnelBias;
uniform float fresnelScale;
uniform float fresnelPower;
uniform sampler2D noiseMap;// : register(s0),
uniform sampler2D reflectMap;// : register(s1),
uniform sampler2D refractMap;// : register(s2)

void main(void)
{
	// Do the tex projection manually so we can distort _after_
	vec2 final = projectionCoord.xy / projectionCoord.w;

	// Noise
	vec3 noiseNormal = (texture2D(noiseMap, (noiseCoord.xy / 5.0)).rgb - 0.5).rbg * noiseScale;
	final += noiseNormal.xz;

	// Fresnel
	//normal = normalize(normal + noiseNormal.xz);
	float fresnel = fresnelBias + fresnelScale * pow(1.0 + dot(eyeDir, normal), fresnelPower);
	fresnel = clamp(fresnel, 0.05, 0.95);

	// Reflection / refraction
	vec4 reflectionColour = texture2D(reflectMap, final);
	vec4 refractionColour = texture2D(refractMap, final) + tintColour;

	//fresnel = 0.99;
	// Final colour
	//col = lerp(refractionColour, vec4(1.0, 0.0, 0.0, 1), 0);
	gl_FragColor = mix(vec4(0.129, 0.235, 0.305, 1), reflectionColour, fresnel);  
	//gl_FragColor = reflectionColour;
	//gl_FragColor = refractionColour*fresnel+reflectionColour*(1.0-fresnel);
	//gl_FragColor = reflectionColour*fresnel+refractionColour*(1.0-fresnel);
	//gl_FragColor = reflectionColour;
	//gl_FragColor = vec4(0.0, 1.0, 0.0, 0.5);
}
