var Dialog = (function(){
	var	id,
		layout,
		shadow,
		shadowCover,
		title,
		content,
		closeTrigger,
		closeCallback,
		l = function(selector){
			return layout.find(selector);
		},
		$tip = $('<span></span>').appendTo(document.body);
		$tip.css( {
			position: 'absolute',
			top: '0',
			padding: '5px 10px',
			color: '#fff',
			opacity: 0,
			"line-height":"20px",
			'z-index': 99999,
			'background-color': '#333'	
		});
	
	return {
		init: function(){
			id = 'fitDialog',
			shadow = $('#fitDialog_shadow'),
			shadowCover = $('#fitDialog-shadow-cover'),
			layout = $('#' + id),
			title = l('.title'),
			content = l('.content'),
			closeTrigger = l('#fitDialog_close_btn');
			layout.hide();
			
			if($.browser.version > '6.0'){
				layout.css({
					filter: 'filter: progid:DXImageTransform.Microsoft.Shadow(Strength=1, Direction=135, Color="#666666");'
				});
			}
			
			closeTrigger
			.mouseover(function(){
				$(this).addClass('hover');
			})
			.mouseout(function(){
				$(this).removeClass('hover actived');
			})
			.mousedown(function(){
				$(this).addClass('actived');
			})
			.mouseup(function(){
				$(this).removeClass('actived');
			})
			.click(function(){
				Dialog.hide();
			});
			
			$(document).keypress(function(e){
				if(!layout.is(':visible')) return;
				
				var buttons = l('.buttons span').filter('.button2, .button3');
				if(e.keyCode == 27){//ESC取消操作
						var lastButton = buttons.filter(':last'),
						lastButtonText = lastButton.text();
						
					if(buttons.length === 1){
						buttons.click();
					}else if(lastButtonText.match(/^取 消|否\(N\)$/)){
						lastButton.click();
					}
				}else if(e.keyCode == 13){//Enter确定操作
					if(e.target.tagName.toLowerCase().match(/^input|textarea|select$/)){
					}else{
						var firstButton = buttons.filter(':first'),
							firstButtonText = firstButton.text();
							
						if(firstButtonText.match(/^确 定|是\(Y\)$/)){
							firstButton.click();
						}
					}
				}
			});			
		},
		tip: function(messageText, delaySeconds, html){
			if(!messageText) return false;
			delaySeconds = (delaySeconds || 500);
			var move = 30;
				

			$tip.stop().css({
				opacity: 0
			});

			if(html){
				$tip.html(messageText);
			}else{
				$tip.text(messageText);
			}
			
			if($tip.width()>300){
				$tip.css({
					width: 300
				});
			}else{
				$tip.css({
					width: 'auto'
				});
			}
			
			setTimeout(function(){
				var top = ($(window).height()-$tip.outerHeight())/2,
					left = ($(window).width()-$tip.outerWidth())/2;
				$tip.css({
					top: top + move/2,
					left: left,
					display: 'block',
					opacity: 0
				});
				$tip.animate({
					top: top - move/2,
					opacity: 1
				}, function(){
					setTimeout(function(){
						var top = $tip.offset().top;
						$tip.animate({
							top: top - move,
							opacity: 0
						}, function(){
							$tip.hide();
						});
					}, delaySeconds);
				});			
			});
			return $tip;
		},
		getSize: function(){
			return {
				width: layout.outerWidth(),
				height: layout.outerHeight()
			}
		},
		box: function(arg){
			var self  = this;
			var show = function(){
				try{
					Progress.hide();
				}catch(e){}
				if(layout.is(':visible')) self.hide();
				l('.title').html(arg.title || '店宝宝');			
				var content = l('.content');
				$('.inputTr').toggle(!!arg.prompt);
				
				arg = $.extend({
					style: {},
					action: function(){},
					closeBtnVisible: true
				}, arg);			

				content.html(''+arg.content).css($.extend({
					height: 'auto',
					width: 'auto',
					overflow: 'hidden',
					border: 'none'
				},arg.style));
				
				closeTrigger.toggle(arg.closeBtnVisible);
				
				var buttonArr = [],
					buttonIndex = 0;
				$.each(arg.button, function(buttonText, buttonFunc){
					if(!buttonFunc) return;
					buttonArr.push(
						'<span class="buttonNo">buttonText</span>'
							.replace(/buttonNo/g, buttonIndex==0?'button3':'button2')
							.replace(/buttonText/g, buttonText)
					);
					buttonIndex++;
				});
				l('.buttons').html(buttonArr.join('')).pur5UI().parents('tr').toggle(!!buttonArr.length);
				
				closeCallback = arg.closeCallback || function(){};
				Dwd.alert(layout);
				arg.action(content, layout);
				l('.buttons span').filter('.button2, .button3').click(function(){
					var button = $(this),
						buttonText = button.text(),
						result;
						
					if(arg.prompt){
						result = arg.button[buttonText](l('.inputObj').val(), content);
					}else{
						result = arg.button[buttonText](content, l('.inputObj').val());
					}
					if(result !== false) self.hide();
				});
			}
			
			setTimeout(function(){
				if(arg.content && js_type(arg.content) == 'Object' && arg.content.url === true){
					//alert($.stringify(arg.content));
					$.ajax($.extend({
						show: function(content){
							$.extend(arg, {
								content: content
							});
							show();
						}
					},arg.content));
				}else{
					show();
				}				
			});
		},
		prompt: function(arg, callback){
			this.box($.extend(true, {
				title: '请输入',
				content: '内容',
				prompt: true,
				button: {
					'确 定': function(){},
					'取 消': function(){}
				}
			}, arg));
		},
		alert: function(arg){
			this.box($.extend(true, {
				title: '提示',
				content: '内容',
				button: {
					'确 定': function(){}
				}
			}, arg));
		},
		confirm: function(arg, callback){
			this.box($.extend(true, {
				title: '请确认',
				button: {
					'确 定': function(){},
					'取 消': function(){}
				},
				content: '内容'
			}, arg));
		},
		normalAlert: function(title, content){
			this.alert({
				title: title || undefined,
				content: content || undefined,
				style: {
					width: 280,
					height: 30
				}
			});
		},
		normalConfirm: function(title, content, cb){
			this.confirm({
				title: title || undefined,
				content: content || undefined,
				button: {
					'确 定': cb
				},
				style: {
					width: 280,
					height: 30
				}
			});
		},
		hide: function(){
			try{//关闭时移除iframe
				content.find('iframe').each(function(){
					this.contentWindow.document.write('');
					this.contentWindow.document.clear();
				}).attr('src', 'about:blank;').remove().end().empty();
			}catch(e){}
			
			CollectGarbage
			layout.hide();
			shadowCover.hide();
			shadow.hide();
			try{
				closeCallback();
			}catch(e){}
		},
		superIframe: function(Arg){
			var Arg = $.extend({
				title: '提示',
				style: {
					width: 400,
					height: 300
				},
				src: 'about:blank;',
				action: function(){},
				parentAction: function(){}
			}, Arg);			

			Dialog.alert({
				title: Arg.title,
				content: parseData2Template('<iframe frameborder="0" style="visibility:"\
							application="yes" width="$width" height="$height"\
							src="about:blank"></iframe>', {
								width: Arg.style.width,
								height: Arg.style.height
							}),
				action: function($content){
					$content.find('iframe').load(function(){
						var Win = this.contentWindow,
							Doc = Win.document,
							$doc = $(Doc),
							Iframe =  $doc.find('iframe');
							
						Arg.parentAction($doc, Win, $content, layout);		
										
						Iframe
						.load(function(){
							var Win = this.contentWindow,
								Doc = Win.document,
								$doc = $(Doc);
							
							Arg.action($doc, Win, $content, layout);
						}).attr('src', Arg.src);
						
					}).attr('src', 'file:///' + Dwd.startPath + 'iframe.html');
				},
				button: Arg.button,
				closeCallback: Arg.closeCallback
			});
		}
	}
})();
Dialog.init();