var Login = (function() {
	var layout,
	l = function(selector) {
		return layout.find(selector);
	},
	Key,
	autologin = false;

	return {
		init: function() {
			layout = $('#login');

			(function() { //输入框效果控制
				$('#uin')
					.focus(function() {
					$(this).find('input').focus();
				})
					.find('input')
					.keyup(function(e) {
					if (e.keyCode == 13) {
						l('#login_btn').click();
					}
				})
					.focus(function() {
					$(this).parent().addClass('hover');
				})
					.blur(function() {
					$(this).parent().removeClass('hover capslock');
				});

				$('#Pur5EditAx')[0].attachEvent('onfocus', function(base64Pic) {
					$('#pwd').addClass('hover');
				});
				$('#Pur5EditAx')[0].attachEvent('onlostfocus', function(base64Pic) {
					$('#pwd').removeClass('hover');
				});
				$('#Pur5EditAx')[0].attachEvent('onenter', function(base64Pic) {
					l('#login_btn').click();
				});

				$('#pwd').focus(function() {
					try {
						$('#Pur5EditAx')[0].Focus();
					} catch (e) {}
				});
			})();

			l('.refresh-servers').click(function() { //重选服务器
				window.location.reload();
			});

			l('.agreement').click(function() { //协议相关
				Ui.pop({
					title: '店宝宝相关协议',
					content: top.Dwd.startPath + '../agreement/软件许可及服务协议.html',
					position: 5,
					width: 800,
					height: 550,
					arg: {
						showTime: false
					}
				});
			});

			$('#autologin').click(function() {
				if ($(this).is(':checked')) {
					$('#remember').attr('checked', true);
				}
			});

			$('#remember').click(function() {
				if (this.checked && !confirm('为了您的资金安全，请不要在公共电脑上记住密码。\n-----------------------\n您确定要记住密码吗？')) {
					this.checked = false;
				}
			});

			$('#authorize350').on('click', function(){
				MiniBrowser.navigate({
					url: 'http://u.350.net/dbb/login',
					title: '350授权登录',
					width: 500,
					height: 305,
					top: true,
					callback: function(obj, eventName){
						if(eventName != 'beforeNavigate'){
							return;
						}

						Key = getFields({
							uin: /uid=(\d{11})/,
							key: /key=(\w{32})/
						}, obj.url || '');

						if(Key.uin && Key.key){
							MiniBrowser.hide({
								blank: true
							});
							setTimeout(function(){
								l('.login_form').fillWithObject(Key);
								l('#login_btn').click();
							});							
						}else{
							Key = null;
						}
					}
				});
			});

			l('#login_btn').click(function() { //登录按钮
				var triggerBtn = $(this),
					Pur5EditAx = $('#Pur5EditAx')[0];
				if (triggerBtn.data('isloging') == 1) return false;
				triggerBtn.data('isloging', 1);

				Dwd.connectionTest(function() {
					Pur5EditAx.url = Dwd.makeFullPath('getcode.asp?' + new Date().getTime());

					Pur5EditAx.transform = true;
					var loginData = l('.login_form').serializeObject(),
						pwd = $('#Pur5EditAx')[0].output;

					if (!Key && (loginData.uin == '' || pwd == '')) {
						Dialog.normalAlert('提示', '请输入用户名和密码！');
						triggerBtn.removeData('isloging');
						return false;
					}

					$.extend(loginData, {
						from: Key?'key': undefined,
						pwd: Key?Key.key:encodeURIComponent(pwd),
						pwdEncode: Key?'':Pur5EditAx.O1,
						h: encodeURIComponent(Pur5EditAx.H1(0)),
						time: Pur5EditAx.time,
						version: Dwd.version,
						host: Dwd.host
					});

					l('.login_form').hide();					
					l('.loginTip').text('正在登录').show();

					Key = null;

					User.login(loginData, function(result, errMsg) {
						if (!result) {
							triggerBtn.removeData('isloging');

							alert('登录失败：' + errMsg);
							
							l('.login_form').show();
							l('.loginTip').hide();

							return;
						}
						
						$('#Pur5EditAx').remove();
						Dwd.loginSuccess();
						l('.loginTip').text('登录成功，正在加载数据').show();
					});
				});
			});

			(function() {
				var LoginInfo = User.getLoginInfo();
				if (!LoginInfo) {
					User.delLoginInfo();
					return;
				};

				l('.login_form').fillWithObject(LoginInfo);

				try{
					$('#Pur5EditAx')[0].time = LoginInfo.time;
					$('#Pur5EditAx')[0].input = LoginInfo.pwdEncode;
					$('#remember').attr('checked', true);
				}catch(e){
					User.delLoginInfo();
				}

				autologin = LoginInfo.autologin;
			})();

			l('.forgetPwd').click(function() {
				Ui.pop({
					title: '找回密码',
					content: Dwd.makeFullPath('DefaultPage/ForgetPwd/forget.asp'),
					position: 5,
					width: 550,
					height: 350,
					arg: {
						showTime: false
					}
				});
			});
		},
		layoutIn: function() {
			Ui.layoutTo($('#login'));
			Ui.setDragArea(0, 0, 290, 30);
			if (autologin) {
				l('#login_btn').click();
			}
		},
		layoutOut: function() {
			Dialog.confirm({
				title: '注销登录',
				content: '您确定要注销登录吗？',
				button: {
					'确 定': function() {
						User.loginOut(true, function() {
							history.go(0);
						});
					}
				},
				style: {
					width: 250,
					height: 35
				}
			});
		}
	}
})();
$(function() {
	Login.init();
});