﻿//menu-start
var Menu = (function(){
	var $menu = $('#menu'),
		$frame = $('#frame'),
		changeCallbackList = [];

	return {
		init: function(){
			Dwd.loginSuccess(function(){
				if(!User.ifBigProxy()){
					$menu.find('li:contains(订单管理)').find('li:contains(订单利润)').hide();
				}

				$menu.find('li:first').click();
			});
		},
		getIframePosition: function(){
			return $.extend({
				width: $frame.width(),
				height: $frame.height()
			}, $frame.position());
		},
		changeTo: function(main, submenu, queryString) {
			$('#menu').find('li:contains(' + main + ')').trigger('click', [submenu, queryString]);
		},
		getLastPosition: function() {
			var submenu = $('#menu').find('li:last');
			return $.extend({
				width: submenu.width(),
				height: submenu.height()
			}, submenu.position());
		},
		change: function(){
			var arg = arguments[0],
				type = js_type(arg);

			switch(type){
				case 'Function':
					changeCallbackList.push(arg);
					break;
				case 'Object':
					$.each(changeCallbackList, function(index, cb){
						cb(arg);
					});

					break;
				default:
					//
			}
		}
	}
})();

! function() {
	var layout = $('#menu'),
		submenuContainer = $('.submenuContainer'),
		l = function(selector) {
			return layout.find(selector);
		};

	var TopMenu = {
		'综合信息': 'DefaultPage/Taobao/info.asp',
		'账户中心': {
			'用户设置': 'DefaultPage/users/info.asp',
			'消息管理': 'DefaultPage/message/MessageList.asp',
			'授权证书': 'cert/cert_get.asp',
			'充值加款': 'DefaultPage/PushMoney/info.asp',
			'操作日志': 'DefaultPage/users/Log.asp',
			'注销登录': function() {
				Login.layoutOut();
			},
			'退出系统': function() {
				Dwd.close();
			}
		},
		'产品中心': 'defaultpage/product/prolist.asp',
		'订单管理': {
			'订单列表': 'DefaultPage/trade/TradeLists.asp',
			'导单记录': 'DefaultPage/trade/taobaotradeManualList.asp',
			'订单统计': 'DefaultPage/trade/Statistics.asp',
			'订单利润': 'DefaultPage/bigProxy/Statistics.asp',
			'订单日志': 'DefaultPage/trade/TradeLogList.asp',
			'订单返点': 'DefaultPage/trade/TradeRebateLogList.asp',
			'收货地址': 'DefaultPage/users/UserAddress.asp',
			'问题订单': 'DefaultPage/trade/TradeErrlist.asp'
		},
		'店铺管理': {
			'绑定店铺': 'DefaultPage/Taobao/shop-binding.asp',
			'店铺设置': 'DefaultPage/Taobao/shop-setting.html', //店铺名字、店铺公告、店铺描述、自动评价开关及内容、是否自动付款、自动发货
			'店铺筹备': 'DefaultPage/Taobao/shop-how2.html',
			'一键装修': (function() {
				if(Dwd.version >= '2.0.2'){
					return 'DefaultPage/Taobao/shop-zx.html';
				}else{
					return function(){
						Dwd.startTbDesigner()
					}
				}
			})(),
			'订单浏览': 'DefaultPage/Taobao/shop-orders.html'
		},
		'宝贝管理': {
			'一键铺货': 'DefaultPage/Taobao/goods-yjph.html',
			'手动管理': 'DefaultPage/Taobao/goods-onsale.html',
			//'自动上架': 'goods-zdsj.html',
			'批量修改': 'DefaultPage/Taobao/goods-plxg.html',
			'自动橱窗': 'DefaultPage/Taobao/marketing-zdcc.html'
			//'手动橱窗': 'marketing-sdcc.html',//手动推荐
			//'宝贝备份': 'goods-bbbf.html'//备份宝贝到服务器、恢复宝贝
		},
		'营销管理': {
			//'客户营销': 'DefaultPage/Taobao/marketing-member.html',//客户、姓名、交易笔数、交易金额、查看所有交易、电子邮件、手机、城市、新客户、老客户、忠实客户、营销分析、发送宝贝信息 邮箱 短信。。。。
			//'限时折扣': 'marketing-xszk.html',//淘宝增值服务，收费应用？
			'站外推广': 'DefaultPage/Taobao/marketing-zwyx.html', //链接推广
			'付费推广': 'DefaultPage/task/list.asp'
			//'实时访客': 'http://127.0.0.1/shop-member.html',
			//'流量统计': 'http://127.0.0.1/shop-pv.html'
		},
		'销售管理': {
			'销售软件': 'DefaultPage/sale/addUser.asp',
			'销售记录': 'DefaultPage/sale/list.asp',
			'销售统计': 'DefaultPage/sale/Statistics.asp'
		},
		'帮助中心':{
			//'新手指导': 'help/new.html',
			//'下载专区': 'http://www.pur5.com/soft/help/downLoad.html',
			//'视频教程': 'http://www.pur5.com/soft/help/VideoHelp.html',
			//'疑难解答': 'help/quest.asp',
			'帮助文档': 'help/help.html',
			'FAQ常见问题': 'help/liuyanFAQ.asp',
			'在线客服': 'help/liuyan.asp',
			'软件销售障碍': 'help/liuyanforsale.asp'
			//'问卷调查': 'survey.asp'
		}
	},
	makeSubMenu = function(text, menu, submenu, queryString) {
		submenuContainer.html(function() {
			var tempArr = [],
				template = '<li><a href="#">subMenuText</a></li>';

			$.each(menu, function(key, value) {
				tempArr.push(
				template.replace(/subMenuText/, key));
			});
			return '<div id="submenu" data-menu="' + text + '"><ul>' + tempArr.join('') + '</ul></div>'
		}());

		submenuContainer.find('a').click(function() {
			var submenu = $('#submenu'),
				mainMenu = TopMenu[submenu.attr('data-menu')],
				Item = $(this);

			if (!mainMenu || !mainMenu[Item.text()]) return false;
			var action = mainMenu[Item.text()];
			({
				'String': function() {
					Ui.frameTo(action, queryString);					
					Item.addClass('actived').parent().siblings().find('a').removeClass('actived');
				},
				'Function': function() {
					action();
				}
			})[js_type(action)]();

			Menu.change({
				main: text,
				sub: Item.text(),
				url: js_type(action) == 'String'?action:'',
				queryString: queryString
			});
		})
			.filter(':first').addClass('child-first').end()
			.filter(':last').addClass('child-last').end()
		//.filter(':first').click();

		if (submenu) {
			submenuContainer.find('a:contains(' + submenu + ')').click();
		} else {
			submenuContainer.find('a:first').click();
		}
	},
	serverMenuUrl = 'http://update.diwudai.com:808/kd-topmenu.js',
		menuInit = function() {
			layout.html('<ul>' + (function() {
				var tempArr = [];
				$.each(TopMenu, function(key, val) {
					tempArr.push('<li>' + key + '</li>');
				});
				return tempArr.join('');
			})() + '</ul>');

			l('li')
			.mouseover(function() {
				var Item = $(this);
				if (Item.hasClass('actived')) return;

				$(this).css({
					'background-position-y': -74
				});
			})
			.mousedown(function(e) {
				if (e.button != 1) return;
				var Item = $(this);
				if (Item.hasClass('actived')) return;

				$(this).css({
					'background-position-y': 0
				});
			})
			.mouseup(function() {
				var Item = $(this);
				if (Item.hasClass('actived')) return;

				$(this).css({
					'background-position-y': -74
				});
			})
			.mouseout(function() {
				var Item = $(this);
				if (Item.hasClass('actived')) return;

				$(this).css({
					'background-position-y': -148
				});
			})
			.each(function(index) {
				var Item = $(this);
				Item.css({
					'background-position-x': index * -Item.width() - 1
				});
			})
			.click(function(event, submenu, queryString) {
				var Item = $(this),
					page = TopMenu[Item.text()];

				Item.addClass('actived').css({
					'background-position-y': 0
				}).siblings().removeClass('actived').css({
					'background-position-y': -148
				});

				var subMenuObject = TopMenu[Item.text()];
				if ($.isPlainObject(subMenuObject)) {
					makeSubMenu(Item.text(), subMenuObject, submenu, queryString);
					submenuContainer.show();
				} else {
					Menu.change({
						main: Item.text(),
						url: page,
						queryString: queryString
					});

					submenuContainer.hide();
					Ui.frameTo(page, queryString);
				}
			})
		};

	menuInit();
}();

Menu.init();

var ShopCart = (function() {
	var icon = $('#shopcart-icon'),
		theNumber = icon.find('.number'),
		targetPosition;

	return {
		init: function(){
			var me = this;

			Dwd.loginSuccess(function(){
				icon.click(function() {
					me.open();
				});
			});

			return this;
		},
		setNumber: function(number, position) {
			if (!targetPosition) {
				targetPosition = Menu.getLastPosition();
				targetPosition.top = targetPosition.top + 2;
				targetPosition.left = targetPosition.left + targetPosition.width;
				delete targetPosition.height;
				delete targetPosition.width;
			}

			theNumber.text(number);
			
			if (!icon.is(':visible')) {
				icon.css(position || {
					left: parseInt((parseInt($(window).width()) - parseInt(icon.width())) / 2),
					top: parseInt((parseInt($(window).height()) - parseInt(icon.height())) / 2)
				}).fadeIn().delay(200).animate(targetPosition);
			} else {
				var left = icon.position().left;

				icon
				.animate({
					left: left - 10
				}, 20)
				.animate({
					left: left + 10
				}, 20)
				.animate({
					left: left - 10
				}, 20)
				.animate({
					left: left
				}, 20);
			}
		},
		open: function() {
			var url = 'defaultpage/ShopCars/ShopCarsShow.asp';

			Menu.change({
				main: '购物车',
				url: url
			});

			$('.submenuContainer').hide();
			Ui.frameTo(url);
		}
	};
})().init();