var Progress = (function(){
	var	id,
		layout,
		title,
		progress,
		content,
		closeTrigger,
		l = function(selector){
			return layout.find(selector);
		},
		maxValue,
		currentValue;
		
	return {
		init: function(){
			var self = this;
			id = 'progress',
			layout = $('#' + id).hide(),
			title = layout.find('.title'),
			content = layout.find('.content'),
			progress = layout.find('.progress'),
			shadow = $('#fitDialog_shadow'),
			shadowCover = $('#fitDialog-shadow-cover'),
			closeTrigger = layout.find('.pur5_mask_close');

			closeTrigger
			.click(function(){
				self.hide();
			});
		},
		show: function(titleText, contentText, max_value){//
			//return false;
			maxValue = max_value;
			currentValue = 1;
			title.html(titleText + '&nbsp;');
			content.html(contentText);
			layout.show();
			Dwd.alert(layout);
		},
		hide: function(){
			try{
				layout.hide();
				shadowCover.hide();
				shadow.hide();
			}catch(e){}
		},
		val: function(total, bytes, contentText){
			if(!total) total = maxValue;
			if(!bytes){
				bytes = currentValue++;
			}
			
			var value = parseInt(bytes / total * 100);
			if(isNaN(value)){
				value = 0;
			}

			//progress.text(value);
			title.html(title.html().replace(/\d+%$/,'') + value + '%');
			if(contentText){
				content.html(contentText);
			}
		}
	}
})();
Progress.init();