var Shop = (function(){
	var me,
		id,
		nick,
		session,
		template = '<div class="shopList" header="1" footer="1" multible="0" actived="1">\
					  <table>\
						<thead>\
						  <tr>\
						  <th>店铺</th>\
							<th>状态</th>\
							<th>操作</th>\
						  </tr>\
						</thead>\
						<tbody>\
						<tr shopid="$shopid" session="$session" nick="$ww" data-wwid="$wwId">\
						<td align="center">$ww</td>\
						<td align="center">$st</td>\
						<td align="center"><span class="button2 del">删除</span></td>\
						</tr>\
						</tbody>\
					  </table>\
					</div>';
		
	return {
		init: function(){
			me = this;
			return me;
		},
		setData: function(Data){
			id = Data.id,
			nick = Data.nick,
			session = Data.session;
			$('.shopChange-btn span.shopNick').text(nick);
			Tb.Api.setData(Data);
		},
		getId: function(){
			if(!id){
				Tb.Api.authorise(function(){}, {});
				return false;
			}
			return id;
		},
		getNick: function(){
			return nick;
		},
		getSession: function(){
			return session;
		},
		set: function(Data, cb){
			TBS.append({
				session: Data.session,
				refresh_token: Data.refresh_token,
				ww: Data.ww,
				wwid: Data.wwid
			}, function(flag, errMsg){
				if(!flag){
					Dialog.tip('提交淘宝离线托管失败：<br />' + errMsg, 2500);
					return;
				}

				delete Data.shopid;
				Dwd.interface('更新店铺', 'taobao/TaobaoSessionSet.asp', $.extend(Data, {
					action: 'set',
					re_token: Data.refresh_token
				}), function(result, errMsg){
					if(!result){
						alert(errMsg);
						return false;
					}

					me.setData(Data);
					cb(result);
				});
			});
		},
		getByUserName: function(userName, cb){
			Dwd.interface('读取用户店铺列表', 'taobao/taobaoshopselect.asp',{
				username: userName
			}, function(result, errMsg){
				if(!result){
					alert(errMsg);
					return false;
				}
				cb(result);
			});
		},
		removeById: function(wwid, shopId, cb){
			Dwd.interface('删除指定店铺', 'taobao/TaobaoSessionSet.asp',{
				action: 'del',
				shopId: shopId
			}, function(result, errMsg){
				if(!result){
					alert(errMsg);
					return;
				}

				TBS.del({
					wwid: wwid
				}, function(Result, errMsg){
					if(!Result){
						alert(errMsg);
						return;
					}
					
					cb(result);
				});
			});
		},
		setDefault: function(shopId, cb){
			Dwd.interface('更新用户默认店铺', 'taobao/TaobaoSessionSet.asp',{
				action: 'u',
				shopId: shopId
			}, function(result, errMsg){
				if(!result){
					alert(errMsg);
					return false;
				}
				cb(result)
			});
		},
		change: function(cb){//店铺切换
			Shop.getByUserName(User.getName(), function(result){
				Dialog.alert({
					title: '店铺列表',
					content: template,
					style: {
						width: 350,
						height: 200
					},
					action: function($content){
						$content.find('.shopList').addClass('gridview').gridview().trigger('refresh', [{
							list: result.Lists
						}]).pur5UI().find('span.del').click(function(){
							var $row = $(this).parents('tr'),
								shopId = $row.attr('shopid'),
								shopName = $row.attr('nick'),
								wwid = $row.attr('data-wwid');
								
							Dialog.normalConfirm('店铺切换', '确定要删除店铺 ['+shopName+'] 吗？', function(){
								Shop.removeById(wwid, shopId, function(){
									var nextShopRow = $row.next(),
										NextShop = {
											id: nextShopRow.attr('shopid') || '',
											session: nextShopRow.attr('session') || '',
											nick: nextShopRow.attr('nick')  || ''											
										};
										
									Shop.setData(NextShop);
									
									if(NextShop.id){
										Shop.setDefault(NextShop.id, function(){
											cb && cb();
										});
									}else{
										cb && cb();
									}
								});
							});
						});
						$.each(result.Lists, function(index, shop){
							if(shop.ww == Shop.getNick()){
								$content.find('.shopList').trigger('active', [[index]]);
								return false;
							}
						});
					},
					button: {
						'确 定': function($content){
							var shop = $content.find('.shopList').triggerHandler('getRow', [function($row){
								return {
									id: $row.attr('shopid'),
									session: $row.attr('session'),
									nick: $row.attr('nick')
								}
							}, true]);
							
							if(!shop) return;
							
							if($('.info-shopName').text() == shop.nick) return;
							
							Shop.setData(shop);
							
							Shop.setDefault(shop.id, function(){
								cb && cb();
							});
						},
						'添 加': function(){
							Tb.Api.authorise(function(){
								cb && cb();
							}, {
								add: true,
								nick: '',
								manually: true
							});
						},
						'取 消': function(){}
					}
				});
			});
		}
	}
})().init();