var Snap = (function(){
	var template = '<div class="gridview" header="1" footer="0" actived="1">\
        <table>\
          <thead>\
            <tr>\
			  <th width="30"><input type="checkbox" class="noborder" /></th>\
              <th>截图</th>\
			  <th width="70">操作</th>\
            </tr>\
          </thead>\
          <tbody>\
            <tr>\
			  <td align="center" class="checker"><input type="checkbox" class="noborder" /></td>\
              <td><div class="snapItem" style="background-image:url($pic);"></div></td>\
			  <td align="center"><span class="button2 delBtn">删除</span></td>\
            </tr>\
          </tbody>\
        </table>\
      </div>';
	  
	var Data = [],
		basePath = '../snap/',
		Ax = loadActiveX({
			type: 'object',
			title: '软件截图',
			classId: '40EA84D1-04AE-40ED-B145-618E5CC673D4',
			callback: function(){
				return function(){

				}
			},
			Event: {
				onstart: function(){
					if(isHideUiWhenSnap){
						Ui.showTray();
						Ui.hide();
					}
				},
				oncancel: function(){
					Ui.show();
					Ui.hideTray();
				},
				onendcap: function(base64Pic){
					Ui.show();
					Ui.hideTray();

					var filePath = basePath + new Date().getTime() + '.jpg'
					Data.push({
						filePath: filePath,
						base64Pic: base64Pic
					});
					Fso.saveBase64Pic(filePath, base64Pic);
				}
			}
		}),
		isHideUiWhenSnap = false;

		Ax.mode = 2;
		Ax.picLevel = 80;
	
	return {
		get: function(){
			Dialog.alert({
				title: '截图提示',
				content: '截图时是否隐藏软件界面？',
				style: {
					width: 250,
					height: 30
				},
				button: {
					'确 定': false,
					'是': function(){
						isHideUiWhenSnap = true;
						Ax.start();
					},
					'否': function(){
						isHideUiWhenSnap = false;
						Ax.start();
					},
					'取 消': function(){}
				}
			});
		},
		del: function(i){//删除指定位置的图片
			Fso.del(Data[i].filePath);
			Data.splice(i,1);
		},
		clear: function(){
			var self = this;
			$.each(Data, function(index, snap){
				self.del(0);
			});
		},
		select: function(cb, closeCallback, width, height){//列表选择
			Dialog.alert({
				title: '截图选择',
				content: template,
				style: {
					width: width || 750,
					height: height || 410
				},
				closeCallback: closeCallback,
				button: {
					'确 定': function($content){
						var ids = $content.find('.gridview').triggerHandler('getRow', [false, true]),
							base64s = [];
						
						$.each(ids, function(index, i){
							base64s.push(Data[i].base64Pic);
						});
						cb && cb(base64s.join('[pur5]'));
					}
				},
				action: function($content){
					$content.find('.gridview').gridview().trigger('refresh', [{
						noResize: true,
						list: Data,
						filter: {
							pic: function(){
								return this.filePath
							}
						}
					}]).pur5UI().find('div.snapItem').css({
						height: 200,
						'background-repeat': 'no-repeat',
						border: '5px solid #ccc'
					}).end().find('span.delBtn').click(function(){
						var $row = $(this).parent().parent();
						Snap.del($row.index());
						$row.remove();
					});
				}
			});
		}
	}
})();

$(window).bind('unload', function(){
	Snap.clear();
});