var	Ui = (function(){
	var Ax = loadActiveX({
			type: 'new',
			title: 'UI组件',
			name: 'TrayControl.FSTray'
		}),
		Screen = (function(){
			var Ax = loadActiveX({
				type: 'object',
				title: '迷你浏览器',
				classId: 'B8232861-0E05-4179-8C6A-ED2B54FFDFCE'
			});

			return {
				get: function(){
					return {
						left: Ax.HtaWorkLeft,
						top: Ax.HtaWorkTop,
						width: Ax.HtaWorkWidth,
						height: Ax.HtaWorkHeight
					}
				},
				getMiniBrowserAx: function(){
					return Ax;
				}
			};
		})(),
		isTrayShow = false,
		isMax = false,
		Data = {
			maxlog: '../log/maxlog.pur5'
		},
		HtaControl = (function(){
			var Ax = loadActiveX({
				type: 'object',
				title: 'HTA界面控制',
				classId: '8AC2C463-17EE-4AF8-9C45-449FB915B506'
			});
			
			return {
				setPosition: function(Arg){
					Ax.SetWindowPos(Arg.left, Arg.top, Arg.width, Arg.height, 0);
				},
				show: function(){
					Ax.Show(1);
				},
				hide: function(){
					Ax.Show(0);
				}
			}
		})();

	if(!Ax) return false;

	return {
		init: function(){
			var me = this;

			Dwd.loginSuccess(function(){
				$('#login').hide();
				me.setTrayTitle('店宝宝 - ' + top.User.getName());
				me.setDragArea(0, 0, 1000, 34);

				if(Fso.read(Data.maxlog) == '1'){
					me.forceMax();
				}

				setTimeout(function(){
					me.layoutTo('#main');
					$('#main').trigger('resize');
				}, 50);
			});

			$(window).bind('beforeunload', function(){
				$('#frame').empty();
				CollectGarbage();
			});

			$(document)
			.on('keydown', function(e){//非调试模式禁止刷新
				if(e.keyCode == 116 && !Fso.read('debug_v2.pur5')){
					return false;
				}
			})
			.on('contextmenu dragstart selectstart', function(event){
				var e = event || window.event,
						et = e.srcElement || e.target;
				if (document.selection.createRange().text.length && et.tagName != 'A') {
					return true;
				}
				if (et.tagName != 'INPUT' && et.tagName != 'TEXTAREA') {
					return false;
				}
			});
			
			return this;
		},
		getScreen: function(){
			//return MiniBrowser.getScreen();
			return Screen.get();
		},
		getMiniBrowserAx: function(){
			return Screen.getMiniBrowserAx();
		},
		setTrayTitle: function(title){
			Ax.setName2('店宝宝', title);
		},
		HtaControl: HtaControl,
		show: function(){
			HtaControl.show();
			this.hideTray();
		},
		hide: function(){
			HtaControl.hide();
		},
		mini: function(){
			var miniObj = $('#winMinimizeActive');
			if(!miniObj.length){
				miniObj = $('<object id="winMinimizeActive" type="application/x-oleobject" classid="clsid:adb880a6-d8ff-11cf-9377-00aa003b7a11"\
							style="display:none;"><param name="Command" value="MINIMIZE"></object>').appendTo(document.body);
			}
			try{
				miniObj[0].Click();
			}catch(e){}
		},
		max: function(force){
			var vScreen = this.getScreen();

			var maxLayout = $('#main'),
				maxSize = maxLayout.attr('size');
			if(maxSize){
				Fso.del(Data.maxlog);
				maxSize = maxSize.split(',');
				this.resizeTo(parseInt(maxSize[0])+2, parseInt(maxSize[1])+2);
				$('#main').css({
					'border-width': 1,
					width: maxSize[0],
					height: maxSize[1]
				});
				this.setDragArea(0, 0, maxSize[0], 34);
				maxLayout.removeAttr('size');			
			}else{
				var width = vScreen.width,
					height = vScreen.height;
				this.resizeTo(width, height);
				$('#main')
				.attr('size', (maxLayout.width()) + ',' + (maxLayout.height()))
				.css({
					'border-width': 0,
					width: width,
					height: height
				});
				this.setDragArea(false);
				Fso.write(Data.maxlog, '1');
			}
			isMax = !isMax;
			
			Dwd.maxStatusChange(isMax);
		},
		forceMax: function(){
			if(!isMax){
				this.max();
			}
		},
		miniToTray: function(){
			this.showTray();
			this.hide();
		},
		showTray: function(msg){
			if(!msg && isTrayShow) return false;
			Ax.SetTipAndImage2(msg, 'images/1.ico');
			isTrayShow = true;
		},
		hideTray: function(){
			Ax.Clear();
			isTrayShow = false;
		},
		frameTo: function(url, queryString){
			if(!/^http:\/\//.test(url)) url = User.makeFullPath(url);
			
			if(!/\?/.test(url)) url += '?';
			url += '&_=' + Dwd.startTime;
			url += '&token=' + User.getToken();
			if(queryString){
				url += '&' + queryString;
			}
			
			var F = $('#frame iframe').css({
				visibility: 'hidden'
			});

			if(!F.length){
				var iframe = document.createElement('iframe');
				iframe.application = 'yes';
				iframe.frameborder = '0';
				iframe.src = '';
				$('#frame').empty().append(iframe);				
				F = $('#frame iframe');
				F.load(function(){
					F.css({
						visibility: 'visible'
					});
				});
			}

			F[0].contentWindow.document.location.href=(url);
		},
		getPosition: function(width, height, flag){
			width = parseInt(width),
			height = parseInt(height);
			
			var Screen = this.getScreen(),
				center = (Screen.width - width)/2 + Screen.left,
				middle = (Screen.height - height)/2 + Screen.top,
				right = (Screen.width - width) + Screen.left,
				bottom = Screen.height - height + Screen.top,
				left = Screen.left,
				top = Screen.top,
				positionHash = {
					'1': [left, top],
					'2': [center, top],
					'3': [right, top],
					'4': [left, middle],
					'5': [center, middle],
					'6': [right, middle],
					'7': [left, bottom],
					'8': [center, bottom],
					'9': [right, bottom],
					'10': [left, bottom + height],
					'11': [center, bottom + height],
					'12': [right, bottom + height]					
				},
				
				position = positionHash[flag || 5];
				
			return {
				left: position[0],
				top: position[1],
				position: positionHash
			};
		},
		pop: function(arg){
			Message.pop(arg);
		},
		openIE: function(url){
			var iePath = (Fso.getSystemFolder(42) || 'C:\\Program Files') + '\\Internet Explorer\\IEXPLORE.EXE';
			top.Fso.exec('"' + iePath + '" "' + (url || '') + '"');
		},
		layoutTo: function(layout){
			var $layout = $(layout);
			$layout.show().siblings().hide();
			this.resizeTo($layout.outerWidth(), $layout.outerHeight());
			this.setDragArea(0, 0, 1000, 34);
		},
		resizeTo: function(width, height, isNotCenter){
			var vScreen = this.getScreen();
			try{
				resizeTo(width, height);
				if(!isNotCenter) moveTo((vScreen.width - width) / 2 + vScreen.left, (vScreen.height - height) / 2 + vScreen.top);			
			}catch(e){}
		},
		setDragArea: function(left, top, width, height){//设置拖动区域
			if(left === false){
				Ax.SetMoveRegion(0, 0, 0, 0);
			}else{
				Ax.SetMoveRegion(left, top, width, height);
			}
			Ax.EnableMove(1);
		},		
		clearPop: function(){
			Ax.ClearMessage();
		},
		play: function(wavPath){
			Ax.PlayWav(wavPath);
		}
	}
})().init();