var	User = (function(){
	var uid,
		token,
		host,
		info,
		bigProxy,
		loginInfo = '../log/kd.pur5',
		from = '';

	return {
		isLogined: function(){
			return !!token;
		},
		getCode: function(cb){
			$.ajax({
				url: Dwd.makeFullPath('getcode.asp'),
				type: 'post',
				dataType: 'text',
				success: function(code){
					cb && cb(code);
				},
				error: function(){
					alert('网络异常，请切换其它服务器登录！');	
				}
			});
		},
		getFrom: function(){
			return from;
		},
		login: function(Arg, cb){//登录
			from = Arg.from;
			
			host = Arg.host;
			$.ajax({
				url: this.makeFullPath('login_do.asp?') + $.param({
					version: Dwd.version
				}),
				type: 'post',
				dataType: 'json',
				data: {
					username: Arg.uin,
					pass: Arg.pwd,
					h: Arg.h,
					from: Arg.from
				},
				success: function(result){
					var user,
						msg;
					try{
						msg = result.user_login_response.msg;
						user = result.user_login_response.user;
						token = result.user_login_response.token;
						bigProxy = result.user_login_response.isbigAgent;
					}catch(e){}
					
					if(user && Arg.remember && Arg.remember == 1){
						Fso.write(loginInfo, $.stringify({
							uin: Arg.uin,
							pwdEncode: Arg.pwdEncode,
							time: Arg.time,
							autologin: Arg.autologin
						}));
					}else{
						Fso.del(loginInfo);
					}
					info = user;
					cb(user, msg);
				},
				error: function(jqXhr, textStatus){
					cb(false, ajaxError('用户登录', jqXhr, textStatus));
				}
			});
		},
		loginOut: function(delUserInfo, cb){//注销
			if(!token) return false;

			var h,
				self = this;

			(function(){
				$(document.body).append('<object tabindex="2" id="Pur5EditAxforOut"\
						classid="CLSID:B5BA7BDA-71B1-484A-A39D-C461252DA228" width="100%" height="21" style="display:none;width:240px;border:1px solid #ccc;"></object>');

				var Ax =$('#Pur5EditAxforOut')[0];

				Ax.url = self.makeFullPath('getCode.asp?' + new Date().getTime());

				h = Ax.H1(0);
			})();
			
			if(delUserInfo){
				this.delLoginInfo();
			}
			
			$.ajax({
				url: this.makeFullPath('logout.asp'),
				data: {
					token: token,
					h: h
				},
				type: 'post',
				async: false,
				timeout: 3000,
				complete: function(){
					token = null;
					cb && cb();
				}
			});
		},
		getInfo: function(cb){
			parent.Dwd.interface('读取用户信息', 'UserInfo/Userinfo.asp',{
			}, function(result, errMsg){
				if(!result){
					alert(errMsg);
					return false;
				}
				cb(result);
			});
		},
		getName: function(){
			return info.username;
		},
		getLoginInfo: function(){
			var obj;
			try{
				obj = new Function('return ' + Fso.read(loginInfo))();
			}catch(e){}

			if(obj && obj.uin && obj.pwdEncode && obj.time){
				return obj;
			}else{
				return null;
			}
		},
		delLoginInfo: function(){
			Fso.del(loginInfo);
		},
		getHost: function(){
			return host;	
		},
		getToken: function(){
			return token;
		},
		ifBigProxy: function(){
			return info.isbigAgent;
		},
		makeFullPath: function(filePath){
			return str_replace('http://{1}/{2}', host, filePath);
		}
	}
})();