var Express = (function(){
	var template = '<div class="gridview" header="1" footer="0" actived="1">\
        <table>\
          <thead>\
            <tr>\
              <th width="120">时间</th>\
              <th>流转</th>\
            </tr>\
          </thead>\
          <tbody>\
            <tr>\
              <td align="center">$time</td>\
              <td>$context</td>\
            </tr>\
          </tbody>\
        </table>\
      </div>';

	return {
		Company: {
			'邮政国内小包': 'youzhengguonei',
	  		'E邮宝': 		'ems',
	  		'全峰': 		'quanfengkuaidi',
	  		'速尔': 		'suer',
	  		'中通': 		'zhongtong',
	  		'银捷': 		'yinjiesudi',
	  		'汇通': 		'huitongkuaidi',
	  		'宅急送': 		'zhaijisong',
	  		'天天': 		'tiantian',
	  		'韵达': 		'yunda',
	  		'EMS': 			'ems',
	  		'申通': 		'shentong',
	  		'圆通': 		'yuantong',
	  		'顺丰': 		'shunfeng',
	  		'优速': 		'youshuwuliu'
		},
		getCode: function(expressName){
			for(var shortName in this.Company){
				if(expressName.indexOf(shortName) == 0){
					return this.Company[shortName];
				}
			}

			return '';
		},
		showRouter: function(postid, expressName, type){
			if(!type){
				type = this.getCode(expressName);
			}

			$.ajax({
				url: parseData2Template('http://www.kuaidi100.com/query?type=$type&postid=$postid', {
					type: type,
					postid: postid
				}),
				dataType: 'text',
				success: function(routerText){
					var Result;
					try{
						Result = (new Function('return ' + routerText))();
					}catch(e){}
					
					if(!Result || !Result.status){
						alert('快递查询失败：' + routerText);
						return false;
					}
					
					if(Result.status != 200 || !Result.data){
						alert('快递查询失败：' + Result.message);
						return false;
					}
					
					Dialog.alert({
						title: '快递跟踪 - ' + expressName + ':' + postid,
						content: template,
						style: {
							width: 550,
							height: 351
						},
						action: function($content){
							$content.find('.gridview').gridview().trigger('refresh', [{
								list: Result.data.sort(function(a, b){
									return a.time>b.time?1:-1;
								})
							}]);
						}
					});
				},
				error: function(jqXhr){
					alert('快递查询错误：' + jqXhr.responseText);
				}
			});
		},
		router: function(expressName, postid, type){
			this.showRouter(postid, expressName, type);
		}
	}
})();