var FileBrowser = (function(){
	var Ax = loadActiveX({
		type: 'new',
		name: 'FileBrowser.FBrowser'
	});
	
	return {
		getFileName: function(path){
			return path.match(/[\\\/]([^\\\/]+?(\.\w+)?)$/)[1];
		},
		getFileExtName: function(path){
			return path.match(/\.(\w+)$/)[1];
		},
		getAllFiles: function(path){
			return Ax.GetAllFiles(path);
		},
		getTempFolder: function(){
			return Ax.GetTempFolder();
		},
		getAppDataFolder: function(){
			return Ax.GetAppDataFolder();
		}
	}
})();