var FileTransfer = (function(){
	var me,
		Ax = loadActiveX({
			type: 'object',
			classId: '0607442D-F5E5-484B-BBD4-BCB3B38FEF6B',
			callback: function(){
				return me.event.callback;
			},
			Event: {
				OnDownProgress: function(total, bytes){
					return arguments2object(arguments);
				},
				OnDownloadEnd: function(){
					return null;
				},
				OnDownloadError: function(errCode){
					return {
						timeout: errCode != 0,
						errCode: errCode
					};
				},
				uploadEnd: function(srcPath, desPath){
					return arguments2object(arguments)
				},
				OnUploadError: function(errorCode){
					return {
						errorCode: errorCode,
						errMsg: Ax.ErrMsg
					};
				}
			}
		}),
		callback,
		timeout = 1000 * 10,
		timer;


	return {
		init: function(){
			me = this;
			return this;
		},
		event: {
			callback: function(eventName, Arg){
				if(eventName != 'downProgress'){
					clearTimeout(timer);
				}

				callback && callback(eventName, Arg);
			}
		},
		action: {
			stopDownload: function(arg){
				Ax.TerminateDownload(arg.url);
			},
			stopUpload: function(arg){
				Ax.TerminateUpload(arg.url);
			}
		},
		decompress: function(rarFilePath, desPath){
			Ax.Decompress(rarFilePath, desPath);
		},
		uploadTbPic: function(arg){
			callback = arg.callback;

			timer = setTimeout(function(){
				me.action.stopUpload({
					url: arg.filePath
				});
				me.event.callback('uploadError', {
					timeout: true,
					errCode: ''
				});
			}, arg.timeout || timeout);			

			Ax.Upload(arg.filePath);
		},
		download: function(arg){
			callback = arg.callback;

			Ax.RecvTimeout = arg.timeout || timeout;
			Ax.Download(arg.url, arg.savePath);
		}
	}
})().init();