var Fso = (function(){
	var Ax = loadActiveX({
			title: 'pur5UtilAx',
			type: 'new',
			name: 'pur5Util.pur5UtilAx.1'
		}),
		Fb = loadActiveX({
			title: 'FileBrowser',
			type: 'new',
			name: 'FileBrowser.FBrowser'
		});

	if(!Ax || !Fb){

	}
	
	var appdir = decodeURI(document.location.href)
				.replace(/\/[^\/]+$/,'/')
				.replace('file:///', '');
	
	return {
		makeFullPath: function(path){
			if(/^"?[A-Z]:[\/\\]/i.test(path)){//绝对路径
				return path;
			}else if(/^".+"$/.test(path)){//前后都有引号的相对路径
				return '"' + appdir + path.replace(/^"/, '');
			}else{//普通相对路径
				return appdir + path;
			}
		},
		read: function(filePath){
			filePath = this.makeFullPath(filePath);
			var content = '', tmp;
			try{
				Ax.Open(filePath, 1);
				while(tmp = Ax.Read()){
					content += tmp;
				}
				Ax.Close();
			}catch(e){}
			return content;
		},
		readUnicode: function(filePath){
			filePath = this.makeFullPath(filePath);
			var content = '', tmp;
			try{
				Ax.Open(filePath, 1);
				while(tmp = Ax.ReadU()){
					content += tmp;
				}
				Ax.Close();
			}catch(e){}
			return content;
		},
		readUtf8: function(filePath){
			filePath = this.makeFullPath(filePath);
			var content = '', tmp;
			try{
				Ax.Open(filePath, 1);
				while(tmp = Ax.ReadUTF8()){
					content += tmp;
				}
				Ax.Close();
			}catch(e){}
			return content;
		},
		asynWrite: function(filePath, content, cb){
			filePath = this.makeFullPath(filePath);
			var self = this,
				index = 0,
				blockLength = 500,
				writeContent;
				
			this.write(filePath, '');
			(function(){
				var func = arguments.callee;
				
				writeContent = content.substring(index*blockLength, index*blockLength+blockLength);
				if(!writeContent){
					cb();
				}else{
					self.append(filePath, writeContent);
					index += 1;
					setTimeout(func, 10);
				}
			})();
		},
		write: function(filePath, content){
			filePath = this.makeFullPath(filePath);
			if(!this.del(filePath)) return false;
			try{
				Ax.Open(filePath, 0);
				Ax.Write(content);
				Ax.Close();
				return true;
			}catch(e){
				try{
					Ax.Close();
				}catch(e){}
				return false;
			}
		},
		writeUtf8: function(filePath, content){
			filePath = this.makeFullPath(filePath);
			if(!this.del(filePath)) return false;
			try{
				Ax.Open(filePath, 0);
				Ax.WriteUTF8(content);
				Ax.Close();
				return true;
			}catch(e){
				try{
					Ax.Close();
				}catch(e){}
				return false;
			}
		},
		append: function(filePath, content){
			filePath = this.makeFullPath(filePath);
			try{
				Ax.Open(filePath, 0);
				Ax.Append(content);
				Ax.Close();
				return true;
			}catch(e){
				return false;
			}
		},
		saveBase64Pic: function(filePath, content){
			filePath = this.makeFullPath(filePath);
			Ax.DecodeToFile(content, filePath);
		},
		del: function(filePath){
			filePath = this.makeFullPath(filePath);
			var exists = this.fileExists(filePath);
			if(!exists) return true;
			try{
				Ax.Delete(filePath);
				return true;
			}catch(e){
				return false;
			}
		},
		getSystemFolder: function(floaderId){
			try{
				return Fb.GetFolder(parseInt(floaderId));
			}catch(e){
				return '';
			}
		},		
		getAppDataFolder: function(){
			return Fb.GetAppDataFolder();
		},
		getTempFolder: function(){
			return Fb.GetTempFolder();
		},
		getAllFiles: function(folder){			
			return Fb.GetAllFiles(folder);
		},
		fileExists: function(filePath){
			filePath = this.makeFullPath(filePath);
			try{
				Ax.Open(filePath, 1);
				Ax.Close();
				return true;
			}catch(e){
				return false;
			}
		},
		exec: function(filePath){
			filePath = this.makeFullPath(filePath);
			try{
				Ax.Exec(filePath);
				return true;
			}catch(e){
				alert('命令执行错误：' + filePath + '\n错误：' + e.description);
				return false;
			}
		}
	}
})();