var ImageTool = (function(){
	var Ax = loadActiveX({
			name: 'ImageTool.ImageAx'
		}),
		BgMixAx = loadActiveX({
			name: 'Pur5Photo.Mix'
		});

	return {
		init: function(){
			var me = this;

			return this;
		},
		compress: function(path, savePath){
			var height = Ax.GetH(path),
				width = Ax.getW(path),
				path_after = savePath || path.replace(/(\.\w+)$/, '_2$1');
			
			//if(height <= 500 && width <= 500) return path;
			
			Ax.Scale(path, width, height, path_after, true);	
			return path_after;
		},
		mix: function(arg){
			BgMixAx.Init();

			BgMixAx.MixPic(
				arg.src,
				arg.background.image,
				arg.dst,
				arg.border.width,
				parseInt(arg.border.color.substr(1).match(/\w\w/g).reverse().join(''), 16),
				arg.background.width
			);
			BgMixAx.Shutdown();
		}
	}
})().init();