var MiniBrowser = (function(){
	var me,
		Ax = loadActiveX({
			title: '迷你浏览器控件',
			type: 'object',
			Ax: Ui.getMiniBrowserAx(),
			name: 'MiniBrowserAx.Browser',
			//classId: 'B8232861-0E05-4179-8C6A-ED2B54FFDFCE',
			callback: function(){
				return me.event.callback;
			},
			Event: {
				OnClose: function(){
					return null;
				},
				OnNewWindow: function(WinObj){
					return {
						Win: WinObj.getAttribute('wnd'),
						url: WinObj.getAttribute('bstrUrl'),
						cancel: function(){
							WinObj.setAttribute('Cancel', true);
						},
						location: function(url){
							pDisp.getAttribute('wnd').location.href = url;
						}
					};
				},
				OnDocumentComplete: function(Win, url, content, cookie){
					Win = Win.parentWindow;
					return arguments2object(arguments);
				},
				OnNavigateComplete2: function(Win, url){
					return arguments2object(arguments);
				},
				OnBeforeNavigate2: function(Navigator){
					var Win = Navigator.getAttribute('wnd'),
						url = Navigator.getAttribute('Url'),
						targetFrameName = Navigator.getAttribute('TargetFrameName'),
						postData = Navigator.getAttribute('PostData'),
						headers = Navigator.getAttribute('Headers');

					return {
						Win: Win,
						url: url,
						targetFrameName: targetFrameName,
						postData: postData,
						headers: headers,
						cancel: function(flag){
							Navigator.setAttribute('Cancel', true);
						}
					};
				}
			}
		}),
		callback;

	return {
		init: function(){
			me = this;

			return this;
		},
		getScreen: function(){
			return {
				left: Ax.HtaWorkLeft,
				top: Ax.HtaWorkTop,
				width: Ax.HtaWorkWidth,
				height: Ax.HtaWorkHeight
			}
		},
		event: {
			callback: function(eventName, Arg){

				callback && callback(Arg, eventName);

				if(eventName == 'close'){
					me.hide({
						blank: true
					});
				}
			}
		},
		setTop: function(bTop){
			Ax.SetTopMost(!!bTop);
		},
		setTitle: function(title){
			try{
				Ax.SetTitle(title);
			}catch(e){}
		},
		setPosition: function(width, height, position){
			var Screen = this.getScreen();
			Ax.SetRect(parseInt((Screen.width - width)/2) + Screen.left, parseInt((Screen.height - height)/2) + Screen.top, width, height);
		},
		openWindow: function(url, cb){
			callback = cb;
			Ax.Show(true);
			Ax.Navagate(url);
			Ax.SetTopMost(true);
		},
		postWindow: function(url, params, cb){
			callback = cb;
			Ax.Show(true);
			Ax.Post(url, params);
		},
		navigate: function(Arg){
			Arg = $.extend({
				url: '',
				params: '_=' + new Date().getTime(),
				type: 'get',
				hide: false,
				title: '',
				position: 5,
				width: 700,
				height: 500,
				top: false
			}, Arg);

			callback = Arg.callback;

			if(Arg.type.toLowerCase() == 'post'){
				Ax.Post(Arg.url, Arg.params);
			}else{
				Ax.Navagate(Arg.url);
			}

			setTimeout(function(){
				me.setTitle(Arg.title);
				me.show(!Arg.hide);
				if(!Arg.hide){
					me.setPosition(Arg.width, Arg.height, Arg.position);
				}
				me.setTop(Arg.top);
			}, 50);
		},
		show: function(flag, width, height, position){
			Ax.Show(!!flag);

			if(flag && width && height){
				me.setPosition(width, height, position || 5);
			}
		},
		hide: function(Arg){
			Ax.Show(false);

			if(Arg && Arg.blank){
				callback = null;
				Ax.Navagate('about:blank');
			}			
		},
		getCookie: function(){
			Ax.Show(false);
			return Ax.cookie;
		}
	}
})().init();