var Module = (function(){
	var loadedModules = [],
		typeReg = /<div[\s\S]+?class="(\w+)"/,
		typeHash = {
			layout_content_in: '.layout_content',
			pur5_mask_show: '#pur5LayoutMain'
		};

	return {
		load: function(moduleName, container){
			if($.inArray(moduleName, loadedModules) > -1) return false;
			
			var moduleContent = Fso.readUtf8('module/' + moduleName + '/html.html')
								.replace(/id="/, 'modulepath="$modulePath" id="')
								.replace(/src="script\/main\.js"/, 'src="$modulePathscript/main.js"')
								.replace(/href="style\/css\.css"/, 'href="$modulePathstyle/css.css"')
								.replace(/\$modulePath/gi,'module/' + moduleName + '/'),
				contentId = moduleContent.match(/id="([^"]+)"/);

			(container || $(typeHash[moduleContent.match(typeReg)[1]])).append(moduleContent);
			if(contentId && contentId[1]) $('#'+contentId[1]).pur5UI();

			loadedModules.push(moduleName);
		},
		loads: function(moduleNameArr, container){
			var index = 0, moduleName;
			while(moduleName = moduleNameArr[index++]){
				this.load(moduleName, container);
			}
		}
	};
})();