var ServerModule = (function(){		
	var loadedModules = [],
		timeStamp = '?_=' + new Date().getTime(),
		rootPath;

	return {
		init: function(Arg){
			rootPath = Arg.rootPath;
			return this;
		},
		load: function(moduleName, container, cb){
			var modulePath = rootPath + moduleName + '/';

			$.ajax({
				url: modulePath + 'html.html' + timeStamp,
				success: function(moduleHTMLContent){
					var Files = getFields({
						type: 'js',
						url: 1
					}, moduleHTMLContent, /<script.+?src="(.+?)"/gi);

					Files = Files.concat(getFields({
						type: 'css',
						url: 1
					}, moduleHTMLContent, /<link href="(.+?)"/gi));

					moduleHTMLContent = moduleHTMLContent
										.replace(/<\/?script.*?>|<link.+?>/gi, '');

					(container || $(document.body)).append(moduleHTMLContent);

					$.include(modulePath, $.map(Files, function(File, index){
						return File.url;
					}), function(){
						loadedModules.push(moduleName);
						cb && cb();
					});
				}
			});
		},
		loads: function(moduleNames, cb, container){
			var me = this,
				index = 0;						

			(function(){
				var func = arguments.callee,
					moduleName = moduleNames[index++];

				if(!moduleName){
					cb();
					return;
				}

				me.load(moduleName, container, func);
			})();
		}
	}
})();