/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.ui.toolkit.ImageOnlyButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JToggleButton;

class BigLinkedText
extends JToggleButton {
    BigLinkedText(String text) {
        this.setText(null);
        this.setRolloverEnabled(true);
        this.setIcon(BigLinkedText.getNormalIcon(text));
        this.setPressedIcon(BigLinkedText.getPressedIcon(text));
        this.setSelectedIcon(BigLinkedText.getSelectedIcon(text));
        this.setRolloverIcon(BigLinkedText.getRolloverIcon(text));
        ImageOnlyButton.setStyle(this);
    }

    private static Icon getNormalIcon(String text) {
        return BigLinkedText.getIcon(text, Color.gray);
    }

    private static Icon getPressedIcon(String text) {
        return BigLinkedText.getIcon(text, Color.white);
    }

    private static Icon getSelectedIcon(String text) {
        return BigLinkedText.getIcon(text, Color.white);
    }

    private static Icon getRolloverIcon(String text) {
        return BigLinkedText.getIcon(text, Color.lightGray);
    }

    private static Icon getIcon(String text, Color color) {
        JLabel label = BigLinkedText.getBigLabel(text, color);
        BufferedImage image = BigLinkedText.getImage(label);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        label.paint(g);
        g.dispose();
        return new ImageIcon(image);
    }

    private static JLabel getBigLabel(String text, Color color) {
        JLabel label = new JLabel(text);
        Font font = label.getFont();
        font = font.deriveFont(30.0f);
        label.setFont(font);
        label.setForeground(color);
        Dimension size = label.getPreferredSize();
        label.setSize(size);
        return label;
    }

    private static BufferedImage getImage(JLabel label) {
        Dimension size = label.getSize();
        return new BufferedImage(size.width, size.height, 2);
    }

    public static void main(String[] args) {
        BigLinkedText text = new BigLinkedText("hello");
        JFrame frame = new JFrame("BigLinkedText");
        frame.getContentPane().add(text);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

