/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.Locale;
import com.lightcrafts.license.LicenseChecker;
import com.lightcrafts.platform.AlertDialog;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.platform.ProgressDialog;
import com.lightcrafts.utils.ProgressIndicator;
import com.lightcrafts.utils.Version;
import com.lightcrafts.utils.WebBrowser;
import com.lightcrafts.utils.thread.ProgressThread;
import com.lightcrafts.utils.xml.ElementFilter;
import com.lightcrafts.utils.xml.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class CheckForUpdate {
    private static final Preferences m_prefs;
    private static int m_updateRevision;
    private static String m_updateURL;
    private static String m_updateVersion;
    private static final String CHECK_FOR_UPDATE_KEY = "CheckForUpdate";
    private static final String CHECK_HOST = "versions.lightcrafts.com";
    private static URL CHECK_URL;
    private static final String CHECK_URL_STRING;
    private static final String CUSTOMER;
    private static final long DELTA_FOR_LATER = 604800000L;
    private static final short DOWNLOAD_NOW = 0;
    private static final short REMIND_LATER = 1;
    private static final short DO_NOT_REMIND = 2;
    private static final String IS_UPDATE_AVAILABLE_KEY = "isUpdateAvailable";
    private static final String LAST_VERSION_KEY = "lastVersion";
    private static final String LATER_KEY = "later";
    private static final String REMIND_KEY = "remind";
    private static boolean m_testing;

    public static void checkNowAndWait() {
        if (!CheckForUpdate.hasInternetConnection()) {
            AlertDialog alert = Platform.getPlatform().getAlertDialog();
            alert.showAlert(null, Locale.LOCALE.get("NoInternetConnectionErrorMajor"), Locale.LOCALE.get("NoInternetConnectionErrorMinor"), 2, Locale.LOCALE.get("CheckForUpdateOKButton"));
            return;
        }
        if (CheckForUpdate.isUpdateAvailable(true)) {
            CheckForUpdate.showDownloadNowOrCancelAlert();
            return;
        }
        ProgressDialog progress = Platform.getPlatform().getProgressDialog();
        SynchronousCheckThread checkThread = new SynchronousCheckThread(progress);
        progress.showProgress(null, checkThread, Locale.LOCALE.get("CheckingForUpdateMessage"), false);
        Throwable t = progress.getThrown();
        if (t != null) {
            AlertDialog alert = Platform.getPlatform().getAlertDialog();
            alert.showAlert(null, Locale.LOCALE.get("CheckingForUpdateProblem"), t.getLocalizedMessage(), 2, Locale.LOCALE.get("CheckForUpdateOKButton"));
            return;
        }
        if (checkThread.isUpdateAvailable()) {
            CheckForUpdate.showDownloadNowOrCancelAlert();
        } else {
            CheckForUpdate.showNoUpdateIsAvailableAlert();
        }
    }

    public static void showAlertIfAvailable() {
        if (CheckForUpdate.shouldCheckForUpdate() && CheckForUpdate.isUpdateAvailable(true)) {
            CheckForUpdate.showDownloadNowOrLaterAlert();
        }
    }

    public static void start() {
        if (!CheckForUpdate.shouldCheckForUpdate()) {
            return;
        }
        if (CheckForUpdate.remindLaterAndIsNotLater()) {
            return;
        }
        if (CheckForUpdate.isUpdateAvailable(false)) {
            return;
        }
        new BackgroundCheckThread().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkIfUpdateIsAvailable() throws IOException {
        int currentRevision = Version.getRevisionNumber();
        if (!m_testing && currentRevision <= 0) {
            return false;
        }
        URLConnection conn = CHECK_URL.openConnection();
        conn.setUseCaches(false);
        InputStream is = conn.getInputStream();
        try {
            Document versionDoc = XMLUtil.readDocumentFrom(is);
            if (!CheckForUpdate.parseVersionsDocument(versionDoc)) {
                boolean bl = false;
                return bl;
            }
            if (m_updateRevision > currentRevision) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            is.close();
        }
        return false;
    }

    private static String getUpdateIsAvailableMessage() {
        return Locale.LOCALE.get("UpdateIsAvailableMessage", m_updateVersion, Version.getApplicationName());
    }

    private static boolean hasInternetConnection() {
        Platform platform = Platform.getPlatform();
        return platform.hasInternetConnectionTo(CHECK_HOST);
    }

    private static boolean isUpdateAvailable(boolean reset) {
        try {
            if (m_prefs.getBoolean(IS_UPDATE_AVAILABLE_KEY, false)) {
                if (reset) {
                    m_prefs.putBoolean(IS_UPDATE_AVAILABLE_KEY, false);
                    CheckForUpdate.syncPrefs();
                }
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return false;
    }

    private static boolean parseVersionsDocument(Document doc) {
        m_updateRevision = 0;
        m_updateURL = "";
        m_updateVersion = "";
        Element root = doc.getDocumentElement();
        Element version = (Element)XMLUtil.getFirstChildOf(root, new VersionFilter());
        if (version == null) {
            return false;
        }
        Element number = (Element)XMLUtil.getFirstChildOf(version, new ElementFilter("number"));
        if (number == null) {
            return false;
        }
        m_updateVersion = XMLUtil.getTextOfFirstTextChildOf(number);
        Element revision = (Element)XMLUtil.getFirstChildOf(version, new ElementFilter("revision"));
        if (revision == null) {
            return false;
        }
        String updateRevision = XMLUtil.getTextOfFirstTextChildOf(revision);
        try {
            m_updateRevision = Integer.parseInt(updateRevision);
        }
        catch (NumberFormatException e) {
            return false;
        }
        Element url = (Element)XMLUtil.getFirstChildOf(version, new ElementFilter("url"));
        if (url == null) {
            return false;
        }
        m_updateURL = XMLUtil.getTextOfFirstTextChildOf(url);
        return true;
    }

    private static boolean remindLaterAndIsNotLater() {
        try {
            if (m_prefs.getInt(REMIND_KEY, 0) == 1) {
                long later;
                long now = System.currentTimeMillis();
                return now < (later = m_prefs.getLong(LATER_KEY, 0L));
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return false;
    }

    private static boolean shouldCheckForUpdate() {
        try {
            return m_prefs.getBoolean(CHECK_FOR_UPDATE_KEY, true);
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    private static void showDownloadNowOrCancelAlert() {
        AlertDialog alert = Platform.getPlatform().getAlertDialog();
        int button = alert.showAlert(null, CheckForUpdate.getUpdateIsAvailableMessage(), null, 1, Locale.LOCALE.get("DownloadNowButton"), Locale.LOCALE.get("DownloadCancelButton"));
        if (button == 0) {
            WebBrowser.browse(m_updateURL);
        }
    }

    private static void showDownloadNowOrLaterAlert() {
        AlertDialog alert = Platform.getPlatform().getAlertDialog();
        int button = alert.showAlert(null, CheckForUpdate.getUpdateIsAvailableMessage(), null, 1, Locale.LOCALE.get("DownloadNowButton"), Locale.LOCALE.get("RemindMeLaterButton"), Locale.LOCALE.get("DontRemindMeButton"));
        try {
            switch (button) {
                case 0: {
                    WebBrowser.browse(m_updateURL);
                    return;
                }
                case 2: {
                    m_prefs.putInt(REMIND_KEY, 2);
                    m_prefs.put(LAST_VERSION_KEY, m_updateVersion);
                    m_prefs.remove(LATER_KEY);
                    break;
                }
                case 1: {
                    m_prefs.putInt(REMIND_KEY, 1);
                    long now = System.currentTimeMillis();
                    m_prefs.putLong(LATER_KEY, now + 604800000L);
                    m_prefs.remove(LAST_VERSION_KEY);
                }
            }
            CheckForUpdate.syncPrefs();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static void showNoUpdateIsAvailableAlert() {
        AlertDialog alert = Platform.getPlatform().getAlertDialog();
        alert.showAlert(null, Locale.LOCALE.get("NoUpdateIsAvailableMessage"), null, 1, Locale.LOCALE.get("CheckForUpdateOKButton"));
    }

    private static void syncPrefs() {
        try {
            m_prefs.sync();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        String licenseText = LicenseChecker.checkLicense();
        m_testing = true;
        Document doc = XMLUtil.readDocumentFrom(new File("/tmp/versions.xml"));
        CheckForUpdate.parseVersionsDocument(doc);
        System.exit(0);
    }

    static {
        CHECK_URL_STRING = "http://versions.lightcrafts.com/products/" + Version.getApplicationName().toLowerCase() + "/versions.xml";
        try {
            CHECK_URL = new URL(CHECK_URL_STRING);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        String customer = System.getProperty("customer");
        CUSTOMER = customer != null && customer.length() > 0 ? customer : "generic";
        m_prefs = Preferences.userRoot().node("com/lightcrafts/app");
    }

    private static final class VersionFilter
    extends ElementFilter {
        private static final String m_osName = System.getProperty("os.name").toLowerCase();

        @Override
        public boolean accept(Node node) {
            boolean platformMatches;
            boolean productMatches;
            if (!super.accept(node)) {
                return false;
            }
            Element element = (Element)node;
            String product = element.getAttribute("product").toLowerCase();
            boolean bl = VersionFilter.isAny(product) || product.equals(LicenseChecker.isBasic() ? "basic" : "full") ? true : (productMatches = false);
            if (!productMatches) {
                return false;
            }
            String platform = element.getAttribute("platform").toLowerCase();
            boolean bl2 = platformMatches = VersionFilter.isAny(platform) || m_osName.contains(platform);
            return platformMatches;
        }

        VersionFilter() {
            super("version", "customer", CUSTOMER);
        }

        private static boolean isAny(String s) {
            return s.length() == 0 || s.equals("all") || s.equals("any");
        }
    }

    private static final class SynchronousCheckThread
    extends ProgressThread {
        private boolean m_isUpdateAvailable;

        @Override
        public void run() {
            try {
                this.m_isUpdateAvailable = CheckForUpdate.checkIfUpdateIsAvailable();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        SynchronousCheckThread(ProgressIndicator indicator) {
            super(indicator);
        }

        boolean isUpdateAvailable() {
            return this.m_isUpdateAvailable;
        }
    }

    private static final class BackgroundCheckThread
    extends Thread {
        @Override
        public void run() {
            if (!CheckForUpdate.hasInternetConnection()) {
                return;
            }
            try {
                if (!CheckForUpdate.checkIfUpdateIsAvailable()) {
                    return;
                }
            }
            catch (Throwable t) {
                return;
            }
            try {
                String lastVersion = m_prefs.get(CheckForUpdate.LAST_VERSION_KEY, "");
                if (lastVersion.equals(m_updateVersion)) {
                    return;
                }
                m_prefs.putBoolean(CheckForUpdate.IS_UPDATE_AVAILABLE_KEY, true);
                CheckForUpdate.syncPrefs();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        BackgroundCheckThread() {
            super("CheckForUpdate.BackgroundCheckThread");
            this.setDaemon(true);
        }
    }
}

