/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.AbstractLayout;
import com.lightcrafts.app.Application;
import com.lightcrafts.app.BrowserLayout;
import com.lightcrafts.app.BrowserSelectionMemory;
import com.lightcrafts.app.ComboLayout;
import com.lightcrafts.app.EditorLayout;
import com.lightcrafts.app.LayoutHeader;
import com.lightcrafts.app.Locale;
import com.lightcrafts.app.LznImageGroupProvider;
import com.lightcrafts.app.LznPreviewProvider;
import com.lightcrafts.app.OtherApplicationShim;
import com.lightcrafts.app.SaveResult;
import com.lightcrafts.app.advice.AdviceManager;
import com.lightcrafts.app.menu.ComboFrameMenuBar;
import com.lightcrafts.app.menu.WindowMenu;
import com.lightcrafts.app.other.OtherApplication;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.model.Scale;
import com.lightcrafts.platform.AlertDialog;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.platform.ProgressDialog;
import com.lightcrafts.prefs.ApplicationMode;
import com.lightcrafts.templates.TemplateDatabase;
import com.lightcrafts.templates.TemplateKey;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.MemoryMeter;
import com.lightcrafts.ui.browser.ctrls.FolderCtrl;
import com.lightcrafts.ui.browser.folders.FolderBrowserPane;
import com.lightcrafts.ui.browser.folders.FolderTreeListener;
import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.model.ImageDatumComparator;
import com.lightcrafts.ui.browser.model.ImageList;
import com.lightcrafts.ui.browser.model.PreviewUpdater;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.BrowserFactory;
import com.lightcrafts.ui.browser.view.ExternalBrowserAction;
import com.lightcrafts.ui.browser.view.ImageBrowserEvent;
import com.lightcrafts.ui.browser.view.ImageBrowserListener;
import com.lightcrafts.ui.browser.view.ImageBrowserScrollPane;
import com.lightcrafts.ui.browser.view.TemplateProvider;
import com.lightcrafts.ui.editor.DisabledEditor;
import com.lightcrafts.ui.editor.DocUndoHistory;
import com.lightcrafts.ui.editor.Document;
import com.lightcrafts.ui.editor.DocumentListener;
import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.editor.ScaleListener;
import com.lightcrafts.ui.editor.ScaleModel;
import com.lightcrafts.ui.editor.assoc.DocumentDatabase;
import com.lightcrafts.ui.editor.assoc.DocumentDatabaseListener;
import com.lightcrafts.ui.export.SaveOptions;
import com.lightcrafts.ui.metadata2.MetadataScroll;
import com.lightcrafts.ui.templates.TemplateControl;
import com.lightcrafts.ui.templates.TemplateControlListener;
import com.lightcrafts.ui.toolkit.UICompliance;
import com.lightcrafts.utils.Version;
import com.lightcrafts.utils.filecache.FileCacheFactory;
import com.lightcrafts.utils.thread.ProgressThread;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.filechooser.FileSystemView;

public class ComboFrame
extends JFrame
implements ComponentListener,
DocumentDatabaseListener,
DocumentListener,
ImageBrowserListener,
ScaleListener,
WindowFocusListener,
TemplateControlListener,
MouseWheelListener {
    public static final Image IconImage;
    static ComboFrame LastActiveComboFrame;
    private Document doc;
    private AbstractLayout layout;
    private AbstractImageBrowser browser;
    private ImageList images;
    private FolderCtrl folders;
    private FolderTreeListener folderListener;
    private ImageBrowserScrollPane browserScroll;
    private MetadataScroll info;
    private DisabledEditor disabledEditor;
    private Editor editor;
    private DocUndoHistory history;
    private TemplateControl templates;
    private LayoutHeader header;
    private PropertyChangeListener toolButtonListener;
    private AdviceManager advice;
    private boolean isEditorVisible;
    private boolean isBrowserVisible;
    private ComboFrameMenuBar menus;
    private File recentFolder;
    private MemoryMeter memory;
    private Rectangle unMaximizedBounds;
    private boolean focusPausedFlag;
    private TemplateProvider templateProvider = new TemplateProvider(){

        @Override
        public List getTemplateActions() {
            try {
                return TemplateDatabase.getTemplateKeys();
            }
            catch (TemplateDatabase.TemplateException e) {
                e.printStackTrace();
                return new ArrayList();
            }
        }

        @Override
        public void applyTemplateAction(Object action, File[] targets) {
            TemplateKey key = (TemplateKey)action;
            Application.applyTemplate(ComboFrame.this, targets, key);
        }

        @Override
        public void applyTemplate(File file, File[] targets) {
            Application.applyTemplate(ComboFrame.this, targets, file);
        }
    };
    private ExternalBrowserAction printAction = new ExternalBrowserAction(){

        @Override
        public String getName() {
            return Locale.LOCALE.get("BrowserPrintMenuItem");
        }

        @Override
        public void actionPerformed(File file, File[] files) {
            Application.print(ComboFrame.this, file);
        }
    };
    private ExternalBrowserAction exportAction = new ExternalBrowserAction(){

        @Override
        public String getName() {
            return Locale.LOCALE.get("BrowserExportMenuItem");
        }

        @Override
        public void actionPerformed(File file, File[] files) {
            if (files.length == 1) {
                Application.export(ComboFrame.this, file);
            } else {
                Application.export(ComboFrame.this, files);
            }
        }
    };

    ComboFrame() {
        if (LastActiveComboFrame == null) {
            LastActiveComboFrame = this;
        }
        this.setIconImage(IconImage);
        this.addWindowFocusListener(this);
        this.addComponentListener(this);
        if (System.getProperty("lightcrafts.debug") != null) {
            this.initMemoryMeter();
        }
        this.folders = new FolderCtrl();
        this.browserScroll = new ImageBrowserScrollPane();
        this.browserScroll.setMinimumSize(new Dimension(120, 120));
        this.disabledEditor = Document.createDisabledEditor(new DisabledEditor.Listener(){

            @Override
            public void imageClicked(Object key) {
                PreviewUpdater updater = (PreviewUpdater)key;
                File file = updater.getFile();
                Application.open(ComboFrame.this, file);
            }
        });
        this.editor = this.disabledEditor;
        this.editor.getImage().setMinimumSize(new Dimension(120, 120));
        this.history = new DocUndoHistory();
        this.templates = new TemplateControl(null, this);
        this.menus = new ComboFrameMenuBar(this);
        this.setJMenuBar(this.menus);
        File folder = this.folders.getSelection();
        if ((folder == null || !folder.exists()) && this.folders.goToPicturesFolder()) {
            folder = this.folders.getSelection();
        }
        if (folder == null || !folder.exists()) {
            folder = new File(System.getProperty("user.home"));
        }
        this.advice = new AdviceManager(this);
        this.showFolder(folder, true);
        this.info = new MetadataScroll();
        this.info.setPreferredSize(new Dimension(250, 250));
        this.info.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        this.setBackground(LightZoneSkin.Colors.FrameBackground);
        this.header = new LayoutHeader(this);
        this.layout = new BrowserLayout(this.templates, this.editor, this.history, this.folders, this.browserScroll, this.info, this.header, this);
        switch (this.layout.getLayoutType()) {
            case Browser: {
                this.isEditorVisible = false;
                this.isBrowserVisible = true;
                this.header.setBrowseSelected();
                break;
            }
            case Editor: {
                this.isEditorVisible = true;
                this.isBrowserVisible = false;
                this.header.setEditSelected();
                break;
            }
            case Combo: {
                this.isEditorVisible = true;
                this.isBrowserVisible = true;
            }
        }
        if (!this.isBrowserVisible) {
            this.images.pause();
        }
        this.folderListener = new FolderTreeListener(){
            File recentFolder;

            @Override
            public void folderSelectionChanged(File folder) {
                if (folder != null && folder.equals(this.recentFolder)) {
                    return;
                }
                this.recentFolder = folder;
                ComboFrame.this.saveFolder(folder);
                Application.notifyRecentFolder(folder);
                ComboFrame.this.showFolder(folder, true);
            }

            @Override
            public void folderDropAccepted(final List<File> files, final File folder) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                int copyOrMove = ComboFrame.this.browser.wasCopyOrMove();
                                switch (copyOrMove) {
                                    case 2: {
                                        Application.moveFiles(ComboFrame.this, files, folder);
                                        break;
                                    }
                                    case 1: {
                                        Application.copyFiles(ComboFrame.this, files, folder);
                                    }
                                }
                            }
                        });
                    }
                });
            }
        };
        this.folders.addSelectionListener(this.folderListener);
        this.setDocument(null);
        DocumentDatabase.addListener(this);
        String disabledText = this.getDisabledEditorText();
        this.editor.setDisabledText(disabledText);
        this.updateTitle();
    }

    @Override
    public void addTemplate() {
        String namespace = this.templates.getNamespace();
        TemplateKey key = Application.saveTemplate(this, namespace);
        if (key != null) {
            namespace = key.getNamespace();
            this.templates.setNamespace(namespace);
        }
    }

    public void refresh() {
        File folder = this.folders.getSelection();
        if (folder != null) {
            this.showFolder(folder, false);
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public AbstractImageBrowser getBrowser() {
        return this.browser;
    }

    @Override
    public Image getIconImage() {
        return IconImage;
    }

    private void showFolder(File folder, boolean useCache) {
        this.unsetBrowser();
        if (this.images != null) {
            this.images.stop();
        }
        if (this.doc == null) {
            ((DisabledEditor)this.editor).removeImages();
        }
        if (this.info != null) {
            this.info.endEditing();
        }
        this.editor.hideWait();
        ImageList oldImages = this.images;
        this.initImages(folder, useCache);
        this.browser = ApplicationMode.isBasicMode() ? BrowserFactory.createExpanded(this.images) : BrowserFactory.createRecent(this.images);
        this.setBrowser();
        this.initBrowserSelection(folder);
        this.images.start();
        if (oldImages != null) {
            int pauses = oldImages.getPauseDepth();
            for (int n = 0; n < pauses; ++n) {
                this.images.pause();
            }
        }
        this.menus.update();
        String disabledText = this.getDisabledEditorText();
        this.editor.setDisabledText(disabledText);
        this.recentFolder = folder;
        this.updateTitle();
    }

    void setBrowserCollapsed() {
        if (!BrowserFactory.isCollapsed(this.browser)) {
            ArrayList<File> files = this.browser.getSelectedFiles();
            this.unsetBrowser();
            this.browser = BrowserFactory.createCollapsed(this.images);
            this.setBrowser();
            this.browser.setSelectedFiles(files);
            this.menus.update();
        }
    }

    void setBrowserExpanded() {
        if (BrowserFactory.isCollapsed(this.browser)) {
            ArrayList<File> files = this.browser.getSelectedFiles();
            this.unsetBrowser();
            this.browser = BrowserFactory.createExpanded(this.images);
            this.setBrowser();
            this.browser.setSelectedFiles(files);
            this.menus.update();
        }
    }

    @Override
    public void selectionChanged(ImageBrowserEvent event) {
        File file = event.getFile();
        if (file != null) {
            ImageInfo imageInfo = ImageInfo.getInstanceFor(file);
            this.info.setImage(imageInfo);
            BrowserSelectionMemory.setRememberedFile(file);
        } else {
            this.info.setImage(null);
        }
        if (this.doc != null) {
            SaveResult saved = SaveResult.Saved;
            if (this.doc.isDirty()) {
                saved = this.autoSave();
            }
            if (saved == SaveResult.Saved || saved == SaveResult.DontSave) {
                Application.closeDocument(this);
            }
        }
        if (this.doc == null) {
            ((DisabledEditor)this.editor).removeImages();
            this.editor.hideWait();
            List<PreviewUpdater> previews = event.getSelectedPreviews();
            int previewCount = previews.size();
            if (previewCount > 8) {
                String text = Locale.LOCALE.get("TooManyPreviewsText", previewCount);
                this.editor.setDisabledText(text);
                return;
            }
            String text = this.getDisabledEditorText();
            this.editor.setDisabledText(text);
            for (PreviewUpdater preview : previews) {
                RenderedImage image = preview.getImage(new PreviewUpdater.Observer(){

                    @Override
                    public void imageChanged(PreviewUpdater updater, RenderedImage image) {
                        if (ComboFrame.this.editor instanceof DisabledEditor) {
                            ((DisabledEditor)ComboFrame.this.editor).updateImage(updater, image);
                        }
                    }
                });
                ((DisabledEditor)this.editor).addImage(preview, image);
            }
        }
        this.menus.update();
    }

    @Override
    public void imageDoubleClicked(ImageBrowserEvent event) {
        File file = event.getFile();
        if (file == null) {
            return;
        }
        ComboFrame frame = Application.getFrameForFile(file);
        if (frame != null) {
            frame.requestFocus();
            return;
        }
        if (this.doc != null) {
            SaveResult saved = SaveResult.Saved;
            if (this.doc.isDirty()) {
                saved = this.autoSave();
            }
            if (saved == SaveResult.Saved || saved == SaveResult.DontSave) {
                Application.closeDocument(this);
            }
        }
        if (this.doc == null) {
            Application.open(file, this, null);
        }
    }

    private boolean isMouseWheelEventInComponent(MouseWheelEvent e, JComponent comp) {
        if (comp.isShowing()) {
            Point compLoc = comp.getLocationOnScreen();
            Point frameLoc = this.getLocationOnScreen();
            Rectangle bounds = new Rectangle(compLoc.x - frameLoc.x, compLoc.y - frameLoc.y, comp.getWidth(), comp.getHeight());
            return bounds.contains(e.getPoint());
        }
        return false;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getScrollType() == 2) {
            JComponent scroll;
            JComponent tree;
            JComponent image;
            if (this.editor != null && this.isMouseWheelEventInComponent(e, image = this.editor.getImage())) {
                this.editor.horizontalMouseWheelMoved(e);
                return;
            }
            if (this.folders != null && this.isMouseWheelEventInComponent(e, tree = this.folders.getTree())) {
                this.folders.horizontalMouseWheelMoved(e);
                return;
            }
            if (this.history != null && this.isMouseWheelEventInComponent(e, scroll = this.history.getScrollPane())) {
                this.history.horizontalMouseWheelMoved(e);
                return;
            }
            if (this.templates != null && this.isMouseWheelEventInComponent(e, scroll = this.templates.getScrollPane())) {
                this.templates.horizontalMouseWheelMoved(e);
            }
        }
    }

    @Override
    public void browserError(String message) {
    }

    public File getRecentFolder() {
        return this.recentFolder;
    }

    void showWait(String text) {
        this.editor.showWait(text);
    }

    void hideWait() {
        this.editor.hideWait();
    }

    void setDocument(Document doc) {
        ScaleModel scale;
        if (this.doc != null) {
            scale = this.doc.getScaleModel();
            scale.removeScaleListener(this);
            this.doc.removeDocumentListener(this);
            this.doc.getProofAction().removePropertyChangeListener(this.toolButtonListener);
            this.toolButtonListener = null;
        } else if (this.editor != null) {
            ((DisabledEditor)this.editor).dispose();
        }
        if (this.advice != null) {
            this.advice.dispose();
        }
        this.doc = doc;
        this.advice = new AdviceManager(this);
        if (doc != null) {
            this.editor = doc.getEditor();
            this.history = new DocUndoHistory(doc);
            this.templates.dispose();
            this.templates = new TemplateControl(this.editor, this);
            scale = doc.getScaleModel();
            scale.addScaleListener(this);
            doc.addDocumentListener(this);
            OtherApplication source = (OtherApplication)doc.getSource();
            if (!this.isEditorVisible || source != null) {
                this.showEditorPerspective();
            }
            this.toolButtonListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    boolean selected;
                    String propName = event.getPropertyName();
                    if (propName.equals("ToggleState") && (selected = ((Boolean)event.getNewValue()).booleanValue()) && ComboFrame.this.layout instanceof EditorLayout) {
                        ((EditorLayout)ComboFrame.this.layout).ensureToolsVisible();
                    }
                }
            };
            this.editor.getImage().setMinimumSize(new Dimension(120, 120));
            doc.getProofAction().addPropertyChangeListener(this.toolButtonListener);
        } else {
            this.editor = this.disabledEditor;
            this.editor.getImage().setMinimumSize(new Dimension(120, 120));
            String disabledText = this.getDisabledEditorText();
            this.editor.setDisabledText(disabledText);
            this.history = new DocUndoHistory();
            this.templates.dispose();
            this.templates = new TemplateControl(null, this);
            if (!this.isBrowserVisible) {
                this.showBrowserPerspective();
            }
        }
        if (this.memory != null) {
            JComponent toolbar = this.editor.getToolBar();
            toolbar.add(this.memory);
        }
        this.layout.updateEditor(this.templates, this.editor, this.history);
        this.setContentPane(this.layout);
        this.header.update();
        this.menus.update();
        this.updateTitle();
        if (this.layout.getLayoutType() == AbstractLayout.LayoutType.Combo) {
            this.browser.requestFocusInWindow();
        }
    }

    public boolean openSelected() {
        PreviewUpdater updater;
        if (this.editor instanceof DisabledEditor && (updater = (PreviewUpdater)((DisabledEditor)this.editor).getLastKey()) != null) {
            File file = updater.getFile();
            Application.open(this, file);
            return true;
        }
        return false;
    }

    public void showEditorPerspective() {
        this.layout.dispose();
        this.layout = new EditorLayout(this.templates, this.editor, this.history, this.folders, this.browserScroll, this.info, this.header);
        this.layout.updateEditor(this.templates, this.editor, this.history);
        this.repaint();
        this.setContentPane(this.layout);
        this.validate();
        this.requestFocusInWindow();
        if (this.isBrowserVisible) {
            this.pause();
            this.isBrowserVisible = false;
        }
        this.isEditorVisible = true;
        this.header.setEditSelected();
        this.updateDisabledEditorText();
        this.menus.update();
    }

    public boolean closeDocument() {
        if (this.doc != null) {
            SaveResult saved = this.autoSave();
            switch (saved) {
                case Saved: 
                case DontSave: {
                    Application.closeDocument(this);
                    break;
                }
                case CouldntSave: {
                    switch (Application.saveAs(this)) {
                        case Saved: 
                        case DontSave: {
                            return true;
                        }
                        case CouldntSave: 
                        case Cancelled: {
                            return false;
                        }
                    }
                }
                case Cancelled: {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean showBrowserPerspective() {
        if (!this.closeDocument()) {
            return false;
        }
        if (!this.isBrowserVisible) {
            this.layout.dispose();
            this.layout = new BrowserLayout(this.templates, this.editor, this.history, this.folders, this.browserScroll, this.info, this.header, this);
            this.browser.justShown = true;
            this.repaint();
            this.setContentPane(this.layout);
            this.validate();
            this.browser.requestFocusInWindow();
            if (!this.isBrowserVisible) {
                this.resume();
                this.isBrowserVisible = true;
            }
            this.isEditorVisible = false;
            this.header.setBrowseSelected();
            this.updateDisabledEditorText();
            this.menus.update();
        }
        return true;
    }

    public void showComboPerspective() {
        this.layout.dispose();
        this.layout = new ComboLayout(this.templates, this.editor, this.history, this.folders, this.browserScroll, this.info, this.header, this);
        this.setContentPane(this.layout);
        this.validate();
        this.repaint();
        this.browser.requestFocusInWindow();
        if (!this.isBrowserVisible) {
            this.resume();
            this.isBrowserVisible = true;
        }
        this.isEditorVisible = true;
        this.updateDisabledEditorText();
        this.menus.update();
    }

    public boolean isBrowserVisible() {
        return this.isBrowserVisible;
    }

    @Override
    public void documentChanged(Document doc, boolean isDirty) {
        this.updateTitle();
    }

    @Override
    public void scaleChanged(Scale scale) {
        this.updateTitle();
    }

    @Override
    public void docFilesChanged(File imageFile) {
        File folder;
        if (this.browser != null && (folder = imageFile.getParentFile()) != null && folder.equals(this.recentFolder)) {
            this.images.regroup();
        }
    }

    private void updateTitleNoDoc() {
        if (this.doc != null) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.recentFolder != null) {
            String name = Platform.getPlatform().getDisplayNameOf(this.recentFolder);
            buffer.append(name);
            buffer.append(" - ");
        }
        buffer.append(Version.getApplicationName());
        if (ApplicationMode.isBasicMode()) {
            buffer.append(" Basic");
        }
        this.setTitle(buffer.toString());
        WindowMenu.updateAll();
    }

    public void updateTitleDoc() {
        boolean dirty;
        StringBuffer sb = new StringBuffer();
        boolean bl = dirty = this.doc != null && this.doc.isDirty();
        if (dirty) {
            sb.append("* ");
        }
        if (this.doc != null) {
            String imageName;
            String name;
            File file = this.doc.getFile();
            ImageMetadata meta = this.doc.getMetadata();
            if (file == null) {
                file = meta.getFile();
            }
            if (!(name = file.getName()).equals(imageName = meta.getFile().getName())) {
                name = name + " [" + imageName + "]";
            }
            sb.append(name);
            ScaleModel scaleModel = this.doc.getScaleModel();
            Scale scale = scaleModel.getCurrentScale();
            sb.append(" (").append(scale).append(")");
            sb.append(" - ");
        }
        sb.append(Version.getApplicationName());
        if (ApplicationMode.isBasicMode()) {
            sb.append(" Basic");
        }
        this.setTitle(sb.toString());
        WindowMenu.updateAll();
        JRootPane root = this.getRootPane();
        root.putClientProperty("windowModified", dirty ? Boolean.TRUE : Boolean.FALSE);
    }

    public void updateTitle() {
        if (this.doc != null) {
            this.updateTitleDoc();
        } else {
            this.updateTitleNoDoc();
        }
    }

    public void pause() {
        if (this.images != null) {
            this.images.pause();
        }
    }

    public void resume() {
        if (this.images != null) {
            this.images.resume();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.memory != null) {
            this.memory.dispose();
        }
        this.images.stop();
        if (this.browser != null) {
            this.unsetBrowser();
        }
        this.remove(this.menus);
        this.setJMenuBar(null);
        this.menus.dispose();
        this.templates.dispose();
        this.folders.removeSelectionListener(this.folderListener);
        this.folders.dispose();
        if (this.advice != null) {
            this.advice.dispose();
            this.advice = null;
        }
        if (this.doc == null) {
            ((DisabledEditor)this.editor).dispose();
        } else {
            this.doc.getProofAction().removePropertyChangeListener(this.toolButtonListener);
        }
        this.header.dispose();
        this.layout.dispose();
        this.setContentPane(new JPanel());
        this.doc = null;
        this.images = null;
        this.layout = null;
        this.browser = null;
        this.editor = null;
        this.folders = null;
        this.browserScroll = null;
        this.info = null;
        this.header = null;
        if (LastActiveComboFrame == this) {
            LastActiveComboFrame = null;
        }
    }

    private boolean isDisposed() {
        return this.browser == null;
    }

    private void initImages(final File directory, final boolean useCache) {
        ProgressDialog dialog = Platform.getPlatform().getProgressDialog();
        ProgressThread thread = new ProgressThread(dialog){

            @Override
            public void run() {
                DocumentDatabase.addDocumentDirectory(directory);
                ComboFrame.this.images = new ImageList(directory, 100, FileCacheFactory.get(directory), useCache, ImageDatumComparator.CaptureTime, this.getProgressIndicator());
            }

            @Override
            public void cancel() {
                ImageList.cancel();
            }
        };
        FileSystemView view = Platform.getPlatform().getFileSystemView();
        String dirName = view.getSystemDisplayName(directory);
        dialog.showProgress(this, thread, Locale.LOCALE.get("ScanningMessage", dirName), 0, 1, true);
        Throwable t = dialog.getThrown();
        if (t != null) {
            throw new RuntimeException(Locale.LOCALE.get("ScanningError"), t);
        }
        if (this.images.getAllImageData().isEmpty()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ComboFrame.this.layout instanceof BrowserLayout) {
                        ((BrowserLayout)ComboFrame.this.layout).ensureFoldersVisible();
                        ComboFrame.this.advice.showEmptyFolderAdvice();
                    }
                }
            });
        } else {
            this.advice.hideEmptyFolderAdvice();
        }
    }

    private void setBrowser() {
        this.browser.addBrowserListener(this);
        this.browser.setTemplateProvider(this.templateProvider);
        this.browser.addBrowserAction(this.exportAction);
        this.browser.addBrowserAction(this.printAction);
        this.browser.setImageGroupProvider(new LznImageGroupProvider());
        this.browser.setPreviewProvider(new LznPreviewProvider(this));
        this.browserScroll.setBrowser(this.browser);
        if (this.layout != null) {
            this.header.update();
            this.layout.updateBrowser();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComboFrame.this.browser.repaint();
            }
        });
    }

    private void unsetBrowser() {
        if (this.browser != null) {
            this.browser.removeBrowserListener(this);
            BrowserFactory.dispose(this.browser);
        }
    }

    private void updateDisabledEditorText() {
        if (this.editor instanceof DisabledEditor) {
            String text = this.getDisabledEditorText();
            this.editor.setDisabledText(text);
        }
    }

    private void initBrowserSelection(File folder) {
        ArrayList<ImageDatum> datums;
        File file = BrowserSelectionMemory.getRememberedFile(folder);
        if (file == null && !(datums = this.images.getAllImageData()).isEmpty()) {
            ImageDatum datum = this.images.getAllImageData().get(0);
            file = datum.getFile();
        }
        if (file != null) {
            final Set<File> files = Collections.singleton(file);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ComboFrame.this.browser != null) {
                        ComboFrame.this.browser.setSelectedFiles(files);
                    }
                }
            });
        }
    }

    private String getDisabledEditorText() {
        if (this.images == null) {
            return "";
        }
        switch (AbstractLayout.getRecentLayoutType()) {
            case Editor: {
                return Locale.LOCALE.get("EditorLayoutDisabledEditorText");
            }
            case Combo: {
                if (this.images.getAllImageData().size() > 0) {
                    return Locale.LOCALE.get("ComboLayoutDisabledEditorText");
                }
                return null;
            }
        }
        if (this.images.getAllImageData().size() > 0) {
            return Locale.LOCALE.get("BrowserLayoutDisabledEditorText");
        }
        return null;
    }

    private SaveResult autoSave() {
        SaveResult result = SaveResult.Saved;
        if (this.doc != null && this.doc.isDirty()) {
            Preferences prefs;
            boolean autoSave;
            SaveOptions options = this.doc.getSaveOptions();
            if (options == null) {
                options = OtherApplicationShim.shouldSaveDirectly(this.doc) ? OtherApplicationShim.createExportOptions(this.doc) : Application.getSaveOptions(this.doc);
            }
            if (autoSave = (prefs = Preferences.userRoot().node("/com/lightcrafts/app")).getBoolean("AutoSave", true)) {
                this.doc.setSaveOptions(options);
                result = Application.save(this) ? SaveResult.Saved : SaveResult.CouldntSave;
            } else {
                JLabel prompt = new JLabel(Locale.LOCALE.get("AutoSaveQuestion", options.getFile().getName()));
                boolean defaultAutoSave = prefs.getBoolean("DefaultAutoSave", true);
                JCheckBox check = new JCheckBox(Locale.LOCALE.get("AlwaysAutoSaveLabel"));
                check.setSelected(defaultAutoSave);
                Box message = Box.createVerticalBox();
                message.add(prompt);
                message.add(check);
                int dialogOption = UICompliance.showOptionDialog(this, message, Locale.LOCALE.get("AutoSaveDialogTitle"), -1, 3, null, new Object[]{Locale.LOCALE.get("AutoSaveSaveOption"), Locale.LOCALE.get("AutoSaveSaveAsOption"), Locale.LOCALE.get("AutoSaveCancelOption"), Locale.LOCALE.get("AutoSaveDontSaveOption")}, Locale.LOCALE.get("AutoSaveSaveOption"), 3);
                if (check.isSelected()) {
                    prefs.putBoolean("AutoSave", true);
                    AlertDialog alert = Platform.getPlatform().getAlertDialog();
                    alert.showAlert((Frame)this, Locale.LOCALE.get("AutoSaveOnMessageMajor"), Locale.LOCALE.get("AutoSaveOnMessageMinor"), 1, Locale.LOCALE.get("AutoSaveOnButton"));
                }
                prefs.putBoolean("DefaultAutoSave", check.isSelected());
                switch (dialogOption) {
                    case 0: {
                        this.doc.setSaveOptions(options);
                        result = Application.save(this) ? SaveResult.Saved : SaveResult.CouldntSave;
                        break;
                    }
                    case 1: {
                        result = Application.saveAs(this);
                        break;
                    }
                    case -1: 
                    case 2: {
                        result = SaveResult.Cancelled;
                        break;
                    }
                    case 3: {
                        Application.closeDocumentForce(this);
                        result = SaveResult.DontSave;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void windowGainedFocus(WindowEvent event) {
        if (!this.isDisposed()) {
            LastActiveComboFrame = this;
            if (this.focusPausedFlag) {
                this.resume();
                this.focusPausedFlag = false;
            }
            this.folders.resumeFolderMonitor();
            this.templates.refresh();
        }
    }

    @Override
    public void windowLostFocus(WindowEvent event) {
        if (!this.isDisposed()) {
            if (!this.focusPausedFlag) {
                this.pause();
                this.focusPausedFlag = true;
            }
            this.folders.pauseFolderMonitor();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int state = this.getExtendedState();
        if (state == 0) {
            this.unMaximizedBounds = this.getBounds();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        int state = this.getExtendedState();
        if (state == 0) {
            this.unMaximizedBounds = this.getBounds();
        }
    }

    Rectangle getUnmaximizedBounds() {
        if (this.unMaximizedBounds != null) {
            return new Rectangle(this.unMaximizedBounds);
        }
        return null;
    }

    void showRecentFolder(File folder) {
        String key = ComboFrame.getKeyForFolder(folder);
        this.folders.restorePath(key);
        if (!this.isBrowserVisible) {
            this.showBrowserPerspective();
        }
    }

    private void saveFolder(File folder) {
        if (folder != null) {
            String key = ComboFrame.getKeyForFolder(folder);
            this.folders.savePath(key);
        }
    }

    static void clearFolder(File folder) {
        String key = ComboFrame.getKeyForFolder(folder);
        FolderBrowserPane.clearPath(key);
    }

    private static String getKeyForFolder(File folder) {
        String path = folder.getAbsolutePath();
        int hash = path.hashCode();
        return Integer.toString(hash);
    }

    private void initMemoryMeter() {
        if (this.memory == null) {
            this.memory = new MemoryMeter();
            Border empty = BorderFactory.createEmptyBorder(6, 0, 6, 0);
            Border line = BorderFactory.createLineBorder(Color.gray);
            CompoundBorder compound = BorderFactory.createCompoundBorder(empty, line);
            this.memory.setBorder(compound);
        }
    }

    static {
        URL url = ComboFrame.class.getResource("resources/LightZone.png");
        IconImage = Toolkit.getDefaultToolkit().createImage(url);
    }
}

