/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.DocumentInitializerListener;
import com.lightcrafts.app.Locale;
import com.lightcrafts.ui.editor.Document;
import com.lightcrafts.utils.ProgressIndicator;
import com.lightcrafts.utils.UserCanceledException;
import com.lightcrafts.utils.thread.ProgressThread;
import java.awt.EventQueue;
import java.io.File;

class DocumentInitializer {
    private static Object Monitor = new Object();
    private static ProgressThread Cancellable;
    private static boolean IsRunning;
    private static ProgressIndicator DummyIndicator;

    DocumentInitializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createDocument(File file, ComboFrame frame, DocumentInitializerListener listener) {
        Object object = Monitor;
        synchronized (object) {
            if (IsRunning) {
                return;
            }
            DocumentInitializer.createDocumentInBackground(file, frame, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createDocumentInBackground(final File file, final ComboFrame frame, final DocumentInitializerListener listener) {
        Object object = Monitor;
        synchronized (object) {
            Cancellable = new ProgressThread(DummyIndicator){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        frame.showWait(Locale.LOCALE.get("LoadMessage"));
                        DocumentInitializer.notifyListenerStart(listener);
                        Document doc = Application.createDocument(file, frame, Cancellable);
                        DocumentInitializer.notifyListener(doc, listener);
                    }
                    catch (Throwable t) {
                        DocumentInitializer.notifyListener(t, listener);
                    }
                    finally {
                        frame.hideWait();
                    }
                    Object object = Monitor;
                    synchronized (object) {
                        Monitor.notifyAll();
                        Cancellable = null;
                        IsRunning = false;
                    }
                }
            };
            Thread thread = new Thread((Runnable)Cancellable, "Document Initialization");
            thread.start();
            IsRunning = true;
        }
    }

    private static void notifyListenerStart(final DocumentInitializerListener listener) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                listener.documentStarted();
            }
        });
    }

    private static void notifyListener(final Document doc, final DocumentInitializerListener listener) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                listener.documentInitialized(doc);
            }
        });
    }

    private static void notifyListener(final Throwable t, final DocumentInitializerListener listener) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (t instanceof UserCanceledException) {
                    listener.documentCancelled();
                } else {
                    listener.documentFailed(t);
                }
            }
        });
    }

    static {
        DummyIndicator = new ProgressIndicator(){

            @Override
            public void incrementBy(int delta) {
            }

            @Override
            public void setIndeterminate(boolean indeterminate) {
            }

            @Override
            public void setMaximum(int maxValue) {
            }

            @Override
            public void setMinimum(int minValue) {
            }
        };
    }
}

