/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.AbstractLayout;
import com.lightcrafts.app.LayoutHeader;
import com.lightcrafts.app.Locale;
import com.lightcrafts.ui.browser.ctrls.FolderCtrl;
import com.lightcrafts.ui.browser.view.ImageBrowserScrollPane;
import com.lightcrafts.ui.editor.DocUndoHistory;
import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.layout.FadingTabConfiguration;
import com.lightcrafts.ui.metadata2.MetadataScroll;
import com.lightcrafts.ui.templates.TemplateControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;

class EditorLayout
extends AbstractLayout {
    EditorLayout(TemplateControl templates, Editor editor, DocUndoHistory history, FolderCtrl folders, ImageBrowserScrollPane browser, MetadataScroll info, LayoutHeader header) {
        super(AbstractLayout.LayoutType.Editor, templates, editor, history, folders, browser, info, header);
        this.updateEditor(templates, editor, history);
    }

    @Override
    void updateEditor(TemplateControl templates, Editor editor, DocUndoHistory history) {
        super.updateEditor(templates, editor, history);
        this.initFaders();
        JComponent leftButtons = this.leftFader.getButtonContainer();
        JComponent rightButtons = this.rightFader.getButtonContainer();
        this.leftSplit.setLeftComponent(this.leftFader);
        this.leftSplit.setRightComponent(editor.getImage());
        this.leftSplit.setResizeWeight(0.0);
        this.rightSplit.setLeftComponent(this.leftSplit);
        this.rightSplit.setRightComponent(this.rightFader);
        this.rightSplit.setResizeWeight(1.0);
        this.restoreLayout();
        this.header.removeButtons();
        this.header.addButtons(editor.getToolBar());
        this.setLayout(new BorderLayout());
        this.removeAll();
        this.add(this.rightSplit);
        this.add((Component)this.header, "North");
        this.add((Component)leftButtons, "West");
        this.add((Component)rightButtons, "East");
        this.leftSplit.updateOppositeMinSize();
    }

    @Override
    void updateBrowser() {
    }

    void ensureToolsVisible() {
        String toolsLabel = Locale.LOCALE.get("ToolsTabLabel");
        this.rightFader.setSelected(toolsLabel);
    }

    @Override
    List<FadingTabConfiguration> getLeftFaderConfs() {
        String templatesLabel = Locale.LOCALE.get("TemplatesTabLabel");
        String undoLabel = Locale.LOCALE.get("UndoTabLabel");
        String templatesTip = Locale.LOCALE.get("TemplatesTabToolTip");
        String undoTip = Locale.LOCALE.get("UndoTabToolTip");
        LinkedList<FadingTabConfiguration> tabs = new LinkedList<FadingTabConfiguration>();
        tabs.add(new FadingTabConfiguration(this.templates, templatesLabel, templatesTip));
        tabs.add(new FadingTabConfiguration(this.history, undoLabel, undoTip));
        return tabs;
    }

    @Override
    List<FadingTabConfiguration> getRightFaderConfs() {
        String toolsLabel = Locale.LOCALE.get("ToolsTabLabel");
        String toolsTip = Locale.LOCALE.get("ToolsTabToolTip");
        LinkedList<FadingTabConfiguration> tabs = new LinkedList<FadingTabConfiguration>();
        tabs.add(new FadingTabConfiguration(this.editor.getToolStack(), toolsLabel, toolsTip));
        return tabs;
    }

    @Override
    String getDefaultLeftFaderTab() {
        return Locale.LOCALE.get("TemplatesTabLabel");
    }

    @Override
    String getDefaultRightFaderTab() {
        return Locale.LOCALE.get("ToolsTabLabel");
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.rightSplit.checkConstraints();
    }
}

