/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.Locale;
import com.lightcrafts.app.TemplateJig;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlDocument;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;

class TemplateToolSelector
extends Box
implements Scrollable {
    private XmlDocument xml;
    private JCheckBox[] checks;

    TemplateToolSelector(XmlDocument template) throws XMLException {
        super(1);
        this.xml = template;
        TemplateJig jig = new TemplateJig(this.xml);
        String[] names = jig.getToolNames();
        this.checks = new JCheckBox[names.length];
        for (int n = 0; n < names.length; ++n) {
            String name = names[n];
            JCheckBox check = new JCheckBox(name);
            if (!name.startsWith("RAW")) {
                check.setSelected(true);
            }
            check.setOpaque(false);
            this.checks[n] = check;
        }
        Box checkBoxes = Box.createVerticalBox();
        for (int n = this.checks.length - 1; n >= 0; --n) {
            checkBoxes.add(this.checks[n]);
        }
        JScrollPane scroll = new JScrollPane(checkBoxes);
        scroll.setPreferredSize(new Dimension(200, 150));
        scroll.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.add(scroll);
        JButton allButton = new JButton(Locale.LOCALE.get("TemplateSelectorAllButton"));
        allButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateToolSelector.this.selectAll();
            }
        });
        JButton noneButton = new JButton(Locale.LOCALE.get("TemplateSelectorNoneButton"));
        noneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplateToolSelector.this.selectNone();
            }
        });
        Box allNoneBox = Box.createHorizontalBox();
        allNoneBox.add(allButton);
        allNoneBox.add(Box.createHorizontalStrut(4));
        allNoneBox.add(noneButton);
        allNoneBox.add(Box.createHorizontalGlue());
        this.add(Box.createVerticalStrut(8));
        this.add(allNoneBox);
    }

    XmlDocument getModifiedTemplate() {
        XmlDocument clone = new XmlDocument(this.xml);
        try {
            TemplateJig jig = new TemplateJig(clone);
            for (int n = this.checks.length - 1; n >= 0; --n) {
                JCheckBox check = this.checks[n];
                if (check.isSelected()) continue;
                jig.removeTool(n);
            }
        }
        catch (XMLException e) {
            return new XmlDocument(this.xml);
        }
        return clone;
    }

    XmlDocument getOriginalTemplate() {
        return new XmlDocument(this.xml);
    }

    private void selectAll() {
        for (JCheckBox check : this.checks) {
            check.setSelected(true);
        }
    }

    private void selectNone() {
        for (JCheckBox check : this.checks) {
            check.setSelected(false);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.checks.length > 0 && orientation == 1) {
            return this.checks[0].getPreferredSize().height;
        }
        return 1;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }
}

