/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.Locale;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.toolkit.TextAreaFactory;
import com.lightcrafts.utils.WebBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class UpgradeDialog
extends JDialog {
    private static final String UpgradeUrl = "http://www.lightcrafts.com/store";
    private boolean bought;

    public UpgradeDialog(JFrame parent) {
        super(parent);
        JButton buyButton = new JButton(Locale.LOCALE.get("UpgradeButton"));
        JButton cancelButton = new JButton(Locale.LOCALE.get("UpgradeCancelButton"));
        buyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpgradeDialog.this.bought = true;
                WebBrowser.browse(UpgradeDialog.UpgradeUrl);
                UpgradeDialog.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpgradeDialog.this.setVisible(false);
            }
        });
        Box buttons = Box.createHorizontalBox();
        buttons.add(Box.createHorizontalGlue());
        buttons.add(cancelButton);
        buttons.add(Box.createHorizontalStrut(8));
        buttons.add(buyButton);
        buttons.setBorder(BorderFactory.createEmptyBorder(6, 12, 12, 12));
        JTextArea text = TextAreaFactory.createTextArea(Locale.LOCALE.get("UpgradeText1") + '\n' + '\n' + Locale.LOCALE.get("UpgradeText2") + '\n' + '\n' + Locale.LOCALE.get("UpgradeText3"), 30);
        text.setBorder(BorderFactory.createEmptyBorder(12, 12, 6, 12));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(text);
        panel.add((Component)buttons, "South");
        text.setBackground(panel.getBackground());
        this.setTitle(Locale.LOCALE.get("UpgradeDialogTitle"));
        this.setModal(true);
        this.getContentPane().add(panel);
        this.getRootPane().setDefaultButton(buyButton);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public boolean userBought() {
        return this.bought;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(Platform.getPlatform().getLookAndFeel());
        UpgradeDialog dialog = new UpgradeDialog(null);
        dialog.setVisible(true);
        System.out.println(dialog.userBought() ? "bought" : "not bought");
        System.exit(0);
    }
}

