/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.utils.Version;
import com.lightcrafts.utils.WebBrowser;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class VideoLearningCenterDialog
extends JFrame {
    private static final Color LinkColor = new Color(195, 195, 195);
    private static final Color LinkHighlightColor = new Color(249, 155, 28);

    VideoLearningCenterDialog() {
        String mainUrl = Version.getVideoLearningCenterURL().toString();
        LinkLabel topText = new LinkLabel("Want to learn LightZone?");
        LinkLabel leftText = new LinkLabel("Check out these videos at the ");
        LinkLabel mainLink = new LinkLabel("Video Learning Center", mainUrl);
        ArrayList<LinkLabel> videoLinks = new ArrayList<LinkLabel>();
        Map<String, URL> videoUrls = Version.getVideoURLs();
        for (Map.Entry<String, URL> entry : videoUrls.entrySet()) {
            LinkLabel videoLink = new LinkLabel(entry.getKey(), entry.getValue().toString());
            videoLinks.add(videoLink);
        }
        Font font = topText.getFont();
        font = font.deriveFont(24.0f);
        topText.setFont(font);
        Box content = Box.createVerticalBox();
        content.setBorder(BorderFactory.createEmptyBorder(24, 32, 32, 24));
        this.getContentPane().add(content);
        JPanel firstLine = new JPanel(new FlowLayout());
        firstLine.add(leftText);
        firstLine.add(mainLink);
        content.add(topText);
        content.add(Box.createVerticalStrut(16));
        content.add(firstLine);
        content.add(Box.createVerticalStrut(16));
        Box linkBox = Box.createVerticalBox();
        for (LinkLabel link : videoLinks) {
            Box panel = Box.createHorizontalBox();
            panel.add(link);
            panel.add(Box.createHorizontalGlue());
            linkBox.add(panel);
            linkBox.add(Box.createVerticalStrut(8));
        }
        linkBox.setBorder(BorderFactory.createEmptyBorder(0, 32, 0, 32));
        content.add(linkBox);
        this.pack();
        this.setTitle("LightZone - Video Learning Center");
        this.setResizable(false);
    }

    static boolean shouldShowDialog() {
        return false;
    }

    static void showDialog() {
        VideoLearningCenterDialog dialog = new VideoLearningCenterDialog();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
    }

    public static void main(String[] args) throws UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(Platform.getPlatform().getLookAndFeel());
        VideoLearningCenterDialog.showDialog();
    }

    class LinkLabel
    extends JLabel {
        LinkLabel(String text) {
            this(text, null);
            this.setForeground(LinkColor);
            this.setAlignmentX(0.5f);
            this.setHorizontalAlignment(0);
        }

        LinkLabel(String text, String url) {
            super(text);
            if (url != null) {
                this.setText("<html><u>" + text + "</u></html>");
                this.addMouseListener(new LinkListener(this, url));
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D g = (Graphics2D)graphics;
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paintComponent(g);
        }
    }

    class LinkListener
    implements MouseListener {
        private JComponent comp;
        private String url;

        LinkListener(JComponent comp, String url) {
            this.comp = comp;
            this.url = url;
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.comp.setForeground(LinkHighlightColor);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.comp.setForeground(LinkColor);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            WebBrowser.browse(this.url);
        }
    }
}

