/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.advice;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.advice.EmptyFolderAdvice;
import com.lightcrafts.app.advice.RegionEndAdvice;
import com.lightcrafts.app.advice.RegionStartAdvice;
import com.lightcrafts.ui.advice.Advice;
import com.lightcrafts.ui.advice.AdvisorDialog;
import com.lightcrafts.ui.editor.Document;
import com.lightcrafts.ui.editor.RegionManager;
import com.lightcrafts.ui.region.RegionListener;
import com.lightcrafts.ui.region.SharedShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;

public class AdviceManager
implements RegionListener,
PropertyChangeListener {
    private ComboFrame frame;
    private Advice startAdvice;
    private Advice endAdvice;
    private Advice emptyFolderAdvice;
    private Action regionsAction;
    private AdvisorDialog dialog;
    private int depth = 0;
    private boolean depthDecremented;

    public AdviceManager(ComboFrame frame) {
        this.frame = frame;
        this.startAdvice = new RegionStartAdvice(frame);
        this.endAdvice = new RegionEndAdvice(frame);
        this.emptyFolderAdvice = new EmptyFolderAdvice(frame);
        Document doc = frame.getDocument();
        if (doc != null) {
            RegionManager regions = doc.getRegionManager();
            regions.addRegionListener(this);
            this.regionsAction = regions.getShowHideAction();
            this.regionsAction.addPropertyChangeListener(this);
        }
    }

    public void showEmptyFolderAdvice() {
        this.nextAdvice(this.emptyFolderAdvice);
    }

    public void hideEmptyFolderAdvice() {
        if (this.dialog != null && this.dialog.getAdvice() == this.emptyFolderAdvice) {
            this.nextAdvice(null);
        }
    }

    public void dispose() {
        Document doc = this.frame.getDocument();
        if (doc != null) {
            RegionManager regions = doc.getRegionManager();
            regions.removeRegionListener(this);
            this.regionsAction.removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propName = event.getPropertyName();
        if (propName.equals("ToggleState")) {
            boolean selected = (Boolean)event.getNewValue();
            Object source = event.getSource();
            if (source == this.regionsAction) {
                if (selected) {
                    this.nextAdvice(this.startAdvice);
                } else if (this.dialog != null) {
                    if (this.dialog.getAdvice() == this.startAdvice) {
                        this.nextAdvice(null);
                    } else if (this.dialog.getAdvice() == this.endAdvice) {
                        this.nextAdvice(null);
                    }
                }
            }
        }
    }

    @Override
    public void regionBatchStart(Object cookie) {
        if (this.depth == 2 && !this.depthDecremented) {
            this.nextAdvice(this.endAdvice);
        }
    }

    @Override
    public void regionChanged(Object cookie, SharedShape shape) {
    }

    @Override
    public void regionBatchEnd(Object cookie) {
        if (!this.depthDecremented && this.dialog != null) {
            this.dialog.setVisible(false);
        }
        this.depthDecremented = this.depth > 0;
    }

    private void nextAdvice(Advice advice) {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog = null;
        }
        if (advice != null) {
            this.dialog = new AdvisorDialog(advice);
            this.dialog.advise();
        }
    }
}

