/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.batch;

import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.export.ImageFileExportOptions;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.utils.xml.XmlDocument;
import com.lightcrafts.utils.xml.XmlNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.prefs.Preferences;

public class BatchConfig {
    private static final Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/app/batch");
    public String name;
    public ImageFileExportOptions export = JPEGImageType.INSTANCE.newExportOptions();
    public File directory;
    private static final String NewFileNameKey = "TemplateBatchName";
    private static final String ExportKey = "TemplateExportOptions";
    private static final String DirectoryKey = "TemplateOutputDirectory";

    void writeDebug(OutputStream out) {
        PrintWriter printer = new PrintWriter(out);
        printer.println("batch name: " + this.name);
        printer.println("output folder: " + this.directory.getAbsolutePath());
        printer.println("export options:");
        printer.flush();
        XmlDocument doc = new XmlDocument("Export");
        XmlNode root = doc.getRoot();
        this.export.write(root);
        try {
            doc.write(out);
        }
        catch (IOException e) {
            e.printStackTrace(printer);
        }
    }

    public void saveToPrefs(String context) {
        Prefs.put(NewFileNameKey + context, this.name);
        String path = this.directory.getAbsolutePath();
        Prefs.put(DirectoryKey + context, path);
        try {
            XmlDocument doc = new XmlDocument(ExportKey);
            this.export.write(doc.getRoot());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            doc.write(out);
            out.close();
            String text = out.toString("UTF-8");
            Prefs.put(ExportKey + context, text);
        }
        catch (IOException e) {
            System.err.print("Error saving BatchConfig preferences: ");
            System.err.print(e.getClass().getName() + " ");
            System.err.println(e.getMessage());
        }
    }

    public void restoreFromPrefs(String context) {
        this.name = Prefs.get(NewFileNameKey + context, "");
        String path = Prefs.get(DirectoryKey + context, null);
        this.directory = path != null ? new File(path) : null;
        String text = Prefs.get(ExportKey + context, null);
        if (text != null) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes("UTF-8"));
                XmlDocument doc = new XmlDocument(in);
                XmlNode root = doc.getRoot();
                this.export = (ImageFileExportOptions)ImageExportOptions.read(root);
            }
            catch (IOException e) {
                System.err.print("Error reading BatchConfig preferences: ");
                System.err.print(e.getClass().getName() + " ");
                System.err.println(e.getMessage());
                Prefs.remove(ExportKey + context);
            }
        }
    }
}

