/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.batch;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.DocumentWriter;
import com.lightcrafts.app.batch.BatchConfig;
import com.lightcrafts.app.batch.BatchImageComponent;
import com.lightcrafts.app.batch.BatchProgressBar;
import com.lightcrafts.app.batch.BatchText;
import com.lightcrafts.app.batch.Locale;
import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ColorProfileException;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.UnsupportedColorProfileException;
import com.lightcrafts.image.export.ImageFileExportOptions;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.LZNImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.model.Engine;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.editor.Document;
import com.lightcrafts.ui.editor.assoc.DocumentDatabase;
import com.lightcrafts.ui.export.ExportNameUtility;
import com.lightcrafts.ui.export.SaveOptions;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlDocument;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class BatchProcessor {
    private static JDialog Dialog;
    private static BatchText Text;
    private static Thread Thread;
    private static BatchProgressBar Progress;
    private static BatchImageComponent Image;
    private static JLabel Label;
    private static JButton Button;
    private static long Start;
    private static boolean Interrupted;
    private static boolean Finished;
    private static boolean Canceled;
    private static RuntimeException Error;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(final ComboFrame frame, final File[] files, final XmlDocument template, final BatchConfig conf) {
        Thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                frame.pause();
                try {
                    BatchProcessor.processTemplate(files, template, conf);
                }
                catch (RuntimeException e) {
                    System.err.println("Unchecked batch processing exception:");
                    e.printStackTrace();
                    Error = e;
                    Dialog.setVisible(false);
                }
                finally {
                    frame.resume();
                }
            }
        }, "Template Applicator");
        Text = new BatchText();
        JScrollPane textScroll = new JScrollPane(Text);
        textScroll.setPreferredSize(new Dimension(400, 300));
        textScroll.setBorder(BorderFactory.createLineBorder(Color.gray));
        Label = new JLabel();
        Label.setAlignmentX(0.5f);
        BatchProcessor.initLabel(files.length);
        Button = new JButton(Locale.LOCALE.get("BatchCancelButton"));
        Button.setAlignmentX(0.5f);
        Image = new BatchImageComponent();
        Progress = new BatchProgressBar();
        Dimension progSize = Progress.getComponent().getPreferredSize();
        progSize.width = BatchProcessor.Image.getPreferredSize().width;
        Progress.getComponent().setMaximumSize(progSize);
        Box imageBox = Box.createVerticalBox();
        imageBox.add(Box.createVerticalGlue());
        imageBox.add(Image);
        imageBox.add(Box.createVerticalStrut(4));
        imageBox.add(Progress.getComponent());
        imageBox.add(Box.createVerticalGlue());
        Box textBox = Box.createVerticalBox();
        textBox.add(textScroll);
        textBox.add(Box.createVerticalStrut(8));
        textBox.add(Label);
        textBox.add(Box.createVerticalStrut(8));
        textBox.add(Button);
        Box content = Box.createHorizontalBox();
        content.add(imageBox);
        content.add(Box.createHorizontalStrut(8));
        content.add(textBox);
        content.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JPanel background = new JPanel(new BorderLayout());
        background.setBackground(LightZoneSkin.Colors.FrameBackground);
        background.setOpaque(true);
        background.add(content);
        Dialog = new JDialog(frame);
        ActionListener disposeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Finished) {
                    Canceled = true;
                    Button.setText("Canceling...");
                } else {
                    Dialog.setVisible(false);
                }
            }
        };
        Button.addActionListener(disposeAction);
        Dialog.setContentPane(background);
        Dialog.setModal(true);
        Dialog.setTitle(Locale.LOCALE.get("BatchDialogTitle"));
        Dialog.getRootPane().setDefaultButton(Button);
        Dialog.pack();
        Dialog.setLocationRelativeTo(frame);
        Dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                Interrupted = true;
            }
        });
        Interrupted = false;
        Finished = false;
        Canceled = false;
        Thread.start();
        Dialog.setVisible(true);
        Thread thread = Thread;
        synchronized (thread) {
            if (!Finished && Error == null) {
                Interrupted = true;
                try {
                    Thread.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            Interrupted = false;
            Finished = false;
            Canceled = false;
        }
        if (Error != null) {
            RuntimeException e = Error;
            Error = null;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processTemplate(File[] files, XmlDocument template, BatchConfig conf) {
        ImageFileExportOptions export = conf.export;
        boolean ignoreResize = export.resizeWidth.getValue() == 0 && export.resizeHeight.getValue() == 0;
        int exportWidth = export.resizeWidth.getValue();
        int exportHeight = export.resizeHeight.getValue();
        for (int n = 0; n < files.length && !Canceled; ++n) {
            if (Interrupted) {
                Thread thread = Thread;
                synchronized (thread) {
                    Thread.notifyAll();
                    return;
                }
            }
            try {
                String outName;
                File outFile;
                File file = files[n];
                Image.setCachedFile(file);
                BatchProcessor.logStart(file);
                Document doc = Application.createDocumentHeadless(file);
                export.resizeWidth.setValue(exportWidth);
                export.resizeHeight.setValue(exportHeight);
                if (template != null) {
                    XmlNode root = template.getRoot();
                    doc.applyTemplate(root);
                    SaveOptions save = doc.getSaveOptions();
                    if (save == null) {
                        save = BatchProcessor.createTemplateSaveOptions(doc, export, ignoreResize);
                    }
                    doc.setSaveOptions(save);
                    ComboFrame frame = (ComboFrame)Dialog.getOwner();
                    DocumentWriter.save(doc, frame, false, Progress);
                    outFile = save.getFile();
                    outName = outFile.getName();
                    DocumentDatabase.addDocumentFile(outFile);
                } else {
                    BatchProcessor.conformExportOptions(doc, conf, ignoreResize);
                    Engine engine = doc.getEngine();
                    DocumentWriter.export(engine, export, Progress);
                    outFile = export.getExportFile();
                    outName = outFile.getName();
                }
                doc.dispose();
                BatchProcessor.logEnd(Locale.LOCALE.get("BatchLogSavedMessage", outName));
                Image.setFile(outFile);
                Progress.reset();
            }
            catch (XMLException e) {
                BatchProcessor.logError(Locale.LOCALE.get("BatchLogXmlError"), e);
            }
            catch (BadImageFileException e) {
                BatchProcessor.logError(Locale.LOCALE.get("BatchLogBadImageError"), e);
            }
            catch (IOException e) {
                BatchProcessor.logError(Locale.LOCALE.get("BatchLogIOError"), e);
            }
            catch (OutOfMemoryError e) {
                BatchProcessor.logError(Locale.LOCALE.get("BatchLogMemoryError"), e);
            }
            catch (UnknownImageTypeException e) {
                BatchProcessor.logError(Locale.LOCALE.get("BatchLogImageTypeError"), e);
            }
            catch (UnsupportedColorProfileException e) {
                BatchProcessor.logError(Locale.LOCALE.get("BatchLogCameraError"), e);
            }
            catch (ColorProfileException e) {
                BatchProcessor.logError(Locale.LOCALE.get("BatchLogColorError"), e);
            }
            catch (Throwable e) {
                BatchProcessor.logError(Locale.LOCALE.get("BatchLogUnknownError"), e);
                e.printStackTrace();
            }
            BatchProcessor.updateLabel(n + 1, files.length);
        }
        Thread thread = Thread;
        synchronized (thread) {
            Finished = true;
            Thread.notifyAll();
            Button.setText(Locale.LOCALE.get("BatchDoneButton"));
        }
    }

    private static SaveOptions createTemplateSaveOptions(Document doc, ImageFileExportOptions export, boolean ignoreResize) {
        SaveOptions options;
        ImageMetadata meta = doc.getMetadata();
        File file = meta.getFile();
        ImageType type = export.getImageType();
        String ext = type.getExtensions()[0];
        file = ExportNameUtility.setFileExtension(file, ext);
        file = ExportNameUtility.ensureNotExists(file);
        if (type == LZNImageType.INSTANCE) {
            SaveOptions options2 = SaveOptions.createLzn(file);
            return options2;
        }
        Engine engine = doc.getEngine();
        Dimension size = engine.getNaturalSize();
        if (type instanceof TIFFImageType) {
            options = SaveOptions.createSidecarTiff(export);
        } else if (type instanceof JPEGImageType) {
            options = SaveOptions.createSidecarJpeg(export);
        } else {
            throw new IllegalArgumentException("Can't save to image type \"" + type.getName() + "\"");
        }
        if (ignoreResize) {
            export.resizeWidth.setValue(size.width);
            export.resizeHeight.setValue(size.height);
        }
        options.setFile(file);
        return options;
    }

    private static void conformExportOptions(Document doc, BatchConfig conf, boolean ignoreResize) {
        ImageMetadata meta = doc.getMetadata();
        File file = meta.getFile();
        String name = file.getName();
        File directory = conf.directory;
        File outFile = new File(directory, name);
        String outLabel = conf.name;
        String outName = ExportNameUtility.trimFileExtension(outFile.getName());
        ImageFileExportOptions export = conf.export;
        String outSuffix = export.getImageType().getExtensions()[0];
        outFile = outLabel.length() > 0 ? new File(directory, outName + outLabel + "." + outSuffix) : new File(directory, outName + "." + outSuffix);
        outFile = ExportNameUtility.ensureNotExists(outFile);
        export.setExportFile(outFile);
        if (ignoreResize) {
            Engine engine = doc.getEngine();
            Dimension size = engine.getNaturalSize();
            export.resizeWidth.setValue(size.width);
            export.resizeHeight.setValue(size.height);
        }
    }

    private static void logStart(File file) {
        String path = file.getName();
        Text.appendStart(path);
    }

    private static void logEnd(String message) {
        Text.appendEnd(message);
    }

    private static void logError(String message, Throwable e) {
        StringBuffer buffer = new StringBuffer();
        if (message != null) {
            buffer.append("--");
            buffer.append(message);
        }
        if (e != null) {
            buffer.append(": ");
            buffer.append(e.getClass().getName());
            buffer.append(" ");
            buffer.append(e.getMessage());
        }
        buffer.append("\n");
        Text.appendError(buffer.toString());
    }

    private static void initLabel(int max) {
        String text = max == 1 ? Locale.LOCALE.get("BatchInitEstimateMessageSingular") : Locale.LOCALE.get("BatchInitEstimateMessagePlural", Integer.toString(max));
        Label.setText(text);
        Start = System.currentTimeMillis();
    }

    private static void updateLabel(final int count, final int max) {
        long now = System.currentTimeMillis();
        long end = Start + (long)max * (now - Start) / (long)count;
        final long remaining = end - now;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int remainingSeconds = (int)(remaining / 1000L);
                int remainingMinutes = remainingSeconds / 60;
                String message = "" + count + " of " + max + " files processed, ";
                message = message + (remainingMinutes > 0 ? remainingMinutes + " minutes and " : "") + (remainingSeconds -= remainingMinutes * 60) + " seconds remaining.";
                Label.setText(message);
            }
        });
    }
}

