/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.batch;

import com.lightcrafts.app.batch.BatchConfig;
import com.lightcrafts.app.batch.HelpButton;
import com.lightcrafts.app.batch.Locale;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.platform.FileChooser;
import com.lightcrafts.platform.Platform;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class SendDialog
extends JDialog {
    private static final String PrefsKey = "Send";
    private static final Map<String, Integer> Sizes = new LinkedHashMap<String, Integer>();
    private BatchConfig conf = new BatchConfig();
    private boolean started;

    private SendDialog(Frame owner, String from, int count) {
        super(owner);
        this.conf.restoreFromPrefs(PrefsKey);
        if (!(this.conf.export instanceof JPEGImageType.ExportOptions)) {
            this.conf.export = JPEGImageType.INSTANCE.newExportOptions();
        }
        JPEGImageType.ExportOptions export = (JPEGImageType.ExportOptions)this.conf.export;
        export.quality.setValue(85);
        export.renderingIntent.setValue(0);
        export.blackPointCompensation.setValue(false);
        if (this.conf.directory == null) {
            this.conf.directory = new File(System.getProperty("user.home"));
        }
        JComboBox<String> sizes = new JComboBox<String>();
        for (String item : Sizes.keySet()) {
            sizes.addItem(item);
        }
        sizes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String name = (String)e.getItem();
                    int size = (Integer)Sizes.get(name);
                    ((SendDialog)SendDialog.this).conf.export.resizeWidth.setValue(size);
                    ((SendDialog)SendDialog.this).conf.export.resizeHeight.setValue(size);
                }
            }
        });
        int size = this.conf.export.resizeWidth.getValue();
        String defaultItem = null;
        for (Map.Entry<String, Integer> entry : Sizes.entrySet()) {
            int value = entry.getValue();
            if (value != size) continue;
            defaultItem = entry.getKey();
        }
        if (defaultItem != null) {
            sizes.setSelectedItem(defaultItem);
        }
        final JTextField dirText = new JTextField(this.conf.directory.getName());
        dirText.setEditable(false);
        JButton dirButton = new JButton(Locale.LOCALE.get("SendDialogChooserButton"));
        dirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform platform = Platform.getPlatform();
                FileChooser chooser = platform.getFileChooser();
                File directory = chooser.chooseDirectory(Locale.LOCALE.get("SendDialogChooserTitle"), ((SendDialog)SendDialog.this).conf.directory, SendDialog.this, false);
                if (directory != null) {
                    ((SendDialog)SendDialog.this).conf.directory = directory;
                    String name = directory.getName();
                    dirText.setText(name);
                    if (dirText.getPreferredSize().width > dirText.getSize().width) {
                        SendDialog.this.pack();
                    }
                }
            }
        });
        JButton start = new JButton(Locale.LOCALE.get("SendDialogStartButton"));
        start.setAlignmentX(0.5f);
        JButton cancel = new JButton(Locale.LOCALE.get("SendDialogCancelButton"));
        cancel.setAlignmentX(0.5f);
        ActionListener disposeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SendDialog.this.setVisible(false);
            }
        };
        start.addActionListener(disposeAction);
        cancel.addActionListener(disposeAction);
        start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SendDialog.this.started = true;
            }
        });
        JLabel header = count > 1 ? new JLabel(Locale.LOCALE.get("SendDialogHeaderPlural", Integer.toString(count), '\"' + from + '\"')) : new JLabel(Locale.LOCALE.get("SendDialogHeaderSingular", '\"' + from + '\"'));
        HelpButton help = new HelpButton();
        help.setAlignmentX(0.0f);
        cancel.setAlignmentX(1.0f);
        start.setAlignmentX(1.0f);
        Box sizeBox = Box.createHorizontalBox();
        sizeBox.add(sizes);
        sizeBox.add(Box.createHorizontalGlue());
        Box buttons = Box.createHorizontalBox();
        buttons.add(help);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(cancel);
        buttons.add(Box.createHorizontalStrut(8));
        buttons.add(start);
        buttons.setMaximumSize(buttons.getPreferredSize());
        JPanel content = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(8, 6, 6, 8);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        content.add((Component)header, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 13;
        content.add((Component)new JLabel(Locale.LOCALE.get("SendDialogOutputLabel")), c);
        c.gridx = 1;
        c.anchor = 17;
        c.fill = 2;
        content.add((Component)dirText, c);
        c.gridx = 2;
        c.anchor = 10;
        c.fill = 0;
        content.add((Component)dirButton, c);
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 13;
        content.add((Component)new JLabel(Locale.LOCALE.get("SendDialogSizelabel")), c);
        c.gridx = 1;
        c.anchor = 17;
        content.add((Component)sizeBox, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        c.anchor = 10;
        c.fill = 2;
        content.add((Component)buttons, c);
        content.setBorder(BorderFactory.createEmptyBorder(0, 16, 16, 16));
        content.registerKeyboardAction(disposeAction, KeyStroke.getKeyStroke(27, 0), 2);
        this.setContentPane(content);
        this.getRootPane().setDefaultButton(start);
        Platform.getPlatform().makeModal(this);
        this.setTitle(Locale.LOCALE.get("SendDialogTitle"));
        this.pack();
        this.setResizable(false);
    }

    public static BatchConfig showDialog(Frame owner, String from, int count) {
        SendDialog dialog = new SendDialog(owner, from, count);
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
        if (dialog.started) {
            dialog.conf.saveToPrefs(PrefsKey);
            return dialog.conf;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(Platform.getPlatform().getLookAndFeel());
        BatchConfig conf = SendDialog.showDialog(null, "Test Folder", 256);
        if (conf != null) {
            conf.writeDebug(System.out);
        } else {
            System.out.println("cancelled");
        }
        System.exit(0);
    }

    static {
        Sizes.put("320x240", 320);
        Sizes.put("640x480", 640);
        Sizes.put("800x600", 800);
        Sizes.put("1024x768", 1024);
        Sizes.put("1280x960", 1280);
        Sizes.put("1920x1440", 1920);
        Sizes.put("2560x1920", 2560);
        Sizes.put("Don't limit", 0);
    }
}

