/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.BrowserMenu;
import com.lightcrafts.app.menu.DebugMenu;
import com.lightcrafts.app.menu.EditMenu;
import com.lightcrafts.app.menu.FileMenu;
import com.lightcrafts.app.menu.HelpMenu;
import com.lightcrafts.app.menu.OperationMenu;
import com.lightcrafts.app.menu.RegionMenu;
import com.lightcrafts.app.menu.TemplatesMenu;
import com.lightcrafts.app.menu.UpdatableDisposableMenu;
import com.lightcrafts.app.menu.ViewMenu;
import com.lightcrafts.app.menu.WindowMenu;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public final class ComboFrameMenuBar
extends JMenuBar {
    private List<UpdatableDisposableMenu> menus = new ArrayList<UpdatableDisposableMenu>();
    private UpdatableDisposableMenu browserMenu;
    private WindowMenu windowMenu;
    private ComboFrame frame;

    public ComboFrameMenuBar() {
        this(null);
        this.update();
    }

    public ComboFrameMenuBar(ComboFrame frame) {
        this.frame = frame;
        this.add(new FileMenu(frame));
        this.add(new EditMenu(frame));
        this.browserMenu = new BrowserMenu(frame);
        this.add(this.browserMenu);
        this.add(new OperationMenu(frame));
        this.add(new RegionMenu(frame));
        this.add(new TemplatesMenu(frame));
        this.add(new ViewMenu(frame));
        this.windowMenu = new WindowMenu(frame);
        this.add(this.windowMenu);
        this.add(new HelpMenu(frame));
        if (System.getProperty("lightcrafts.debug") != null) {
            this.add(new DebugMenu(frame));
        }
    }

    @Override
    public JMenu add(JMenu menu) {
        super.add(menu);
        if (menu instanceof UpdatableDisposableMenu) {
            this.menus.add((UpdatableDisposableMenu)menu);
        }
        return menu;
    }

    public void update() {
        for (UpdatableDisposableMenu menu : this.menus) {
            menu.update();
        }
        if (this.browserMenu == null) {
            this.browserMenu = new BrowserMenu(this.frame);
            this.menus.add(this.browserMenu);
            this.add((Component)this.browserMenu, 2);
        }
    }

    public void dispose() {
        WindowMenu.destroyMenu(this.windowMenu);
        this.windowMenu = null;
        for (UpdatableDisposableMenu menu : this.menus) {
            menu.dispose();
        }
        this.menus.clear();
        this.removeAll();
    }
}

