/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.MenuFactory;
import com.lightcrafts.app.menu.ShowHideRegionsMenuItem;
import com.lightcrafts.app.menu.UpdatableDisposableMenu;
import com.lightcrafts.ui.editor.Document;
import com.lightcrafts.ui.editor.RegionManager;
import com.lightcrafts.ui.region.CurveIterator;
import com.lightcrafts.ui.region.CurveSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class RegionMenu
extends UpdatableDisposableMenu {
    private ActionListener CurveTypeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            JMenuItem polygonItem = (JMenuItem)RegionMenu.this.get("polygon");
            JMenuItem basisItem = (JMenuItem)RegionMenu.this.get("basis");
            JMenuItem bezierItem = (JMenuItem)RegionMenu.this.get("bezier");
            RegionManager regions = (RegionManager)RegionMenu.this.get("regions");
            if (regions != null) {
                if (polygonItem.isSelected()) {
                    regions.setCurveType(0);
                }
                if (basisItem.isSelected()) {
                    regions.setCurveType(4);
                }
                if (bezierItem.isSelected()) {
                    regions.setCurveType(2);
                }
            }
        }
    };
    private CurveSelection.Listener CurveSelectionListener = new CurveSelection.Listener(){

        @Override
        public void selectionChanged(CurveIterator oldSelection, CurveIterator newSelection) {
            RegionMenu.this.put("selection", newSelection);
            boolean isSelected = newSelection.hasNext();
            JMenuItem deleteItem = (JMenuItem)RegionMenu.this.get("delete");
            deleteItem.setEnabled(isSelected);
        }
    };
    private WeakReference<Document> docRef = new WeakReference<Object>(null);

    RegionMenu(ComboFrame frame) {
        super(frame, "Region");
        this.add(new ShowHideRegionsMenuItem(frame));
        final JRadioButtonMenuItem polygonItem = MenuFactory.createRadioButtonMenuItem("Polygon");
        final JRadioButtonMenuItem basisItem = MenuFactory.createRadioButtonMenuItem("Basis");
        final JRadioButtonMenuItem bezierItem = MenuFactory.createRadioButtonMenuItem("Bezier");
        polygonItem.setEnabled(false);
        basisItem.setEnabled(false);
        bezierItem.setEnabled(false);
        ButtonGroup group = new ButtonGroup();
        group.add(polygonItem);
        group.add(basisItem);
        group.add(bezierItem);
        this.addSeparator();
        this.add(polygonItem);
        this.add(basisItem);
        this.add(bezierItem);
        this.put("polygon", polygonItem);
        this.put("basis", basisItem);
        this.put("bezier", bezierItem);
        polygonItem.addActionListener(this.CurveTypeListener);
        basisItem.addActionListener(this.CurveTypeListener);
        bezierItem.addActionListener(this.CurveTypeListener);
        JMenuItem deleteItem = MenuFactory.createMenuItem("Delete");
        deleteItem.setEnabled(false);
        this.addSeparator();
        this.add(deleteItem);
        this.put("delete", deleteItem);
        deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RegionManager regions = (RegionManager)RegionMenu.this.get("regions");
                CurveIterator selection = (CurveIterator)RegionMenu.this.get("selection");
                regions.unShareShapes(selection);
            }
        });
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                RegionManager regions = (RegionManager)RegionMenu.this.get("regions");
                if (regions != null) {
                    int curveType = regions.getCurveType();
                    switch (curveType) {
                        case 0: {
                            polygonItem.setSelected(true);
                            break;
                        }
                        case 2: {
                            bezierItem.setSelected(true);
                            break;
                        }
                        case 4: {
                            basisItem.setSelected(true);
                        }
                    }
                }
            }
        });
    }

    @Override
    void update() {
        Document oldDoc;
        ComboFrame frame = this.getComboFrame();
        Document newDoc = frame != null ? frame.getDocument() : null;
        if (newDoc != (oldDoc = (Document)this.docRef.get())) {
            RegionManager regions;
            JMenuItem polygonItem = (JMenuItem)this.get("polygon");
            JMenuItem bezierItem = (JMenuItem)this.get("bezier");
            JMenuItem basisItem = (JMenuItem)this.get("basis");
            boolean hasDoc = newDoc != null;
            polygonItem.setEnabled(hasDoc);
            bezierItem.setEnabled(hasDoc);
            basisItem.setEnabled(hasDoc);
            this.remove("selection");
            if (oldDoc != null) {
                regions = oldDoc.getRegionManager();
                regions.removeSelectionListener(this.CurveSelectionListener);
                this.remove("regions");
            }
            if (newDoc != null) {
                regions = newDoc.getRegionManager();
                regions.addSelectionListener(this.CurveSelectionListener);
                this.put("regions", regions);
            }
            this.docRef = new WeakReference<Document>(newDoc);
        }
        super.update();
    }
}

