/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.DocumentMenuItem;
import com.lightcrafts.ui.editor.Document;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.Action;

class RevertMenuItem
extends DocumentMenuItem
implements PropertyChangeListener {
    WeakReference docRef = new WeakReference<Object>(null);

    RevertMenuItem(ComboFrame frame) {
        super(frame, "Revert");
        Document doc = this.getDocument();
        if (doc != null) {
            Action undo = doc.getUndoAction();
            undo.addPropertyChangeListener(this);
            this.setEnabled(undo.isEnabled());
        } else {
            this.setEnabled(false);
        }
        this.docRef = new WeakReference<Document>(doc);
    }

    @Override
    void update() {
        Document oldDoc;
        Document newDoc = this.getDocument();
        if (newDoc != (oldDoc = (Document)this.docRef.get())) {
            if (oldDoc != null) {
                Action oldUndo = oldDoc.getUndoAction();
                oldUndo.removePropertyChangeListener(this);
            }
            if (newDoc != null) {
                Action newUndo = newDoc.getUndoAction();
                newUndo.addPropertyChangeListener(this);
                this.setEnabled(newUndo.isEnabled());
            } else {
                this.setEnabled(false);
            }
            this.docRef = new WeakReference<Document>(newDoc);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.performPreAction(event);
        ComboFrame frame = this.getComboFrame();
        Application.reOpen(frame);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("enabled")) {
            this.setEnabled(evt.getNewValue().equals(Boolean.TRUE));
        }
    }
}

