/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.BrowserLayoutMenuItem;
import com.lightcrafts.app.menu.EditorLayoutMenuItem;
import com.lightcrafts.app.menu.RotateLeftMenuItem;
import com.lightcrafts.app.menu.RotateRightMenuItem;
import com.lightcrafts.app.menu.UpdatableDisposableMenu;
import com.lightcrafts.app.menu.Zoom1To1MenuItem;
import com.lightcrafts.app.menu.ZoomFitMenuItem;
import com.lightcrafts.app.menu.ZoomInMenuItem;
import com.lightcrafts.app.menu.ZoomOutMenuItem;
import com.lightcrafts.model.Preview;
import com.lightcrafts.ui.editor.Document;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

final class ViewMenu
extends UpdatableDisposableMenu {
    private List<JMenuItem> rotateItems;
    private List<JMenuItem> zoomItems;
    private WeakReference<Document> docRef = new WeakReference<Object>(null);

    ViewMenu(ComboFrame frame) {
        super(frame, "View");
        Document doc;
        this.rotateItems = new LinkedList<JMenuItem>();
        this.zoomItems = new LinkedList<JMenuItem>();
        this.rotateItems.add(new RotateLeftMenuItem(frame));
        this.rotateItems.add(new RotateRightMenuItem(frame));
        this.zoomItems.add(new ZoomInMenuItem(frame));
        this.zoomItems.add(new ZoomOutMenuItem(frame));
        this.zoomItems.add(new ZoomFitMenuItem(frame));
        this.zoomItems.add(new Zoom1To1MenuItem(frame));
        this.addFixedItems();
        this.addSeparator();
        this.addLayoutItems();
        Document document = doc = frame != null ? frame.getDocument() : null;
        if (doc != null) {
            this.addSeparator();
            this.addPreviewItems();
        }
    }

    @Override
    void update() {
        Document oldDoc;
        ComboFrame frame = this.getComboFrame();
        Document newDoc = frame != null ? frame.getDocument() : null;
        if (newDoc != (oldDoc = (Document)this.docRef.get())) {
            this.removeAll();
            this.addFixedItems();
            this.addSeparator();
            this.addLayoutItems();
            if (newDoc != null) {
                this.addSeparator();
                this.addPreviewItems();
            }
            this.docRef = new WeakReference<Document>(newDoc);
        }
        super.update();
    }

    private void addFixedItems() {
        for (JMenuItem item : this.rotateItems) {
            this.add(item);
        }
        this.addSeparator();
        for (JMenuItem item : this.zoomItems) {
            this.add(item);
        }
    }

    private void addLayoutItems() {
        ComboFrame frame = this.getComboFrame();
        this.add(new EditorLayoutMenuItem(frame));
        this.add(new BrowserLayoutMenuItem(frame));
    }

    private void addPreviewItems() {
        ComboFrame frame = this.getComboFrame();
        final Document doc = frame.getDocument();
        List<Preview> previews = doc.getEngine().getPreviews();
        int previewCount = 0;
        for (final Preview preview : previews) {
            if (previewCount == 0) {
                ++previewCount;
                continue;
            }
            String name = preview.getName();
            JMenuItem previewItem = new JMenuItem(name);
            previewItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    doc.getEditor().setPreview(preview);
                }
            });
            KeyStroke stroke = ViewMenu.getKeyStroke(previewCount++);
            previewItem.setAccelerator(stroke);
            this.add(previewItem);
        }
    }

    private static KeyStroke getKeyStroke(int i) {
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        return KeyStroke.getKeyStroke(48 + i, mask);
    }
}

