/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image;

import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.utils.file.FileUtil;
import java.io.File;
import java.io.FileFilter;

public final class ImageFileFilter
implements FileFilter {
    public static final ImageFileFilter INSTANCE = new ImageFileFilter();

    @Override
    public boolean accept(File file) {
        if (file.isHidden() || file.isDirectory() || !file.isFile()) {
            return false;
        }
        File resolvedFile = FileUtil.resolveAliasFile(file);
        if (resolvedFile != file) {
            return this.accept(resolvedFile);
        }
        return ImageType.determineTypeByExtensionOf(file) != null;
    }

    private ImageFileFilter() {
    }
}

