/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ColorProfileException;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.CoreDirectory;
import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.XMPMetadataReader;
import com.lightcrafts.image.types.AuxiliaryImageInfo;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.LZNDocumentProvider;
import com.lightcrafts.image.types.RawImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.image.types.TrueImageTypeProvider;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.editor.LightweightDocument;
import com.lightcrafts.utils.CloseableManager;
import com.lightcrafts.utils.UserCanceledException;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import com.lightcrafts.utils.bytebuffer.SoftChunkyFileByteBuffer;
import com.lightcrafts.utils.file.FileUtil;
import com.lightcrafts.utils.thread.ProgressThread;
import com.lightcrafts.utils.xml.XmlDocument;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.w3c.dom.Document;

public final class ImageInfo {
    private static final boolean USE_MMAP = false;
    private AuxiliaryImageInfo m_auxInfo;
    private LCByteBuffer m_byteBuffer;
    private final File m_imageFile;
    private WeakReference<PlanarImage> m_imageRef;
    private ImageType m_imageType;
    private ImageMetadata m_metadata;
    private File m_originalImageFile;
    private WeakReference<RenderedImage> m_previewImageRef;
    private WeakReference<RenderedImage> m_thumbnailImageRef;

    public boolean canWriteMetadata() {
        if (Platform.getType() != Platform.Windows && !this.m_imageFile.getParentFile().canWrite()) {
            return false;
        }
        try {
            ImageType t = this.getImageType();
            if (t instanceof JPEGImageType) {
                return this.m_imageFile.canWrite();
            }
            File xmpFile = new File(this.getXMPFilename());
            return !xmpFile.exists() || xmpFile.canWrite();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void closeAll() throws IOException {
        ImageFileManager.INSTANCE.closeAllBut(0);
    }

    public boolean equals(Object o) {
        if (o instanceof ImageInfo) {
            ImageInfo otherInfo = (ImageInfo)o;
            return this.m_imageFile.equals(otherInfo.m_imageFile);
        }
        return false;
    }

    public int hashCode() {
        return this.m_imageFile.hashCode() + 1;
    }

    public synchronized AuxiliaryImageInfo getAuxiliaryInfo() throws BadImageFileException, IOException, UnknownImageTypeException {
        if (this.m_auxInfo == null) {
            this.m_auxInfo = this.getImageType().newAuxiliaryInfo(this);
        }
        return this.m_auxInfo;
    }

    public synchronized LCByteBuffer getByteBuffer() {
        if (this.m_byteBuffer == null) {
            this.m_byteBuffer = new SoftChunkyFileByteBuffer(this.m_imageFile, ImageFileManager.INSTANCE);
        }
        return this.m_byteBuffer;
    }

    public ImageType getCurrentImageType() {
        return this.m_imageType;
    }

    public synchronized ImageMetadata getCurrentMetadata() {
        if (this.m_metadata == null) {
            this.m_metadata = new ImageMetadata();
        }
        return this.m_metadata;
    }

    public File getFile() {
        return this.m_imageFile;
    }

    public PlanarImage getImage(ProgressThread thread) throws BadImageFileException, ColorProfileException, IOException, UnknownImageTypeException, UserCanceledException {
        return this.getImage(thread, false);
    }

    public synchronized PlanarImage getImage(ProgressThread thread, boolean read2ndTIFFImage) throws BadImageFileException, ColorProfileException, IOException, UnknownImageTypeException, UserCanceledException {
        ImageType t;
        PlanarImage strongRef;
        PlanarImage planarImage = strongRef = this.m_imageRef != null ? (PlanarImage)this.m_imageRef.get() : null;
        if (strongRef == null && (strongRef = (t = this.getImageType()) instanceof TIFFImageType ? TIFFImageType.getImage(this, thread, read2ndTIFFImage) : t.getImage(this, thread)) != null) {
            this.m_imageRef = new WeakReference<PlanarImage>(strongRef);
        }
        return strongRef;
    }

    public synchronized ImageType getImageType() throws BadImageFileException, IOException, UnknownImageTypeException {
        if (this.m_imageType == null) {
            this.determinePreliminaryImageType();
            this.determineFinalImageType();
        }
        return this.m_imageType;
    }

    public static ImageInfo getInstanceFor(File file) {
        return new ImageInfo(file);
    }

    public synchronized ImageMetadata getMetadata() throws BadImageFileException, IOException, UnknownImageTypeException {
        this.getCurrentMetadata();
        if (this.m_metadata.isEmpty()) {
            this.m_metadata.putDirectory(PlaceHolderDirectory.INSTANCE);
            this.determinePreliminaryImageType();
            this.m_imageType.readMetadata(this);
            this.determineFinalImageType();
            CoreDirectory.addOriginalOrientation(this);
            ImageMetadata xmpMetadata = this.readXMPMetadata();
            if (xmpMetadata != null) {
                this.m_metadata.mergeFrom(xmpMetadata);
            }
            CoreDirectory.addMetadata(this);
            this.m_metadata.removeAllEmptyDirectories();
            this.m_metadata.clearEdited();
        }
        return this.m_metadata;
    }

    public synchronized File getOriginalFile() throws BadImageFileException, IOException, UnknownImageTypeException {
        Document lznDoc;
        XmlDocument xmlDocument;
        LightweightDocument lwDoc;
        File originalFile;
        ImageType t;
        if (this.m_originalImageFile == null && (t = this.getImageType()) instanceof LZNDocumentProvider && !this.m_imageFile.equals(originalFile = (lwDoc = new LightweightDocument(this.m_imageFile, xmlDocument = new XmlDocument(lznDoc = ((LZNDocumentProvider)((Object)t)).getLZNDocument(this)))).getImageFile())) {
            this.m_originalImageFile = originalFile;
        }
        return this.m_originalImageFile;
    }

    public RenderedImage getPreviewImage() throws BadImageFileException, ColorProfileException, IOException, UnknownImageTypeException {
        return this.getPreviewImage(0, 0);
    }

    public synchronized RenderedImage getPreviewImage(int maxWidth, int maxHeight) throws BadImageFileException, ColorProfileException, IOException, UnknownImageTypeException {
        ImageType t;
        RenderedImage strongRef;
        RenderedImage renderedImage = strongRef = this.m_previewImageRef != null ? (RenderedImage)this.m_previewImageRef.get() : null;
        if (strongRef == null && (strongRef = (t = this.getImageType()).getPreviewImage(this, maxWidth, maxHeight)) != null) {
            this.m_previewImageRef = new WeakReference<RenderedImage>(strongRef);
        }
        return strongRef;
    }

    public synchronized RenderedImage getThumbnailImage() throws BadImageFileException, ColorProfileException, IOException, UnknownImageTypeException {
        ImageType t;
        RenderedImage strongRef;
        RenderedImage renderedImage = strongRef = this.m_thumbnailImageRef != null ? (RenderedImage)this.m_thumbnailImageRef.get() : null;
        if (strongRef == null && (strongRef = (t = this.getImageType()).getThumbnailImage(this)) != null) {
            this.m_thumbnailImageRef = new WeakReference<RenderedImage>(strongRef);
        }
        return strongRef;
    }

    public String getXMPFilename() throws BadImageFileException, IOException, UnknownImageTypeException {
        ImageType t = this.getImageType();
        String fileName = this.m_imageFile.getAbsolutePath();
        int dot = fileName.lastIndexOf(46);
        if (dot <= 0 || dot == fileName.length() - 1) {
            throw new UnknownImageTypeException("no filename extension");
        }
        if (t instanceof RawImageType) {
            return fileName.substring(0, dot + 1) + "xmp";
        }
        return fileName.substring(0, dot) + '_' + fileName.substring(dot + 1) + ".xmp";
    }

    public void setMetadata(ImageMetadata newMetadata) {
        this.m_metadata = newMetadata;
    }

    public String toString() {
        return this.m_imageFile.toString();
    }

    private ImageInfo(File file) {
        this.m_imageFile = FileUtil.resolveAliasFile(file);
    }

    private void determineFinalImageType() throws BadImageFileException, IOException {
        TrueImageTypeProvider p;
        ImageType trueType;
        if (this.m_imageType instanceof TrueImageTypeProvider && (trueType = (p = (TrueImageTypeProvider)((Object)this.m_imageType)).getTrueImageTypeOf(this)) != null) {
            this.m_imageType = trueType;
        }
        if (this.m_metadata != null) {
            this.m_metadata.setImageType(this.m_imageType);
        }
    }

    private void determinePreliminaryImageType() throws UnknownImageTypeException {
        if (this.m_imageType == null) {
            this.m_imageType = ImageType.determineTypeByExtensionOf(this.m_imageFile);
            if (this.m_imageType == null) {
                throw new UnknownImageTypeException(this.m_imageFile.getName());
            }
        }
    }

    private ImageMetadata readXMPMetadata() throws BadImageFileException, IOException, UnknownImageTypeException {
        String xmpFilename = this.getXMPFilename();
        if (xmpFilename != null) {
            try {
                return XMPMetadataReader.readFrom(new File(xmpFilename));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static final class PlaceHolderDirectory
    extends ImageMetadataDirectory {
        static final PlaceHolderDirectory INSTANCE = new PlaceHolderDirectory();

        private PlaceHolderDirectory() {
        }

        @Override
        public String getName() {
            return "PlaceHolder";
        }

        @Override
        public ImageMetaTagInfo getTagInfoFor(Integer id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImageMetaTagInfo getTagInfoFor(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected ResourceBundle getTagLabelBundle() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Class<? extends ImageMetaTags> getTagsInterface() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ImageFileManager
    implements CloseableManager {
        static final ImageFileManager INSTANCE = new ImageFileManager();
        private static final int MAX_OPEN_FILES = 2;
        private final LinkedList<Closeable> m_closeableList = new LinkedList();

        private ImageFileManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void manage(Closeable closeable) throws IOException {
            LinkedList<Closeable> linkedList = this.m_closeableList;
            synchronized (linkedList) {
                this.closeAllBut(2);
                this.m_closeableList.add(closeable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeAllBut(int n) throws IOException {
            LinkedList<Closeable> linkedList = this.m_closeableList;
            synchronized (linkedList) {
                while (this.m_closeableList.size() > n) {
                    Closeable closeable;
                    Closeable closeable2 = closeable = this.m_closeableList.removeFirst();
                    synchronized (closeable2) {
                        closeable.close();
                    }
                }
            }
        }
    }
}

