/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.export;

import com.lightcrafts.image.export.ImageExportOption;
import com.lightcrafts.image.export.ImageExportOptionReader;
import com.lightcrafts.image.export.ImageExportOptionWriter;
import com.lightcrafts.image.export.IntegerExportOption;
import com.lightcrafts.image.export.OriginalHeightOption;
import com.lightcrafts.image.export.OriginalWidthOption;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class ImageExportOptions {
    public final OriginalWidthOption originalWidth;
    public final OriginalHeightOption originalHeight;
    static final String ValueTag = "value";
    private byte[] m_auxData;
    private File m_exportFile;
    private final Map<String, ImageExportOption> m_exportOptions = new HashMap<String, ImageExportOption>();
    private final ImageType m_imageType;
    private static final String ExportOptionsTag = "ExportOptions";
    private static final String TypeTag = "type";
    private static final String FileTag = "file";

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        ImageExportOptions otherOpts = (ImageExportOptions)o;
        File otherExportFile = otherOpts.getExportFile();
        if (otherExportFile == null ? this.getExportFile() != null : !otherExportFile.equals(this.getExportFile())) {
            return false;
        }
        if (!otherOpts.getImageType().equals(this.getImageType())) {
            return false;
        }
        Map<String, ImageExportOption> om = otherOpts.m_exportOptions;
        if (om.size() != this.m_exportOptions.size()) {
            return false;
        }
        for (Map.Entry<String, ImageExportOption> me : om.entrySet()) {
            ImageExportOption opt = this.m_exportOptions.get(me.getKey());
            if (opt != null && opt.equals(me.getValue())) continue;
            return false;
        }
        return true;
    }

    public final byte[] getAuxData() {
        return this.m_auxData;
    }

    public final File getExportFile() {
        return this.m_exportFile;
    }

    public final ImageType getImageType() {
        return this.m_imageType;
    }

    public final int getIntValueOf(String className) {
        IntegerExportOption option = (IntegerExportOption)this.getOption(ImageExportOptions.fixClassName(className));
        return option != null ? option.getValue() : 0;
    }

    public final ImageExportOption getOption(String className) {
        return this.m_exportOptions.get(ImageExportOptions.fixClassName(className));
    }

    public final int hashCode() {
        return this.m_imageType.hashCode() + ((Object)this.m_exportOptions).hashCode() + 1;
    }

    public final void setAuxData(byte[] data) {
        this.m_auxData = data;
    }

    public final void setExportFile(File file) {
        this.m_exportFile = file;
    }

    public final void setIntValueOf(String className, int newValue) {
        IntegerExportOption option = (IntegerExportOption)this.getOption(ImageExportOptions.fixClassName(className));
        if (option == null) {
            throw new IllegalArgumentException(className);
        }
        option.setValue(newValue);
    }

    public final void setValueOf(String className, String newValue) {
        ImageExportOption option = this.getOption(className);
        if (option == null) {
            throw new IllegalArgumentException(className);
        }
        option.setValue(newValue);
    }

    public void write(XmlNode node) {
        node = node.addChild(ExportOptionsTag);
        node.setAttribute(TypeTag, this.m_imageType.getName());
        this.save(node);
        if (this.m_exportFile != null) {
            node.setAttribute(FileTag, this.m_exportFile.getAbsolutePath());
        }
    }

    public static ImageExportOptions read(XmlNode node) throws XMLException {
        String typeName = (node = node.getChild(ExportOptionsTag)).getAttribute(TypeTag);
        ImageType type = ImageType.getImageTypeByName(typeName);
        if (type == null) {
            throw new XMLException("Unrecognized image export type");
        }
        ImageExportOptions options = type.newExportOptions();
        options.restore(node);
        if (node.hasAttribute(FileTag)) {
            options.m_exportFile = new File(node.getAttribute(FileTag));
        }
        return options;
    }

    public void readFrom(ImageExportOptionReader r) throws IOException {
        this.originalWidth.readFrom(r);
        this.originalHeight.readFrom(r);
    }

    public void writeTo(ImageExportOptionWriter w) throws IOException {
        this.originalWidth.writeTo(w);
        this.originalHeight.writeTo(w);
    }

    protected ImageExportOptions(ImageType imageType) {
        this.originalWidth = new OriginalWidthOption(0, this);
        this.originalHeight = new OriginalHeightOption(0, this);
        this.m_imageType = imageType;
    }

    protected void save(XmlNode node) {
        this.originalWidth.save(node);
        this.originalHeight.save(node);
    }

    protected void restore(XmlNode node) throws XMLException {
        this.originalWidth.restore(node);
        this.originalHeight.restore(node);
    }

    final void addOption(ImageExportOption option) {
        this.m_exportOptions.put(option.getName(), option);
    }

    private static String fixClassName(String className) {
        if (!className.startsWith("com.")) {
            className = ImageExportOptions.class.getPackage().getName() + '.' + className;
        }
        if (!className.endsWith("Option")) {
            className = className + "Option";
        }
        return className;
    }
}

