/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.export;

import com.lightcrafts.image.export.BlackPointCompensationOption;
import com.lightcrafts.image.export.ColorProfileOption;
import com.lightcrafts.image.export.ImageExportOptionReader;
import com.lightcrafts.image.export.ImageExportOptionWriter;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.export.RenderingIntentOption;
import com.lightcrafts.image.export.ResizeHeightOption;
import com.lightcrafts.image.export.ResizeWidthOption;
import com.lightcrafts.image.export.ResolutionOption;
import com.lightcrafts.image.export.ResolutionUnitOption;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.io.IOException;

public abstract class ImageFileExportOptions
extends ImageExportOptions {
    public final BlackPointCompensationOption blackPointCompensation = new BlackPointCompensationOption(this);
    public final ColorProfileOption colorProfile = new ColorProfileOption(this);
    public final RenderingIntentOption renderingIntent = new RenderingIntentOption(this);
    public final ResizeWidthOption resizeWidth = new ResizeWidthOption(0, (ImageExportOptions)this);
    public final ResizeHeightOption resizeHeight = new ResizeHeightOption(0, (ImageExportOptions)this);
    public final ResolutionOption resolution = new ResolutionOption(this);
    public final ResolutionUnitOption resolutionUnit = new ResolutionUnitOption(this);

    @Override
    public void readFrom(ImageExportOptionReader r) throws IOException {
        super.readFrom(r);
        try {
            this.blackPointCompensation.readFrom(r);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.colorProfile.readFrom(r);
        this.renderingIntent.readFrom(r);
        this.resizeWidth.readFrom(r);
        this.resizeHeight.readFrom(r);
        try {
            this.resolution.readFrom(r);
            this.resolutionUnit.readFrom(r);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void writeTo(ImageExportOptionWriter w) throws IOException {
        super.writeTo(w);
        this.blackPointCompensation.writeTo(w);
        this.colorProfile.writeTo(w);
        this.renderingIntent.writeTo(w);
        this.resizeWidth.writeTo(w);
        this.resizeHeight.writeTo(w);
        this.resolution.writeTo(w);
        this.resolutionUnit.writeTo(w);
    }

    protected ImageFileExportOptions(ImageType imageType) {
        super(imageType);
    }

    @Override
    protected void save(XmlNode node) {
        super.save(node);
        this.blackPointCompensation.save(node);
        this.colorProfile.save(node);
        this.renderingIntent.save(node);
        this.resizeWidth.save(node);
        this.resizeHeight.save(node);
        this.resolution.save(node);
        this.resolutionUnit.save(node);
    }

    @Override
    protected void restore(XmlNode node) throws XMLException {
        super.restore(node);
        if (node.hasChild(this.blackPointCompensation.getName())) {
            this.blackPointCompensation.restore(node);
        }
        this.colorProfile.restore(node);
        if (node.hasChild(this.renderingIntent.getName())) {
            this.renderingIntent.restore(node);
        }
        this.resizeWidth.restore(node);
        this.resizeHeight.restore(node);
        if (node.hasChild(this.resolution.getName())) {
            this.resolution.restore(node);
        }
        if (node.hasChild(this.resolutionUnit.getName())) {
            this.resolutionUnit.restore(node);
        }
    }
}

