/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.libs;

import com.lightcrafts.image.libs.LCImageDataProvider;
import com.lightcrafts.image.libs.LCImageLibException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public final class InputStreamImageDataProvider
implements LCImageDataProvider {
    private ReadableByteChannel m_channel;

    public InputStreamImageDataProvider(InputStream stream) {
        this.m_channel = Channels.newChannel(stream);
    }

    public synchronized void dispose() {
        if (this.m_channel != null) {
            ReadableByteChannel temp = this.m_channel;
            this.m_channel = null;
            try {
                temp.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getImageData(ByteBuffer buf) throws IOException, LCImageLibException {
        buf.clear();
        return this.m_channel.read(buf);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

