/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.CIFFDirectory;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.ImageMetadataReader;
import com.lightcrafts.image.metadata.values.DateMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.StringMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedByteMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedLongMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedShortMetaValue;
import java.io.IOException;
import java.nio.ByteOrder;

public final class CIFFMetadataReader
extends ImageMetadataReader {
    public CIFFMetadataReader(ImageInfo imageInfo) {
        super(imageInfo, imageInfo.getByteBuffer());
    }

    @Override
    protected void readAllDirectories() throws IOException {
        int rootDirBlockOffset = this.m_buf.getInt(2);
        int rootDirBlockLen = this.m_buf.limit() - rootDirBlockOffset;
        ImageMetadataDirectory dir = this.m_metadata.getDirectoryFor(CIFFDirectory.class, true);
        this.readDirectory(rootDirBlockOffset, rootDirBlockLen, dir);
    }

    @Override
    protected void readHeader() throws BadImageFileException, IOException {
        this.m_buf.position(0);
        if (this.m_buf.remaining() < 14) {
            throw new BadImageFileException(this.m_imageInfo.getFile());
        }
        short byteOrder = this.m_buf.getShort();
        if (byteOrder == 18761) {
            this.m_buf.order(ByteOrder.LITTLE_ENDIAN);
        } else if (byteOrder != 19789) {
            throw new BadImageFileException(this.m_imageInfo.getFile());
        }
    }

    private static int calcEntryPosition(int dirEntryOffset, int entry) {
        return dirEntryOffset + entry * 10 + 2;
    }

    private static int fieldSize(int fieldType) {
        switch (fieldType) {
            case 0: 
            case 2048: 
            case 8192: {
                return 1;
            }
            case 4096: {
                return 2;
            }
            case 6144: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }

    private void readDirectory(int dirBlockOffset, int dirBlockLen, ImageMetadataDirectory dir) throws IOException {
        int dirEntryOffset = dirBlockOffset + this.m_buf.getInt(dirBlockOffset + dirBlockLen - 4);
        int entryCount = this.m_buf.getShort(dirEntryOffset);
        if (entryCount > 256) {
            entryCount = 256;
        }
        for (int entry = 0; entry < entryCount; ++entry) {
            int pos = CIFFMetadataReader.calcEntryPosition(dirEntryOffset, entry);
            try {
                this.readDirectoryEntry(dirBlockOffset, pos, dir);
                continue;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                this.logBadImageMetadata(e);
            }
        }
    }

    private boolean readDirectoryEntry(int blockOffset, int offset, ImageMetadataDirectory dir) throws IOException {
        this.m_buf.position(offset);
        int tagBits = this.m_buf.getUnsignedShort();
        if (tagBits < 1) {
            this.logBadImageMetadata();
            return false;
        }
        int entryLen = this.m_buf.getInt();
        int valueOffset = this.m_buf.getInt();
        int tagID = tagBits & 0x3FFF;
        int dataFormat = tagBits & 0x3800;
        if ((tagBits & 0x4000) != 0) {
            entryLen = 8;
            valueOffset = offset + 2;
        } else {
            valueOffset += blockOffset;
            switch (tagID) {
                case 8199: {
                    dir.putValue(0x200702, new UnsignedLongMetaValue(valueOffset));
                    dir.putValue(2098945, new UnsignedLongMetaValue(entryLen));
                    return true;
                }
            }
            switch (dataFormat) {
                case 10240: 
                case 12288: {
                    this.readDirectory(valueOffset, entryLen, dir);
                    return true;
                }
                case 8192: {
                    return true;
                }
            }
        }
        int numValues = entryLen / CIFFMetadataReader.fieldSize(dataFormat);
        ImageMetaValue value = this.readValue(tagID, dataFormat, valueOffset, numValues);
        if (value != null) {
            try {
                dir.putValue(tagID, value);
            }
            catch (IllegalArgumentException e) {
                this.logBadImageMetadata();
            }
        }
        return true;
    }

    private String readMakeModel(int offset, int length) throws IOException {
        byte[] bytes = this.m_buf.getBytes(offset, length);
        while (length > 0 && bytes[length - 1] != 0) {
            --length;
        }
        return length > 0 ? new String(bytes, 0, length) : null;
    }

    private String readString(int offset, int maxLength) throws IOException {
        int length;
        for (length = 0; this.m_buf.get(offset + length) != 0 && length < maxLength; ++length) {
        }
        return this.m_buf.getString(offset, length, "ISO-8859-1");
    }

    private ImageMetaValue readValue(int tagID, int fieldType, int offset, int numValues) throws IOException {
        switch (tagID) {
            case 6158: {
                long seconds = this.m_buf.getInt(offset);
                int tzOffset = this.m_buf.getInt(offset + 4);
                int tzInfo = this.m_buf.getInt(offset + 8);
                if ((tzInfo & Integer.MIN_VALUE) != 0) {
                    seconds += (long)tzOffset;
                }
                return new DateMetaValue(seconds * 1000L);
            }
        }
        switch (fieldType) {
            case 2048: {
                String s;
                switch (tagID) {
                    case 2058: {
                        s = this.readMakeModel(offset, numValues);
                        break;
                    }
                    default: {
                        s = this.readString(offset, numValues);
                    }
                }
                return s != null ? new StringMetaValue(s) : null;
            }
            case 0: {
                long[] values = new long[numValues];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getUnsignedByte(offset + i);
                }
                return new UnsignedByteMetaValue(values);
            }
            case 6144: {
                long[] values = new long[numValues];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getInt(offset + i * 4);
                }
                return new UnsignedLongMetaValue(values);
            }
            case 4096: {
                long[] values = new long[numValues];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getShort(offset + i * 2);
                }
                return new UnsignedShortMetaValue(values);
            }
        }
        this.logBadImageMetadata();
        return null;
    }
}

