/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.CoreTags;
import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.ImageOrientation;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.XMPConstants;
import com.lightcrafts.image.metadata.XMPUtil;
import com.lightcrafts.image.metadata.providers.ApertureProvider;
import com.lightcrafts.image.metadata.providers.ArtistProvider;
import com.lightcrafts.image.metadata.providers.CaptionProvider;
import com.lightcrafts.image.metadata.providers.CaptureDateTimeProvider;
import com.lightcrafts.image.metadata.providers.ColorTemperatureProvider;
import com.lightcrafts.image.metadata.providers.CopyrightProvider;
import com.lightcrafts.image.metadata.providers.FileDateTimeProvider;
import com.lightcrafts.image.metadata.providers.FlashProvider;
import com.lightcrafts.image.metadata.providers.FocalLengthProvider;
import com.lightcrafts.image.metadata.providers.ISOProvider;
import com.lightcrafts.image.metadata.providers.ImageMetadataProvider;
import com.lightcrafts.image.metadata.providers.LensProvider;
import com.lightcrafts.image.metadata.providers.MakeModelProvider;
import com.lightcrafts.image.metadata.providers.OrientationProvider;
import com.lightcrafts.image.metadata.providers.OriginalWidthHeightProvider;
import com.lightcrafts.image.metadata.providers.RatingProvider;
import com.lightcrafts.image.metadata.providers.ShutterSpeedProvider;
import com.lightcrafts.image.metadata.providers.WidthHeightProvider;
import com.lightcrafts.image.metadata.values.DateMetaValue;
import com.lightcrafts.image.metadata.values.FloatMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.StringMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedLongMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedShortMetaValue;
import com.lightcrafts.image.types.AuxiliaryImageInfo;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.RawImageInfo;
import com.lightcrafts.utils.ColorProfileInfo;
import com.lightcrafts.utils.DCRaw;
import com.lightcrafts.utils.TextUtil;
import com.lightcrafts.utils.Version;
import com.lightcrafts.utils.xml.XMLUtil;
import java.awt.Dimension;
import java.awt.color.ICC_Profile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class CoreDirectory
extends ImageMetadataDirectory
implements ApertureProvider,
ArtistProvider,
CaptionProvider,
CaptureDateTimeProvider,
ColorTemperatureProvider,
CopyrightProvider,
FileDateTimeProvider,
FlashProvider,
FocalLengthProvider,
ISOProvider,
LensProvider,
MakeModelProvider,
OrientationProvider,
OriginalWidthHeightProvider,
RatingProvider,
ShutterSpeedProvider,
WidthHeightProvider {
    private static final String FIVE_STARS = "\u2605\u2605\u2605\u2605\u2605";
    private static final ResourceBundle m_tagBundle = ResourceBundle.getBundle("com.lightcrafts.image.metadata.CoreTags");
    private static final Map<Integer, ImageMetaTagInfo> m_tagsByID = new HashMap<Integer, ImageMetaTagInfo>();
    private static final Map<String, ImageMetaTagInfo> m_tagsByName = new HashMap<String, ImageMetaTagInfo>();

    public static void addMetadata(ImageInfo imageInfo) {
        ImageMetadata metadata = imageInfo.getCurrentMetadata();
        CoreDirectory dir = (CoreDirectory)metadata.getDirectoryFor(CoreDirectory.class, true);
        dir.addAperture(metadata);
        dir.addCamera(imageInfo);
        dir.addCaptureDateTime(imageInfo);
        dir.addColorProfile(imageInfo);
        dir.addColorTemperature(metadata);
        dir.addFileInfo(imageInfo);
        dir.addFlash(metadata);
        dir.addFocalLength(metadata);
        dir.addImageDimensions(imageInfo);
        dir.addISO(metadata);
        dir.addLens(metadata);
        dir.addOrientation(metadata);
        dir.addResolution(metadata);
        dir.addShutterSpeed(metadata);
        dir.addRating(metadata);
        CoreDirectory.syncEditableMetadata(metadata);
    }

    public static void syncEditableMetadata(ImageMetadata metadata) {
        CoreDirectory dir = (CoreDirectory)metadata.getDirectoryFor(CoreDirectory.class, true);
        dir.addArtist(metadata);
        dir.addCaption(metadata);
        dir.addCopyright(metadata);
        dir.addTitle(metadata);
    }

    public static void syncImageDimensions(ImageMetadata metadata) {
        CoreDirectory dir = (CoreDirectory)metadata.getDirectoryFor(CoreDirectory.class, true);
        dir.removeValue(514);
        dir.removeValue(513);
        int width = metadata.getImageWidth();
        int height = metadata.getImageHeight();
        if (width > 0 && height > 0) {
            dir.putValue(514, new UnsignedShortMetaValue(width));
            dir.putValue(513, new UnsignedShortMetaValue(height));
        }
    }

    public static void addOriginalOrientation(ImageInfo imageInfo) {
        ImageMetadata metadata = imageInfo.getCurrentMetadata();
        CoreDirectory dir = (CoreDirectory)metadata.getDirectoryFor(CoreDirectory.class, true);
        ImageOrientation orientation = CoreDirectory.getOrientationFrom(metadata);
        dir.putValue(517, new UnsignedShortMetaValue(orientation.getTIFFConstant()));
    }

    @Override
    public float getAperture() {
        ImageMetaValue value = this.getValue(257);
        return value != null ? value.getFloatValue() : 0.0f;
    }

    @Override
    public String getArtist() {
        ImageMetaValue value = this.getValue(768);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public String getCaption() {
        ImageMetaValue value = this.getValue(769);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public Date getCaptureDateTime() {
        ImageMetaValue value = this.getValue(264);
        return value != null ? ((DateMetaValue)value).getDateValue() : null;
    }

    @Override
    public int getColorTemperature() {
        ImageMetaValue value = this.getValue(262);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public String getCopyright() {
        ImageMetaValue value = this.getValue(770);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public Date getFileDateTime() {
        ImageMetaValue value = this.getValue(1);
        return value != null ? ((DateMetaValue)value).getDateValue() : null;
    }

    @Override
    public String getFlash() {
        ImageMetaValue value = this.getValue(265);
        return value != null ? value.toString() : null;
    }

    @Override
    public float getFocalLength() {
        ImageMetaValue value = this.getValue(261);
        return value != null ? value.getFloatValue() : 0.0f;
    }

    @Override
    public int getImageHeight() {
        ImageMetaValue value = this.getValue(513);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public int getImageWidth() {
        ImageMetaValue value = this.getValue(514);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public int getISO() {
        ImageMetaValue value = this.getValue(258);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public String getLens() {
        ImageMetaValue value = this.getValue(260);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public String getCameraMake(boolean includeModel) {
        ImageMetaValue value = this.getValue(263);
        if (value != null) {
            String makeModel = value.getStringValue();
            if (includeModel) {
                return makeModel;
            }
            int space = makeModel.indexOf(32);
            if (space <= 0 || space == makeModel.length() - 1) {
                return makeModel;
            }
            return makeModel.substring(0, space);
        }
        return null;
    }

    @Override
    public String getName() {
        return "Core";
    }

    @Override
    public int getOriginalImageHeight() {
        ImageMetaValue value = this.getValue(519);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public int getOriginalImageWidth() {
        ImageMetaValue value = this.getValue(520);
        return value != null ? value.getIntValue() : 0;
    }

    public String getPath() {
        ImageMetaValue dirValue = this.getValue(2);
        ImageMetaValue fileValue = this.getValue(3);
        return dirValue.getStringValue() + File.separatorChar + fileValue.getStringValue();
    }

    @Override
    public ImageOrientation getOrientation() {
        ImageMetaValue value = this.getValue(516);
        if (value != null) {
            return ImageOrientation.getOrientationFor(value.getIntValue());
        }
        return ImageOrientation.ORIENTATION_UNKNOWN;
    }

    @Override
    public int getRating() {
        ImageMetaValue value = this.getValue(518);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public float getShutterSpeed() {
        ImageMetaValue value = this.getValue(259);
        return value != null ? value.getFloatValue() : 0.0f;
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(Integer id) {
        return m_tagsByID.get(id);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(String name) {
        return m_tagsByName.get(name);
    }

    @Override
    public Collection<Element> toXMP(Document xmpDoc) {
        return this.toXMP(xmpDoc, "http://ns.adobe.com/xap/1.0/", "xap");
    }

    @Override
    public String valueToString(ImageMetaValue value) {
        switch (value.getOwningTagID()) {
            case 257: {
                return TextUtil.tenths(value.getFloatValue());
            }
            case 4: {
                return TextUtil.quantify(value.getLongValue());
            }
            case 261: {
                return TextUtil.tenths(value.getFloatValue()) + "mm";
            }
            case 518: {
                int rating = value.getIntValue();
                if (rating >= 1 && rating <= 5) {
                    return FIVE_STARS.substring(5 - rating);
                }
                if (rating != 0) break;
                return "-";
            }
            case 259: {
                return MetadataUtil.shutterSpeedString(value.getFloatValue());
            }
        }
        return super.valueToString(value);
    }

    @Override
    protected int getProviderPriorityFor(Class<? extends ImageMetadataProvider> provider) {
        return Integer.MAX_VALUE;
    }

    @Override
    protected ResourceBundle getTagLabelBundle() {
        return m_tagBundle;
    }

    @Override
    protected Class<? extends ImageMetaTags> getTagsInterface() {
        return CoreTags.class;
    }

    @Override
    protected Collection<Element> toXMP(Document xmpDoc, String nsURI, String prefix) {
        ArrayList<Element> elements = new ArrayList<Element>(2);
        String lens = this.getOwningMetadata().getLens();
        if (lens != null) {
            Element auxRDFDescElement = XMPUtil.createRDFDescription(xmpDoc, "http://ns.adobe.com/exif/1.0/aux/", "aux");
            Element lensElement = xmpDoc.createElementNS("http://ns.adobe.com/exif/1.0/aux/", "aux:Lens");
            XMLUtil.setTextContentOf(lensElement, lens);
            auxRDFDescElement.appendChild(lensElement);
            elements.add(auxRDFDescElement);
        }
        Element xapRDFDescElement = XMPUtil.createRDFDescription(xmpDoc, "http://ns.adobe.com/xap/1.0/", "xap");
        DateMetaValue captureDateValue = (DateMetaValue)this.getValue(264);
        if (captureDateValue != null) {
            Element createDateElement = xmpDoc.createElementNS("http://ns.adobe.com/xap/1.0/", "xap:CreateDate");
            XMLUtil.setTextContentOf(createDateElement, TextUtil.dateFormat(XMPConstants.ISO_8601_DATE_FORMAT, captureDateValue.getDateValue()));
            xapRDFDescElement.appendChild(createDateElement);
        }
        Element creatorToolElement = xmpDoc.createElementNS("http://ns.adobe.com/xap/1.0/", "xap:CreatorTool");
        XMLUtil.setTextContentOf(creatorToolElement, Version.getApplicationName() + ' ' + Version.getVersionName());
        xapRDFDescElement.appendChild(creatorToolElement);
        Date now = new Date();
        Element metadataDateElement = xmpDoc.createElementNS("http://ns.adobe.com/xap/1.0/", "xap:MetadataDate");
        XMLUtil.setTextContentOf(metadataDateElement, TextUtil.dateFormat(XMPConstants.ISO_8601_DATE_FORMAT, now));
        xapRDFDescElement.appendChild(metadataDateElement);
        Element modifyDateElement = xmpDoc.createElementNS("http://ns.adobe.com/xap/1.0/", "xap:ModifyDate");
        XMLUtil.setTextContentOf(modifyDateElement, TextUtil.dateFormat(XMPConstants.ISO_8601_DATE_FORMAT, now));
        xapRDFDescElement.appendChild(modifyDateElement);
        ImageMetaValue rating = this.getValue(518);
        if (rating != null) {
            Element ratingElement = xmpDoc.createElementNS("http://ns.adobe.com/xap/1.0/", "xap:Rating");
            XMLUtil.setTextContentOf(ratingElement, rating.getStringValue());
            xapRDFDescElement.appendChild(ratingElement);
        }
        elements.add(xapRDFDescElement);
        return elements;
    }

    private static void add(int id, String name, ImageMetaType type, boolean isChangeable) {
        ImageMetaTagInfo tagInfo = new ImageMetaTagInfo(id, name, type, isChangeable);
        m_tagsByID.put(id, tagInfo);
        m_tagsByName.put(name, tagInfo);
    }

    private void addAperture(ImageMetadata metadata) {
        this.removeValue(257);
        float aperture = metadata.getAperture();
        if (aperture > 0.0f) {
            this.putValue(257, new FloatMetaValue(aperture));
        }
    }

    private void addArtist(ImageMetadata metadata) {
        this.removeValue(768);
        String artist = metadata.getArtist();
        if (artist != null) {
            this.putValue(768, new StringMetaValue(artist));
        }
    }

    private void addCamera(ImageInfo imageInfo) {
        this.removeValue(263);
        ImageMetadata metadata = imageInfo.getCurrentMetadata();
        String camera = metadata.getCameraMake(true);
        if (camera == null) {
            AuxiliaryImageInfo auxInfo;
            try {
                auxInfo = imageInfo.getAuxiliaryInfo();
            }
            catch (Exception e) {
                return;
            }
            if (auxInfo instanceof RawImageInfo) {
                DCRaw dcRaw = ((RawImageInfo)auxInfo).getDCRaw();
                camera = dcRaw.getCameraMake(true);
            }
        }
        if (camera != null) {
            this.putValue(263, new StringMetaValue(camera));
        }
    }

    private void addCaption(ImageMetadata metadata) {
        this.removeValue(769);
        String caption = metadata.getCaption();
        if (caption != null) {
            this.putValue(769, new StringMetaValue(caption));
        }
    }

    private void addCaptureDateTime(ImageInfo imageInfo) {
        this.removeValue(264);
        Date date = imageInfo.getCurrentMetadata().getCaptureDateTime();
        if (date != null) {
            this.putValue(264, new DateMetaValue(date));
        }
    }

    private void addColorProfile(ImageInfo imageInfo) {
        this.removeValue(512);
        try {
            ICC_Profile profile = imageInfo.getImageType().getICCProfile(imageInfo);
            if (profile == null) {
                return;
            }
            String name = ColorProfileInfo.getNameOf(profile);
            if (name != null) {
                this.putValue(512, new StringMetaValue(name));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addColorTemperature(ImageMetadata metadata) {
        this.removeValue(262);
        int temp = metadata.getColorTemperature();
        if (temp > 0) {
            this.putValue(262, new UnsignedShortMetaValue(temp));
        }
    }

    private void addCopyright(ImageMetadata metadata) {
        this.removeValue(770);
        String copyright = metadata.getCopyright();
        if (copyright != null) {
            this.putValue(770, new StringMetaValue(copyright));
        }
    }

    private void addFileInfo(ImageInfo imageInfo) {
        File file = imageInfo.getFile().getAbsoluteFile();
        String parentDir = file.getParent();
        if (parentDir == null) {
            parentDir = System.getProperty("user.dir");
        }
        this.putValue(2, new StringMetaValue(parentDir));
        this.putValue(3, new StringMetaValue(file.getName()));
        this.putValue(4, new UnsignedLongMetaValue(file.length()));
        Date date = new Date(file.lastModified());
        this.putValue(1, new DateMetaValue(date));
        this.removeValue(519);
        this.removeValue(520);
        try {
            File origImageFile = imageInfo.getOriginalFile();
            if (origImageFile != null) {
                ImageInfo origInfo = ImageInfo.getInstanceFor(origImageFile);
                ImageMetadata origMetadata = origInfo.getMetadata();
                this.putValue(519, new UnsignedShortMetaValue(origMetadata.getImageHeight()));
                this.putValue(520, new UnsignedShortMetaValue(origMetadata.getImageWidth()));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void addFlash(ImageMetadata metadata) {
        this.removeValue(265);
        String flash = metadata.getFlash();
        if (flash != null) {
            this.putValue(265, new StringMetaValue(flash));
        }
    }

    private void addFocalLength(ImageMetadata metadata) {
        this.removeValue(261);
        float focalLength = metadata.getFocalLength();
        if (focalLength != 0.0f) {
            this.putValue(261, new FloatMetaValue(focalLength));
        }
    }

    private void addImageDimensions(ImageInfo imageInfo) {
        this.removeValue(514);
        this.removeValue(513);
        ImageMetadata metadata = imageInfo.getCurrentMetadata();
        int width = metadata.getImageWidth();
        int height = metadata.getImageHeight();
        if (width == 0 || height == 0) {
            try {
                ImageType t = imageInfo.getImageType();
                Dimension d = t.getDimension(imageInfo);
                if (d != null) {
                    width = d.width;
                    height = d.height;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (width > 0 && height > 0) {
            this.putValue(514, new UnsignedShortMetaValue(width));
            this.putValue(513, new UnsignedShortMetaValue(height));
        }
    }

    private void addISO(ImageMetadata metadata) {
        this.removeValue(258);
        int iso = metadata.getISO();
        if (iso > 0) {
            this.putValue(258, new UnsignedShortMetaValue(iso));
        }
    }

    private void addLens(ImageMetadata metadata) {
        String lens = metadata.getLens();
        if (lens != null) {
            this.putValue(260, new StringMetaValue(lens));
        }
    }

    private void addOrientation(ImageMetadata metadata) {
        this.removeValue(516);
        ImageOrientation orientation = CoreDirectory.getOrientationFrom(metadata);
        this.putValue(516, new UnsignedShortMetaValue(orientation.getTIFFConstant()));
    }

    private void addRating(ImageMetadata metadata) {
        int rating = metadata.getRating();
        if (rating > 0) {
            this.putValue(518, new UnsignedShortMetaValue(rating));
        }
    }

    private void addResolution(ImageMetadata metadata) {
        String unitString;
        this.removeValue(515);
        double res = metadata.getResolution();
        if (res == 0.0) {
            return;
        }
        switch (metadata.getResolutionUnit()) {
            case 3: {
                unitString = "cm";
                break;
            }
            case 2: {
                unitString = "inch";
                break;
            }
            default: {
                return;
            }
        }
        StringMetaValue value = new StringMetaValue(TextUtil.tenths(res) + " pixels/" + unitString);
        this.putValue(515, value);
    }

    private void addShutterSpeed(ImageMetadata metadata) {
        this.removeValue(259);
        float value = metadata.getShutterSpeed();
        if (value > 0.0f) {
            this.putValue(259, new FloatMetaValue(value));
        }
    }

    private void addTitle(ImageMetadata metadata) {
        this.removeValue(771);
        String value = metadata.getTitle();
        if (value != null) {
            this.putValue(771, new StringMetaValue(value));
        }
    }

    private static ImageOrientation getOrientationFrom(ImageMetadata metadata) {
        ImageOrientation orientation = metadata.getOrientation();
        if (orientation == ImageOrientation.ORIENTATION_UNKNOWN) {
            return ImageOrientation.ORIENTATION_LANDSCAPE;
        }
        return orientation;
    }

    static {
        CoreDirectory.add(257, "Aperture", ImageMetaType.META_FLOAT, false);
        CoreDirectory.add(768, "Artist", ImageMetaType.META_STRING, true);
        CoreDirectory.add(263, "Camera", ImageMetaType.META_STRING, false);
        CoreDirectory.add(769, "Caption", ImageMetaType.META_STRING, true);
        CoreDirectory.add(264, "CaptureDateTime", ImageMetaType.META_DATE, false);
        CoreDirectory.add(512, "ColorProfile", ImageMetaType.META_STRING, false);
        CoreDirectory.add(262, "ColorTemperature", ImageMetaType.META_USHORT, false);
        CoreDirectory.add(770, "Copyright", ImageMetaType.META_STRING, true);
        CoreDirectory.add(2, "DirName", ImageMetaType.META_STRING, false);
        CoreDirectory.add(1, "FileDateTime", ImageMetaType.META_DATE, false);
        CoreDirectory.add(3, "FileName", ImageMetaType.META_STRING, false);
        CoreDirectory.add(4, "FileSize", ImageMetaType.META_ULONG, false);
        CoreDirectory.add(261, "FocalLength", ImageMetaType.META_FLOAT, false);
        CoreDirectory.add(513, "ImageHeight", ImageMetaType.META_USHORT, false);
        CoreDirectory.add(516, "ImageOrientation", ImageMetaType.META_USHORT, true);
        CoreDirectory.add(515, "ImageResolution", ImageMetaType.META_STRING, false);
        CoreDirectory.add(514, "ImageWidth", ImageMetaType.META_USHORT, false);
        CoreDirectory.add(258, "ISO", ImageMetaType.META_USHORT, false);
        CoreDirectory.add(260, "Lens", ImageMetaType.META_STRING, false);
        CoreDirectory.add(517, "OriginalOrientation", ImageMetaType.META_USHORT, false);
        CoreDirectory.add(518, "Rating", ImageMetaType.META_USHORT, true);
        CoreDirectory.add(259, "ShutterSpeed", ImageMetaType.META_FLOAT, false);
    }
}

