/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.metadata.EXIFTags;
import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.ImageOrientation;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.providers.ApertureProvider;
import com.lightcrafts.image.metadata.providers.ArtistProvider;
import com.lightcrafts.image.metadata.providers.BitsPerChannelProvider;
import com.lightcrafts.image.metadata.providers.CaptionProvider;
import com.lightcrafts.image.metadata.providers.CaptureDateTimeProvider;
import com.lightcrafts.image.metadata.providers.CopyrightProvider;
import com.lightcrafts.image.metadata.providers.FlashProvider;
import com.lightcrafts.image.metadata.providers.FocalLengthProvider;
import com.lightcrafts.image.metadata.providers.ISOProvider;
import com.lightcrafts.image.metadata.providers.MakeModelProvider;
import com.lightcrafts.image.metadata.providers.OrientationProvider;
import com.lightcrafts.image.metadata.providers.RatingProvider;
import com.lightcrafts.image.metadata.providers.ResolutionProvider;
import com.lightcrafts.image.metadata.providers.ShutterSpeedProvider;
import com.lightcrafts.image.metadata.providers.WidthHeightProvider;
import com.lightcrafts.image.metadata.values.DateMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.RationalMetaValue;
import com.lightcrafts.utils.TextUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EXIFDirectory
extends ImageMetadataDirectory
implements ApertureProvider,
ArtistProvider,
BitsPerChannelProvider,
CaptionProvider,
CaptureDateTimeProvider,
CopyrightProvider,
FlashProvider,
FocalLengthProvider,
ISOProvider,
MakeModelProvider,
OrientationProvider,
RatingProvider,
ResolutionProvider,
ShutterSpeedProvider,
WidthHeightProvider {
    public static final byte[] EXIF_VERSION = new byte[]{48, 50, 50, 48};
    private static final ResourceBundle m_tagBundle = ResourceBundle.getBundle("com.lightcrafts.image.metadata.EXIFTags");
    private static final Map<Integer, ImageMetaTagInfo> m_tagsByID = new HashMap<Integer, ImageMetaTagInfo>();
    private static final Map<String, ImageMetaTagInfo> m_tagsByName = new HashMap<String, ImageMetaTagInfo>();

    public static float calcShutterSpeedFromAPEX(ImageMetaValue value) {
        double apex = value.getDoubleValue();
        return (float)(1.0 / Math.exp(apex * Math.log(2.0)));
    }

    @Override
    public float getAperture() {
        ImageMetaValue value = this.getValue(33437);
        if (value == null) {
            value = this.getValue(37378);
        }
        if (!(value instanceof RationalMetaValue)) {
            return 0.0f;
        }
        return MetadataUtil.fixFStop(value.getFloatValue());
    }

    @Override
    public String getArtist() {
        ImageMetaValue value = this.getValue(315);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public int getBitsPerChannel() {
        ImageMetaValue value = this.getValue(258);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public String getCameraMake(boolean includeModel) {
        return this.getCameraMake(271, 272, includeModel);
    }

    @Override
    public String getCaption() {
        ImageMetaValue value = this.getValue(270);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public Date getCaptureDateTime() {
        ImageMetaValue value = this.getValue(36867);
        if (value == null) {
            value = this.getValue(36868);
        }
        return value instanceof DateMetaValue ? ((DateMetaValue)value).getDateValue() : null;
    }

    @Override
    public String getCopyright() {
        ImageMetaValue value = this.getValue(33432);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public String getFlash() {
        ImageMetaValue flashValue = this.getValue(37385);
        return EXIFDirectory.hasTagValueLabelFor(flashValue);
    }

    @Override
    public float getFocalLength() {
        ImageMetaValue value = this.getValue(37386);
        return value != null ? value.getFloatValue() : 0.0f;
    }

    @Override
    public int getImageHeight() {
        return MetadataUtil.maxTagValue(this, 257, 40963);
    }

    @Override
    public int getImageWidth() {
        return MetadataUtil.maxTagValue(this, 256, 40962);
    }

    @Override
    public int getISO() {
        ImageMetaValue value = this.getValue(34855);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public String getName() {
        return "EXIF";
    }

    @Override
    public ImageOrientation getOrientation() {
        ImageMetaValue value = this.getValue(274);
        if (value != null) {
            try {
                return ImageOrientation.getOrientationFor(value.getIntValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return ImageOrientation.ORIENTATION_UNKNOWN;
    }

    @Override
    public int getRating() {
        ImageMetaValue rating = this.getValue(18246);
        return rating != null ? rating.getIntValue() : 0;
    }

    @Override
    public double getResolution() {
        ImageMetaValue res = this.getValue(282);
        return res != null ? res.getDoubleValue() : 0.0;
    }

    @Override
    public int getResolutionUnit() {
        ImageMetaValue unit = this.getValue(296);
        if (unit != null) {
            switch (unit.getIntValue()) {
                case 3: {
                    return 3;
                }
                case 2: {
                    return 2;
                }
            }
        }
        return 1;
    }

    @Override
    public float getShutterSpeed() {
        boolean isAPEX = false;
        ImageMetaValue value = this.getValue(33434);
        if (value == null) {
            value = this.getValue(37377);
            isAPEX = true;
        }
        if (!(value instanceof RationalMetaValue)) {
            return 0.0f;
        }
        if (isAPEX) {
            return EXIFDirectory.calcShutterSpeedFromAPEX(value);
        }
        return value.getFloatValue();
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(Integer id) {
        return m_tagsByID.get(id);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(String name) {
        return m_tagsByName.get(name);
    }

    @Override
    public Collection<Element> toXMP(Document xmpDoc) {
        return this.toXMP(xmpDoc, "http://ns.adobe.com/exif/1.0/", "exif");
    }

    @Override
    public String valueToString(ImageMetaValue value) {
        switch (value.getOwningTagID()) {
            case 33437: 
            case 37378: {
                if (!(value instanceof RationalMetaValue)) break;
                double fStop = value.getDoubleValue();
                return Float.toString(MetadataUtil.fixFStop(fStop));
            }
            case 37380: {
                if (!value.isNumeric()) break;
                return MetadataUtil.convertBiasFromAPEX(value.getFloatValue());
            }
            case 33434: {
                if (!value.isNumeric()) break;
                return MetadataUtil.shutterSpeedString(value.getFloatValue());
            }
            case 37386: {
                if (!value.isNumeric()) break;
                double n = value.getDoubleValue();
                return TextUtil.tenths(n) + "mm";
            }
            case 41989: {
                if (!value.isNumeric()) break;
                int n = value.getIntValue();
                switch (n) {
                    case 0: {
                        return "unknown";
                    }
                }
                return n + "mm";
            }
            case 37377: {
                if (!(value instanceof RationalMetaValue)) break;
                double speed = EXIFDirectory.calcShutterSpeedFromAPEX(value);
                return MetadataUtil.shutterSpeedString(speed);
            }
        }
        return super.valueToString(value);
    }

    @Override
    protected ResourceBundle getTagLabelBundle() {
        return m_tagBundle;
    }

    @Override
    protected Class<? extends ImageMetaTags> getTagsInterface() {
        return EXIFTags.class;
    }

    private static void add(int id, String name, ImageMetaType type, boolean isChangeable) {
        ImageMetaTagInfo tagInfo = new ImageMetaTagInfo(id, name, type, isChangeable);
        m_tagsByID.put(id, tagInfo);
        m_tagsByName.put(name, tagInfo);
    }

    static {
        EXIFDirectory.add(37378, "ApertureValue", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(315, "Artist", ImageMetaType.META_STRING, true);
        EXIFDirectory.add(258, "BitsPerSample", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(37379, "BrightnessValue", ImageMetaType.META_SRATIONAL, false);
        EXIFDirectory.add(41730, "CFAPattern", ImageMetaType.META_UNDEFINED, false);
        EXIFDirectory.add(33422, "CFAPattern2", ImageMetaType.META_UNDEFINED, false);
        EXIFDirectory.add(40961, "ColorSpace", ImageMetaType.META_SSHORT, false);
        EXIFDirectory.add(37121, "ComponentsConfiguration", ImageMetaType.META_UNDEFINED, false);
        EXIFDirectory.add(37122, "CompressedBitsPerPixel", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(259, "Compression", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(41992, "Contrast", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(33432, "Copyright", ImageMetaType.META_STRING, true);
        EXIFDirectory.add(41985, "CustomRendered", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(306, "DateTime", ImageMetaType.META_DATE, false);
        EXIFDirectory.add(36868, "DateTimeDigitized", ImageMetaType.META_DATE, false);
        EXIFDirectory.add(36867, "DateTimeOriginal", ImageMetaType.META_DATE, false);
        EXIFDirectory.add(41995, "DeviceSettingDescription", ImageMetaType.META_UNDEFINED, false);
        EXIFDirectory.add(41988, "DigitalZoomRatio", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(269, "DocumentName", ImageMetaType.META_STRING, true);
        EXIFDirectory.add(36864, "ExifVersion", ImageMetaType.META_UNDEFINED, false);
        EXIFDirectory.add(37380, "ExposureBiasValue", ImageMetaType.META_SRATIONAL, false);
        EXIFDirectory.add(41493, "ExposureIndex", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(37397, "ExposureIndex2", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(41986, "ExposureMode", ImageMetaType.META_SSHORT, false);
        EXIFDirectory.add(34850, "ExposureProgram", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(33434, "ExposureTime", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(41728, "FileSource", ImageMetaType.META_UNDEFINED, false);
        EXIFDirectory.add(37385, "Flash", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(41483, "FlashEnergy", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(40960, "FlashpixVersion", ImageMetaType.META_UNDEFINED, false);
        EXIFDirectory.add(33437, "FNumber", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(37386, "FocalLength", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(41989, "FocalLengthIn_35mmFilm", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(41488, "FocalPlaneResolutionUnit", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(41486, "FocalPlaneXResolution", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(41487, "FocalPlaneYResolution", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(41991, "GainControl", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(34853, "GPSInfoIfdPointer", ImageMetaType.META_ULONG, false);
        EXIFDirectory.add(316, "HostComputer", ImageMetaType.META_STRING, false);
        EXIFDirectory.add(34675, "ICCProfile", ImageMetaType.META_UNDEFINED, false);
        EXIFDirectory.add(34665, "ExifIFDPointer", ImageMetaType.META_ULONG, false);
        EXIFDirectory.add(270, "ImageDescription", ImageMetaType.META_STRING, true);
        EXIFDirectory.add(257, "ImageHeight", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(256, "ImageWidth", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(40965, "InteroperabilityPointer", ImageMetaType.META_ULONG, false);
        EXIFDirectory.add(34855, "ISOSpeedRatings", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(513, "JPEGInterchangeFormat", ImageMetaType.META_ULONG, false);
        EXIFDirectory.add(514, "JPEGInterchangeFormatLength", ImageMetaType.META_ULONG, false);
        EXIFDirectory.add(37384, "LightSource", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(271, "Make", ImageMetaType.META_STRING, false);
        EXIFDirectory.add(37500, "MakerNote", ImageMetaType.META_UNDEFINED, false);
        EXIFDirectory.add(37381, "MaxApertureValue", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(37383, "MeteringMode", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(272, "Model", ImageMetaType.META_STRING, false);
        EXIFDirectory.add(18246, "MSRating", ImageMetaType.META_USHORT, true);
        EXIFDirectory.add(254, "NewSubfileType", ImageMetaType.META_ULONG, false);
        EXIFDirectory.add(34856, "OECF", ImageMetaType.META_UNDEFINED, false);
        EXIFDirectory.add(34857, "OECF2", ImageMetaType.META_UNDEFINED, false);
        EXIFDirectory.add(274, "Orientation", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(262, "PhotometricInterpretation", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(40962, "PixelXDimension", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(40963, "PixelYDimension", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(284, "PlanarConfiguration", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(317, "Predictor", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(319, "PrimaryChromaticities", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(532, "ReferenceBlackWhite", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(40964, "RelatedSoundFile", ImageMetaType.META_STRING, false);
        EXIFDirectory.add(296, "ResolutionUnit", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(278, "RowsPerStrip", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(277, "SamplesPerPixel", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(41993, "Saturation", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(41990, "SceneCaptureType", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(41729, "SceneType", ImageMetaType.META_UNDEFINED, false);
        EXIFDirectory.add(41495, "SensingMethod", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(41994, "Sharpness", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(37377, "ShutterSpeedValue", ImageMetaType.META_SRATIONAL, false);
        EXIFDirectory.add(305, "Software", ImageMetaType.META_STRING, false);
        EXIFDirectory.add(41484, "SpatialFrequencyResponse", ImageMetaType.META_UNDEFINED, false);
        EXIFDirectory.add(34852, "SpectralSensitivity", ImageMetaType.META_STRING, false);
        EXIFDirectory.add(279, "StripByteCounts", ImageMetaType.META_SSHORT, false);
        EXIFDirectory.add(273, "StripOffsets", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(255, "SubfileType", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(330, "SubIFDS", ImageMetaType.META_ULONG, false);
        EXIFDirectory.add(37396, "SubjectArea", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(37382, "SubjectDistance", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(41996, "SubjectDistanceRange", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(41492, "SubjectLocation", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(37520, "SubsecTime", ImageMetaType.META_STRING, false);
        EXIFDirectory.add(37522, "SubsecTimeDigitized", ImageMetaType.META_STRING, false);
        EXIFDirectory.add(37521, "SubsecTimeOriginal", ImageMetaType.META_STRING, false);
        EXIFDirectory.add(325, "TileByteCounts", ImageMetaType.META_SSHORT, false);
        EXIFDirectory.add(323, "TileLength", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(324, "TileOffsets", ImageMetaType.META_ULONG, false);
        EXIFDirectory.add(301, "TransferFunction", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(37510, "UserComment", ImageMetaType.META_UNDEFINED, false);
        EXIFDirectory.add(41987, "WhiteBalance", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(318, "WhitePoint", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(282, "XResolution", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(529, "YCbCrCoefficients", ImageMetaType.META_URATIONAL, false);
        EXIFDirectory.add(531, "YCbCrPositioning", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(530, "YCbCrSubSampling", ImageMetaType.META_USHORT, false);
        EXIFDirectory.add(283, "YResolution", ImageMetaType.META_URATIONAL, false);
    }
}

