/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

public enum ImageMetaType {
    META_DOUBLE(12){

        @Override
        public boolean isCompatibleWith(ImageMetaType t) {
            return t.isFloatingPointType();
        }
    }
    ,
    META_FLOAT(11){

        @Override
        public boolean isCompatibleWith(ImageMetaType t) {
            return t.isFloatingPointType();
        }
    }
    ,
    META_IFD(13){

        @Override
        public boolean isCompatibleWith(ImageMetaType t) {
            switch (t) {
                case META_IFD: 
                case META_ULONG: {
                    return true;
                }
            }
            return false;
        }
    }
    ,
    META_SBYTE(6){

        @Override
        public boolean isCompatibleWith(ImageMetaType t) {
            return t.isIntegerType();
        }
    }
    ,
    META_SLONG(9){

        @Override
        public boolean isCompatibleWith(ImageMetaType t) {
            return t.isIntegerType();
        }
    }
    ,
    META_SRATIONAL(10){

        @Override
        public boolean isCompatibleWith(ImageMetaType t) {
            return t.isRationalType();
        }
    }
    ,
    META_SSHORT(8){

        @Override
        public boolean isCompatibleWith(ImageMetaType t) {
            return t.isIntegerType();
        }
    }
    ,
    META_STRING(2),
    META_UBYTE(1){

        @Override
        public boolean isCompatibleWith(ImageMetaType t) {
            return t.isIntegerType() || t == META_UNDEFINED;
        }
    }
    ,
    META_UNDEFINED(7){

        @Override
        public boolean isCompatibleWith(ImageMetaType t) {
            return t == META_UNDEFINED || t == META_UBYTE;
        }
    }
    ,
    META_UNKNOWN(-2),
    META_ULONG(4){

        @Override
        public boolean isCompatibleWith(ImageMetaType t) {
            return t.isIntegerType() || t == META_IFD;
        }
    }
    ,
    META_URATIONAL(5){

        @Override
        public boolean isCompatibleWith(ImageMetaType t) {
            return t.isRationalType();
        }
    }
    ,
    META_USHORT(3){

        @Override
        public boolean isCompatibleWith(ImageMetaType t) {
            return t.isIntegerType();
        }
    }
    ,
    META_DATE(-1);

    private final byte m_tiffConstant;

    public static ImageMetaType getTypeFor(int tiffConstant) {
        switch (tiffConstant) {
            case 2: {
                return META_STRING;
            }
            case 12: {
                return META_DOUBLE;
            }
            case 11: {
                return META_FLOAT;
            }
            case 13: {
                return META_IFD;
            }
            case 6: {
                return META_SBYTE;
            }
            case 9: {
                return META_SLONG;
            }
            case 10: {
                return META_SRATIONAL;
            }
            case 8: {
                return META_SSHORT;
            }
            case 1: {
                return META_UBYTE;
            }
            case 4: {
                return META_ULONG;
            }
            case 7: {
                return META_UNDEFINED;
            }
            case 5: {
                return META_URATIONAL;
            }
            case 3: {
                return META_USHORT;
            }
            case -1: {
                return META_DATE;
            }
        }
        throw new IllegalArgumentException();
    }

    public final byte getTIFFConstant() {
        return this.m_tiffConstant;
    }

    public boolean isCompatibleWith(ImageMetaType t) {
        return t == this;
    }

    public final boolean isDateType() {
        return this == META_DATE;
    }

    public final boolean isFloatingPointType() {
        switch (this) {
            case META_DOUBLE: 
            case META_FLOAT: {
                return true;
            }
        }
        return false;
    }

    public final boolean isIntegerType() {
        switch (this) {
            case META_ULONG: 
            case META_SBYTE: 
            case META_SLONG: 
            case META_SSHORT: 
            case META_UBYTE: 
            case META_USHORT: {
                return true;
            }
        }
        return false;
    }

    public final boolean isNumericType() {
        return this.isFloatingPointType() || this.isIntegerType() || this.isRationalType();
    }

    public final boolean isRationalType() {
        switch (this) {
            case META_SRATIONAL: 
            case META_URATIONAL: {
                return true;
            }
        }
        return false;
    }

    public final boolean isStringType() {
        return this == META_STRING;
    }

    private ImageMetaType(byte tiffConstant) {
        this.m_tiffConstant = tiffConstant;
    }
}

