/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.metadata.CoreDirectory;
import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.XMPUtil;
import com.lightcrafts.image.metadata.providers.ImageMetadataProvider;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.LongMetaValue;
import com.lightcrafts.image.metadata.values.RationalMetaValue;
import com.lightcrafts.image.metadata.values.ShortMetaValue;
import com.lightcrafts.image.metadata.values.StringMetaValue;
import com.lightcrafts.image.metadata.values.UndefinedMetaValue;
import com.lightcrafts.utils.Rational;
import com.lightcrafts.utils.TextUtil;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import com.lightcrafts.utils.xml.ElementPrefixFilter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ImageMetadataDirectory
implements Cloneable,
Externalizable {
    private ImageMetadata m_owningMetadata;
    private final HashMap<Integer, ImageMetaValue> m_tagIDToValueMap = new HashMap();

    public synchronized void clear() {
        this.m_tagIDToValueMap.clear();
    }

    public synchronized void clearEdited() {
        for (ImageMetaValue value : this.m_tagIDToValueMap.values()) {
            value.clearEdited();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ImageMetadataDirectory clone() {
        ImageMetadataDirectory copy;
        try {
            copy = (ImageMetadataDirectory)this.getClass().newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        copy.setOwningMetadata(this.m_owningMetadata);
        ImageMetadataDirectory imageMetadataDirectory = this;
        synchronized (imageMetadataDirectory) {
            copy.m_tagIDToValueMap.putAll(this.m_tagIDToValueMap);
        }
        return copy;
    }

    public int[] getMakerNotesAdjustments(LCByteBuffer buf, int offset) throws IOException {
        return null;
    }

    public abstract String getName();

    public final ImageMetadata getOwningMetadata() {
        return this.m_owningMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<Integer> getTagIDSet(boolean all) {
        Field[] fields;
        if (!all) {
            ImageMetadataDirectory imageMetadataDirectory = this;
            synchronized (imageMetadataDirectory) {
                return this.m_tagIDToValueMap.keySet();
            }
        }
        Class<? extends ImageMetaTags> tagsInterface = this.getTagsInterface();
        if (tagsInterface == null) {
            return new HashSet<Integer>();
        }
        assert (tagsInterface.isInterface());
        HashSet<Integer> tagSet = new HashSet<Integer>();
        for (Field field : fields = tagsInterface.getFields()) {
            try {
                if (!field.getType().equals(Integer.TYPE)) continue;
                tagSet.add(field.getInt(null));
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return tagSet;
    }

    public abstract ImageMetaTagInfo getTagInfoFor(Integer var1);

    public abstract ImageMetaTagInfo getTagInfoFor(String var1);

    public final String getTagLabelFor(int tagID) {
        return this.getTagLabelFor(tagID, true);
    }

    public final String getTagLabelFor(int tagID, boolean returnHexKey) {
        String key = TextUtil.zeroPad(tagID, 16, 4);
        try {
            return this.getTagLabelBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return returnHexKey ? key : null;
        }
    }

    public final String getTagNameFor(int tagID) {
        return this.getTagNameFor(tagID, true);
    }

    public final String getTagNameFor(int tagID, boolean returnHexKey) {
        ImageMetaTagInfo tagInfo = this.getTagInfoFor(tagID);
        if (tagInfo != null) {
            return tagInfo.getName();
        }
        return returnHexKey ? TextUtil.zeroPad(tagID, 16, 4) : null;
    }

    public final String getTagValueLabelFor(int tagID, long value) {
        return this.getTagValueLabelFor(tagID, Long.toString(value));
    }

    public final String getTagValueLabelFor(int tagID, String value) {
        String key = TextUtil.zeroPad(tagID, 16, 4) + '>' + value;
        try {
            return this.getTagLabelBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return value;
        }
    }

    public final Collection<String> getTagValuesFor(int tagID, boolean includeLabels) {
        String keyPrefix = TextUtil.zeroPad(tagID, 16, 4) + '>';
        HashSet<String> values = null;
        Enumeration<String> keys = this.getTagLabelBundle().getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.startsWith(keyPrefix)) continue;
            if (values == null) {
                values = new HashSet<String>();
            }
            int separatorPos = key.indexOf(62);
            String value = key.substring(separatorPos + 1);
            if (includeLabels) {
                value = value + '=' + this.getTagValueLabelFor(tagID, value);
            }
            values.add(value);
        }
        return values;
    }

    public final synchronized ImageMetaValue getValue(Integer tagID) {
        for (ImageMetadataDirectory dir = this; dir != null; dir = dir.getStaticParent()) {
            ImageMetaValue value = dir.m_tagIDToValueMap.get(tagID);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public final String hasTagValueLabelFor(int tagID) {
        ImageMetaValue value = this.getValue(tagID);
        if (value == null) {
            return null;
        }
        String key = TextUtil.zeroPad(tagID, 16, 4) + '>' + value.getStringValue();
        try {
            return this.getTagLabelBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public final String hasTagValueLabelFor(int tagID, int value) {
        String valueString = Integer.toString(value);
        String key = TextUtil.zeroPad(tagID, 16, 4) + '>' + valueString;
        try {
            return this.getTagLabelBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    protected static String hasTagValueLabelFor(ImageMetaValue value) {
        if (value != null) {
            return ImageMetadataDirectory.hasTagValueLabelFor(value.getOwningTagID(), value);
        }
        return null;
    }

    protected static String hasTagValueLabelFor(int tagID, ImageMetaValue value) {
        if (value != null) {
            ImageMetadataDirectory dir = value.getOwningDirectory();
            return dir.hasTagValueLabelFor(tagID, value.getIntValue());
        }
        return null;
    }

    public final synchronized boolean isChanged() {
        for (ImageMetaValue value : this.m_tagIDToValueMap.values()) {
            if (!value.isEdited()) continue;
            return true;
        }
        return false;
    }

    public final synchronized boolean isEmpty() {
        return this.m_tagIDToValueMap.isEmpty();
    }

    public boolean isLegalValue(Integer tagID, String value) {
        ImageMetaTagInfo tag = this.getTagInfoFor(tagID);
        if (tag == null) {
            throw new IllegalArgumentException("unknown tag " + tagID);
        }
        if (value == null || value.length() == 0) {
            return true;
        }
        return tag.createValue().isLegalValue(value);
    }

    public final synchronized Iterator<Map.Entry<Integer, ImageMetaValue>> iterator() {
        return this.m_tagIDToValueMap.entrySet().iterator();
    }

    public void mergeFrom(ImageMetadataDirectory fromDir) {
        Iterator<Map.Entry<Integer, ImageMetaValue>> i = fromDir.iterator();
        while (i.hasNext()) {
            Map.Entry<Integer, ImageMetaValue> me = i.next();
            this.putValue(me.getKey(), me.getValue());
        }
    }

    public boolean parseXMP(ImageMetaTagInfo tagInfo, Element element, ElementPrefixFilter dirPrefixFilter) {
        return false;
    }

    public void putValue(Integer tagID, ImageMetaValue value) {
        this.putValue(tagID, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putValue(Integer tagID, ImageMetaValue value, boolean setOwner) {
        StringMetaValue stringValue;
        String s;
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (value.getValueCount() == 0) {
            throw new IllegalArgumentException("value has 0 values");
        }
        if (value instanceof StringMetaValue && (s = (stringValue = (StringMetaValue)value).getStringValue()) == null) {
            this.removeValue(tagID);
            return;
        }
        ImageMetaTagInfo tag = this.getTagInfoFor(tagID);
        if (tag != null) {
            value.setIsChangeable(tag.isChangeable());
        }
        if (setOwner) {
            value.setOwningDirectory(this);
            value.setOwningTagID(tagID);
        }
        ImageMetadataDirectory imageMetadataDirectory = this;
        synchronized (imageMetadataDirectory) {
            this.m_tagIDToValueMap.put(tagID, value);
        }
    }

    public final void removeAllEmptyStringValues() {
        Iterator<Map.Entry<Integer, ImageMetaValue>> i = this.iterator();
        while (i.hasNext()) {
            String s;
            Map.Entry<Integer, ImageMetaValue> e = i.next();
            ImageMetaValue value = e.getValue();
            if (!(value instanceof StringMetaValue) || (s = value.getStringValue()) != null && s.length() != 0) continue;
            i.remove();
        }
    }

    public final synchronized ImageMetaValue removeValue(Integer tagID) {
        for (ImageMetadataDirectory dir = this; dir != null; dir = dir.getStaticParent()) {
            ImageMetaValue value = dir.m_tagIDToValueMap.remove(tagID);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setValue(Integer tagID, int newValue) {
        ImageMetaTagInfo tag = this.getTagInfoFor(tagID);
        if (tag == null) {
            throw new IllegalArgumentException("unknown tag " + tagID);
        }
        ImageMetadataDirectory imageMetadataDirectory = this;
        synchronized (imageMetadataDirectory) {
            ImageMetaValue value = this.m_tagIDToValueMap.get(tagID);
            if (value == null) {
                value = tag.createValue();
                value.setOwningDirectory(this);
                value.setIntValue(newValue);
                this.putValue(tagID, value);
            } else {
                value.setIntValue(newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setValue(Integer tagID, String ... newValues) {
        ImageMetaTagInfo tag = this.getTagInfoFor(tagID);
        if (tag == null) {
            throw new IllegalArgumentException("unknown tag " + tagID);
        }
        ImageMetadataDirectory imageMetadataDirectory = this;
        synchronized (imageMetadataDirectory) {
            ImageMetaValue value = this.m_tagIDToValueMap.get(tagID);
            if (value == null) {
                value = tag.createValue();
                value.setOwningDirectory(this);
                value.setValues(newValues);
                this.putValue(tagID, value);
            } else {
                value.setValues(newValues);
            }
            CoreDirectory.syncEditableMetadata(this.getOwningMetadata());
        }
    }

    public final boolean shouldDisplayTag(int tagID) {
        String label = this.getTagLabelFor(tagID, false);
        return label != null && !label.endsWith("-X");
    }

    public final synchronized int size() {
        return this.m_tagIDToValueMap.size();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("\n----------------------------------------\n");
        Iterator<Map.Entry<Integer, ImageMetaValue>> i = this.iterator();
        while (i.hasNext()) {
            Map.Entry<Integer, ImageMetaValue> me = i.next();
            sb.append(this.getTagNameFor(me.getKey()));
            sb.append('=');
            sb.append(me.getValue());
            sb.append('\n');
        }
        return sb.toString();
    }

    public Collection<Element> toXMP(Document xmpDoc) {
        return null;
    }

    public String valueToString(ImageMetaValue value) {
        switch (value.getType()) {
            case META_SRATIONAL: 
            case META_URATIONAL: {
                Rational r = ((RationalMetaValue)value).getRationalValue();
                if (r.isInteger()) {
                    return Integer.toString(r.intValue());
                }
                if (r.numerator() <= r.denominator()) break;
                return TextUtil.tenths(r);
            }
        }
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        for (int size = in.readShort(); size > 0; --size) {
            int tagID = in.readInt();
            ImageMetaType type = ImageMetaType.getTypeFor(in.readShort());
            ImageMetaValue value = ImageMetaValue.create(type);
            value.readExternal(in);
            this.putValue(tagID, value);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.size());
        Iterator<Map.Entry<Integer, ImageMetaValue>> i = this.iterator();
        while (i.hasNext()) {
            Map.Entry<Integer, ImageMetaValue> me = i.next();
            int tagID = me.getKey();
            ImageMetaValue value = me.getValue();
            out.writeInt(tagID);
            out.writeShort(value.getType().getTIFFConstant());
            value.writeExternal(out);
        }
    }

    static void moveValuesFromTo(ImageMetadataDirectory sourceDir, ImageMetadataDirectory targetDir) {
        Iterator<Map.Entry<Integer, ImageMetaValue>> i = sourceDir.iterator();
        while (i.hasNext()) {
            Map.Entry<Integer, ImageMetaValue> me = i.next();
            int tagID = me.getKey();
            switch (tagID) {
                case 270: 
                case 271: 
                case 272: 
                case 282: 
                case 283: 
                case 296: 
                case 306: 
                case 315: 
                case 18246: 
                case 33432: {
                    targetDir.putValue(tagID, me.getValue());
                    i.remove();
                }
            }
        }
    }

    final void setOwningMetadata(ImageMetadata metadata) {
        this.m_owningMetadata = metadata;
    }

    protected final void explodeSubfields(int tagID, int startIndex, ImageMetaValue value, boolean asLong) {
        value.setNonDisplayable();
        tagID <<= 8;
        tagID += startIndex;
        switch (value.getType()) {
            case META_UNDEFINED: {
                byte[] bytes = ((UndefinedMetaValue)value).getUndefinedValue();
                ByteBuffer buf = ByteBuffer.wrap(bytes);
                int i = startIndex;
                while (i < bytes.length / 4) {
                    int n = buf.getInt();
                    if (n >= 0) {
                        this.putValue(tagID, new LongMetaValue(n));
                    }
                    ++i;
                    ++tagID;
                }
                break;
            }
            default: {
                if (!value.isNumeric()) break;
                long[] longs = ((LongMetaValue)value).getLongValues();
                int i = startIndex;
                while (i < longs.length) {
                    long n = longs[i];
                    value = asLong ? new LongMetaValue(n) : new ShortMetaValue((short)n);
                    this.putValue(tagID, value);
                    ++i;
                    ++tagID;
                }
                break block0;
            }
        }
    }

    protected final String getCameraMake(int makeTagID, int modelTagID, boolean includeModel) {
        ImageMetaValue modelValue;
        ImageMetaValue makeValue = this.getValue(makeTagID);
        if (makeValue == null) {
            return null;
        }
        String make = makeValue.getStringValue();
        if (includeModel && (modelValue = this.getValue(modelTagID)) != null) {
            make = MetadataUtil.undupMakeModel(make, modelValue.toString());
        }
        return make.toUpperCase().trim();
    }

    protected int getProviderPriorityFor(Class<? extends ImageMetadataProvider> provider) {
        return 1;
    }

    protected abstract ResourceBundle getTagLabelBundle();

    protected abstract Class<? extends ImageMetaTags> getTagsInterface();

    protected static String makeLensLabelFrom(ImageMetaValue value) {
        switch (value.getType()) {
            case META_SRATIONAL: 
            case META_URATIONAL: {
                Rational[] lensValues = ((RationalMetaValue)value).getRationalValues();
                if (lensValues.length != 4) break;
                StringBuilder sb = new StringBuilder();
                sb.append(TextUtil.tenths(lensValues[0]));
                if (lensValues[0].compareTo(lensValues[1]) != 0) {
                    sb.append('-');
                    sb.append(TextUtil.tenths(lensValues[1]));
                }
                sb.append("mm F");
                sb.append(TextUtil.tenths(lensValues[2]));
                if (lensValues[2].compareTo(lensValues[3]) != 0) {
                    sb.append('-');
                    sb.append(TextUtil.tenths(lensValues[3]));
                }
                return sb.toString();
            }
        }
        return null;
    }

    protected static String makeLensLabelFrom(ImageMetaValue shortFocalLenValue, ImageMetaValue longFocalLenValue, ImageMetaValue unitsPerMMValue) {
        double shortFocalLen;
        if (shortFocalLenValue != null && longFocalLenValue != null && (shortFocalLen = (double)shortFocalLenValue.getIntValue()) > 0.0) {
            int unitsPerMM;
            double longFocalLen = longFocalLenValue.getIntValue();
            if (unitsPerMMValue != null && (unitsPerMM = unitsPerMMValue.getIntValue()) > 0) {
                shortFocalLen /= (double)unitsPerMM;
                longFocalLen /= (double)unitsPerMM;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(TextUtil.tenths(shortFocalLen));
            if (longFocalLen > shortFocalLen) {
                sb.append('-');
                sb.append(TextUtil.tenths(longFocalLen));
            }
            sb.append("mm");
            return sb.toString();
        }
        return null;
    }

    protected boolean readMakerNotes(LCByteBuffer buf, int offset, int byteCount) throws IOException {
        return false;
    }

    protected Collection<Element> toXMP(Document xmpDoc, String nsURI, String prefix) {
        Node rdfDescElement = null;
        Iterator<Map.Entry<Integer, ImageMetaValue>> i = this.iterator();
        while (i.hasNext()) {
            Map.Entry<Integer, ImageMetaValue> me = i.next();
            ImageMetaValue value = me.getValue();
            Element valueElement = value.toXMP(xmpDoc, nsURI, prefix);
            if (valueElement == null) continue;
            if (rdfDescElement == null) {
                rdfDescElement = XMPUtil.createRDFDescription(xmpDoc, nsURI, prefix);
            }
            rdfDescElement.appendChild(valueElement);
        }
        if (rdfDescElement != null) {
            ArrayList<Element> elements = new ArrayList<Element>(1);
            elements.add((Element)rdfDescElement);
            return elements;
        }
        return null;
    }

    private ImageMetadataDirectory getStaticParent() {
        Class<? extends ImageMetadataDirectory> superClass = ImageMetadataDirectory.getSuperClassOf(this.getClass());
        return superClass != null && this.m_owningMetadata != null ? this.m_owningMetadata.getDirectoryFor(superClass) : null;
    }

    private static Class<? extends ImageMetadataDirectory> getSuperClassOf(Class<? extends ImageMetadataDirectory> dirClass) {
        Class<? extends ImageMetadataDirectory> superClass = dirClass.getSuperclass();
        return superClass == ImageMetadataDirectory.class || superClass == Object.class ? null : superClass;
    }
}

