/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.EXIFDirectory;
import com.lightcrafts.image.metadata.EXIFMetadataReader;
import com.lightcrafts.image.metadata.GPSDirectory;
import com.lightcrafts.image.metadata.IPTCMetadataReader;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.ImageMetadataReader;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.TIFFDirectory;
import com.lightcrafts.image.metadata.values.ByteMetaValue;
import com.lightcrafts.image.metadata.values.DateMetaValue;
import com.lightcrafts.image.metadata.values.DoubleMetaValue;
import com.lightcrafts.image.metadata.values.FloatMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.LongMetaValue;
import com.lightcrafts.image.metadata.values.RationalMetaValue;
import com.lightcrafts.image.metadata.values.ShortMetaValue;
import com.lightcrafts.image.metadata.values.StringMetaValue;
import com.lightcrafts.image.metadata.values.UndefinedMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedByteMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedLongMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedRationalMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedShortMetaValue;
import com.lightcrafts.image.types.TIFFConstants;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.utils.Rational;
import com.lightcrafts.utils.bytebuffer.ArrayByteBuffer;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class TIFFMetadataReader
extends ImageMetadataReader {
    private final Class<? extends ImageMetadataDirectory> m_dirClass;
    private final Map<String, ImageMetadataDirectory> m_dirMap = new HashMap<String, ImageMetadataDirectory>();
    private int m_subIFDIndex;

    public TIFFMetadataReader(ImageInfo imageInfo) {
        this(imageInfo, imageInfo.getByteBuffer(), TIFFDirectory.class);
    }

    public TIFFMetadataReader(ImageInfo imageInfo, LCByteBuffer tiffBuf) {
        this(imageInfo, tiffBuf, TIFFDirectory.class);
    }

    public TIFFMetadataReader(ImageInfo imageInfo, Class<? extends ImageMetadataDirectory> dirClass) {
        this(imageInfo, imageInfo.getByteBuffer(), dirClass);
    }

    public static int calcIFDEntryOffset(int dirOffset, int entry) {
        return dirOffset + 2 + entry * 12;
    }

    @Override
    protected void readHeader() throws BadImageFileException, IOException {
        this.m_buf.position(0);
        if (this.m_buf.remaining() < 8) {
            throw new BadImageFileException(this.m_imageInfo.getFile());
        }
        short byteOrder = this.m_buf.getShort();
        if (byteOrder == 18761) {
            this.m_buf.order(ByteOrder.LITTLE_ENDIAN);
        } else if (byteOrder == 19789) {
            this.m_buf.order(ByteOrder.BIG_ENDIAN);
        } else {
            throw new BadImageFileException(this.m_imageInfo.getFile());
        }
        if (this.m_buf.getUnsignedShort() < 42) {
            throw new BadImageFileException(this.m_imageInfo.getFile());
        }
    }

    @Override
    protected void readAllDirectories() throws IOException {
        ImageMetaValue xmpValue = null;
        this.m_buf.position(4);
        int ifdOffset = this.m_buf.getInt();
        HashSet<Integer> ifdOffsetSet = new HashSet<Integer>();
        int dirIndex = 0;
        while (ifdOffset > 0 && ifdOffsetSet.add(ifdOffset)) {
            ImageMetadataDirectory dir = this.createDirectoryFor(this.m_dirClass, "IFD" + dirIndex);
            if (dirIndex == 0) {
                this.m_metadata.putDirectory(dir);
            }
            this.readDirectory(ifdOffset, dir);
            if (dirIndex == 0) {
                xmpValue = dir.getValue(700);
            }
            if ((ifdOffset = this.m_buf.getInt()) >= this.m_buf.limit()) {
                this.logBadImageMetadata();
            }
            ++dirIndex;
        }
        ImageMetadataDirectory dir = this.mergeDirectories();
        if (dir == null) {
            return;
        }
        this.m_metadata.putDirectory(dir);
        this.patchEXIFImageSize(dir, 256, 257);
        this.patchEXIFImageSize(dir, 40962, 40963);
        if (xmpValue != null) {
            dir.putValue(700, xmpValue);
        }
    }

    private boolean isLightZoneLayeredTIFF() {
        ImageMetadataDirectory tiffDir = this.m_metadata.getDirectoryFor(TIFFDirectory.class);
        if (tiffDir == null) {
            return false;
        }
        ImageMetaValue value = tiffDir.getValue(305);
        if (value == null) {
            return false;
        }
        String software = value.getStringValue();
        if (software == null || !software.startsWith("LightZone")) {
            return false;
        }
        value = tiffDir.getValue(297);
        if (value == null || value.getValueCount() != 2) {
            return false;
        }
        String[] page = value.getValues();
        try {
            return Integer.parseInt(page[1]) == 2;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private TIFFMetadataReader(ImageInfo imageInfo, LCByteBuffer tiffBuf, Class<? extends ImageMetadataDirectory> dirClass) {
        super(imageInfo, tiffBuf);
        this.m_dirClass = dirClass;
    }

    private int calcValueOffset(int byteCount) throws IOException {
        if (byteCount <= 4) {
            return this.m_buf.position();
        }
        int offset = this.m_buf.getInt();
        if (offset + byteCount > this.m_buf.limit()) {
            return -1;
        }
        return offset;
    }

    private ImageMetadataDirectory createDirectoryFor(Class<? extends ImageMetadataDirectory> dirClass, String name) {
        try {
            ImageMetadataDirectory dir = dirClass.newInstance();
            dir.setOwningMetadata(this.m_metadata);
            this.m_dirMap.put(name, dir);
            return dir;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private ImageMetadataDirectory mergeDirectories() {
        ImageMetadataDirectory dir;
        switch (this.m_dirMap.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.m_dirMap.values().toArray(new ImageMetadataDirectory[0])[0];
            }
        }
        ImageMetadataDirectory mergedDir = null;
        ImageMetadataDirectory dirWithLargestImageSize = null;
        int largestWidth = 0;
        for (Map.Entry<String, ImageMetadataDirectory> me : this.m_dirMap.entrySet()) {
            int width;
            dir = me.getValue();
            if (MetadataUtil.isFullSizedImage(dir)) {
                mergedDir = dir;
                break;
            }
            ImageMetaValue widthValue = dir.getValue(256);
            if (widthValue == null || (width = widthValue.getIntValue()) <= largestWidth) continue;
            largestWidth = width;
            dirWithLargestImageSize = dir;
        }
        if (mergedDir == null) {
            mergedDir = dirWithLargestImageSize;
        }
        if (mergedDir == null) {
            return null;
        }
        for (Map.Entry<String, ImageMetadataDirectory> me : this.m_dirMap.entrySet()) {
            dir = me.getValue();
            if (dir == mergedDir) continue;
            TIFFMetadataReader.copyValuesFromTo(dir, mergedDir);
        }
        return mergedDir;
    }

    private void patchEXIFImageSize(ImageMetadataDirectory tiffDir, int exifWidthTagID, int exifHeightTagID) {
        ImageMetaValue tiffWidth = tiffDir.getValue(256);
        ImageMetaValue tiffHeight = tiffDir.getValue(257);
        if (tiffWidth == null || tiffHeight == null) {
            return;
        }
        ImageMetadataDirectory exifDir = this.m_metadata.getDirectoryFor(EXIFDirectory.class);
        ImageMetaValue exifWidth = exifDir.getValue(exifWidthTagID);
        ImageMetaValue exifHeight = exifDir.getValue(exifHeightTagID);
        if (exifWidth == null || exifHeight == null) {
            return;
        }
        int width = tiffWidth.getIntValue();
        if (width > exifWidth.getIntValue()) {
            int height = tiffHeight.getIntValue();
            ((LongMetaValue)exifWidth).setLongValueAt(width, 0);
            ((LongMetaValue)exifHeight).setLongValueAt(height, 0);
        }
    }

    private void readDirectory(int offset, ImageMetadataDirectory dir) throws IOException {
        int entryCount = this.m_buf.getUnsignedShort(offset);
        if (entryCount > 256) {
            entryCount = 256;
        }
        for (int entry = 0; entry < entryCount; ++entry) {
            try {
                int pos = TIFFMetadataReader.calcIFDEntryOffset(offset, entry);
                this.readDirectoryEntry(pos, dir);
                continue;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                this.logBadImageMetadata(e);
            }
        }
        this.m_buf.position(TIFFMetadataReader.calcIFDEntryOffset(offset, entryCount));
    }

    private void readDirectoryEntry(int offset, ImageMetadataDirectory dir) throws IOException {
        boolean handledTag;
        this.m_buf.position(offset);
        int tagID = this.m_buf.getUnsignedShort();
        if (tagID < 0) {
            return;
        }
        int fieldType = this.m_buf.getUnsignedShort();
        if (fieldType <= 0 || fieldType >= TIFFConstants.TIFF_FIELD_SIZE.length) {
            return;
        }
        int numValues = this.m_buf.getInt();
        if (numValues < 0) {
            this.logBadImageMetadata();
            return;
        }
        int byteCount = numValues * TIFFConstants.TIFF_FIELD_SIZE[fieldType];
        if (byteCount <= 0) {
            return;
        }
        int valueOffset = this.calcValueOffset(byteCount);
        if (valueOffset < 0) {
            this.logBadImageMetadata();
            return;
        }
        int subdirOffset = this.m_buf.getInt(valueOffset);
        if (this.m_tagHandler != null && (handledTag = this.m_tagHandler.handleTag(tagID, fieldType, numValues, byteCount, valueOffset, 0, subdirOffset, this.m_imageInfo, this.m_buf, dir))) {
            return;
        }
        switch (tagID) {
            case 34665: {
                EXIFMetadataReader reader = new EXIFMetadataReader(this.m_imageInfo, this.m_buf, true);
                reader.setTagHandler(this.m_tagHandler);
                ImageMetadataDirectory exifDir = this.m_metadata.getDirectoryFor(EXIFDirectory.class, true);
                reader.readDirectory(subdirOffset, 0, exifDir);
                return;
            }
            case 34853: {
                ImageMetadataDirectory gpsDir = this.m_metadata.getDirectoryFor(GPSDirectory.class, true);
                this.readDirectory(subdirOffset, gpsDir);
                return;
            }
            case 33723: {
                byte[] iptcBuf = this.m_buf.getBytes(valueOffset, byteCount);
                IPTCMetadataReader reader = new IPTCMetadataReader(this.m_imageInfo, new ArrayByteBuffer(iptcBuf), TIFFImageType.INSTANCE);
                reader.readAllDirectories();
                return;
            }
            case 330: {
                while (true) {
                    ImageMetadataDirectory subDir = this.createDirectoryFor(this.m_dirClass, "SubIFD" + this.m_subIFDIndex++);
                    this.readDirectory(subdirOffset, subDir);
                    if (--numValues == 0) break;
                    subdirOffset = this.m_buf.getInt(valueOffset += TIFFConstants.TIFF_FIELD_SIZE[13]);
                }
                return;
            }
        }
        if (byteCount > 131072) {
            return;
        }
        ImageMetaValue value = this.readValue(tagID, fieldType, valueOffset, numValues);
        if (value != null) {
            try {
                dir.putValue(tagID, value);
            }
            catch (IllegalArgumentException e) {
                this.logBadImageMetadata();
            }
        }
    }

    private String readString(int offset, int maxLength) throws IOException {
        int length;
        for (length = 0; this.m_buf.get(offset + length) != 0 && length < maxLength; ++length) {
        }
        return this.m_buf.getString(offset, length, "ISO-8859-1");
    }

    private ImageMetaValue readValue(int tagID, int fieldType, int offset, int numValues) throws IOException {
        switch (fieldType) {
            case 2: {
                String s = this.readString(offset, numValues);
                if (s == null) {
                    return null;
                }
                switch (tagID) {
                    case 306: {
                        return new DateMetaValue(s);
                    }
                }
                return new StringMetaValue(s);
            }
            case 6: {
                long[] values = new long[numValues];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.get(offset + i);
                }
                return new ByteMetaValue(values);
            }
            case 1: {
                long[] values = new long[numValues];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getUnsignedByte(offset + i);
                }
                return new UnsignedByteMetaValue(values);
            }
            case 9: {
                long[] values = new long[numValues];
                int valueSize = TIFFConstants.TIFF_FIELD_SIZE[9];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getInt(offset + i * valueSize);
                }
                return new LongMetaValue(values);
            }
            case 4: {
                long[] values = new long[numValues];
                int valueSize = TIFFConstants.TIFF_FIELD_SIZE[4];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getInt(offset + i * valueSize);
                }
                return new UnsignedLongMetaValue(values);
            }
            case 10: {
                Rational[] values = new Rational[numValues];
                int valueSize = TIFFConstants.TIFF_FIELD_SIZE[10];
                int longSize = TIFFConstants.TIFF_FIELD_SIZE[9];
                for (int i = 0; i < numValues; ++i) {
                    try {
                        int pos = offset + i * valueSize;
                        values[i] = new Rational(this.m_buf.getInt(pos), this.m_buf.getInt(pos + longSize));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.logBadImageMetadata();
                        return null;
                    }
                }
                return new RationalMetaValue(values);
            }
            case 5: {
                Rational[] values = new Rational[numValues];
                int valueSize = TIFFConstants.TIFF_FIELD_SIZE[5];
                int longSize = TIFFConstants.TIFF_FIELD_SIZE[4];
                for (int i = 0; i < numValues; ++i) {
                    try {
                        int pos = offset + i * valueSize;
                        values[i] = new Rational(this.m_buf.getInt(pos), this.m_buf.getInt(pos + longSize));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.logBadImageMetadata();
                        return null;
                    }
                }
                return new UnsignedRationalMetaValue(values);
            }
            case 8: {
                long[] values = new long[numValues];
                int valueSize = TIFFConstants.TIFF_FIELD_SIZE[8];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getShort(offset + i * valueSize);
                }
                return new ShortMetaValue(values);
            }
            case 3: {
                long[] values = new long[numValues];
                int valueSize = TIFFConstants.TIFF_FIELD_SIZE[3];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getUnsignedShort(offset + i * valueSize);
                }
                return new UnsignedShortMetaValue(values);
            }
            case 11: {
                float[] values = new float[numValues];
                int valueSize = TIFFConstants.TIFF_FIELD_SIZE[11];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getFloat(offset + i * valueSize);
                }
                return new FloatMetaValue(values);
            }
            case 12: {
                double[] values = new double[numValues];
                int valueSize = TIFFConstants.TIFF_FIELD_SIZE[12];
                for (int i = 0; i < numValues; ++i) {
                    values[i] = this.m_buf.getDouble(offset + i * valueSize);
                }
                return new DoubleMetaValue(values);
            }
            case 7: {
                return new UndefinedMetaValue(this.m_buf.getBytes(offset, numValues));
            }
        }
        throw new IllegalStateException("unknown field type (" + fieldType + ") for tag ID " + tagID);
    }

    private static void copyValuesFromTo(ImageMetadataDirectory fromDir, ImageMetadataDirectory toDir) {
        Iterator<Map.Entry<Integer, ImageMetaValue>> i = fromDir.iterator();
        block3: while (i.hasNext()) {
            Map.Entry<Integer, ImageMetaValue> me = i.next();
            int tagID = me.getKey();
            switch (tagID) {
                case 254: 
                case 255: 
                case 256: 
                case 257: 
                case 258: 
                case 259: 
                case 262: 
                case 273: 
                case 277: 
                case 278: 
                case 279: 
                case 282: 
                case 283: 
                case 284: 
                case 286: 
                case 287: 
                case 301: 
                case 317: 
                case 319: 
                case 322: 
                case 323: 
                case 324: 
                case 325: 
                case 330: 
                case 339: 
                case 340: 
                case 341: 
                case 342: 
                case 529: 
                case 530: 
                case 531: 
                case 532: 
                case 34675: {
                    continue block3;
                }
            }
            ImageMetaValue toValue = toDir.getValue(tagID);
            if (toValue != null) continue;
            toDir.putValue(tagID, me.getValue());
        }
    }
}

