/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.makernotes;

import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.makernotes.KodakTags;
import com.lightcrafts.image.metadata.makernotes.MakerNotesDirectory;
import com.lightcrafts.image.metadata.providers.ApertureProvider;
import com.lightcrafts.image.metadata.providers.ISOProvider;
import com.lightcrafts.image.metadata.providers.WidthHeightProvider;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.StringMetaValue;
import com.lightcrafts.utils.TextUtil;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public final class KodakDirectory
extends MakerNotesDirectory
implements ApertureProvider,
ISOProvider,
WidthHeightProvider {
    private static final ResourceBundle m_tagBundle = ResourceBundle.getBundle("com.lightcrafts.image.metadata.makernotes.KodakTags");
    private static final Map<Integer, ImageMetaTagInfo> m_tagsByID = new HashMap<Integer, ImageMetaTagInfo>();
    private static final Map<String, ImageMetaTagInfo> m_tagsByName = new HashMap<String, ImageMetaTagInfo>();

    @Override
    public float getAperture() {
        ImageMetaValue value = this.getValue(30);
        return value != null ? value.getFloatValue() / 100.0f : 0.0f;
    }

    @Override
    public int getImageHeight() {
        ImageMetaValue value = this.getValue(14);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public int getImageWidth() {
        ImageMetaValue value = this.getValue(12);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public int getISO() {
        ImageMetaValue value = this.getValue(96);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public int[] getMakerNotesAdjustments(LCByteBuffer buf, int offset) {
        return new int[]{8, offset};
    }

    @Override
    public String getName() {
        return "Kodak";
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(Integer id) {
        return m_tagsByID.get(id);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(String name) {
        return m_tagsByName.get(name);
    }

    @Override
    public String valueToString(ImageMetaValue value) {
        switch (value.getOwningTagID()) {
            case 98: 
            case 104: {
                return TextUtil.tenths((float)value.getIntValue() / 100.0f);
            }
            case 32: {
                return MetadataUtil.shutterSpeedString((double)value.getFloatValue() / 100000.0);
            }
            case 36: {
                return TextUtil.tenths((float)value.getIntValue() / 1000.0f);
            }
            case 30: {
                return TextUtil.tenths(this.getAperture());
            }
            case 94: {
                int iso = value.getIntValue();
                return iso > 0 ? String.valueOf(iso) : "auto";
            }
            case 18: {
                int monthDay = value.getUnsignedShortValue();
                return (monthDay >>> 8) + "/" + (monthDay & 0xFF);
            }
            case 20: {
                int time = value.getIntValue();
                return String.format("%02d:%02d:%02d.%02d", time >>> 24 & 0xFF, time >>> 16 & 0xFF, time >>> 8 & 0xFF, time & 0xFF);
            }
        }
        return super.valueToString(value);
    }

    @Override
    protected ResourceBundle getTagLabelBundle() {
        return m_tagBundle;
    }

    @Override
    protected Class<? extends ImageMetaTags> getTagsInterface() {
        return KodakTags.class;
    }

    @Override
    protected boolean readMakerNotes(LCByteBuffer buf, int offset, int byteCount) throws IOException {
        int valueSize;
        ByteOrder origOrder = buf.probeOrder(offset + 12);
        int end = offset + byteCount;
        for (int tagID = 0; offset < end && tagID <= 107; tagID += valueSize, offset += valueSize) {
            valueSize = this.readValue(buf, offset, tagID);
        }
        buf.order(origOrder);
        return true;
    }

    private static void add(int id, String name, ImageMetaType type) {
        ImageMetaTagInfo tagInfo = new ImageMetaTagInfo(id, name, type, false);
        m_tagsByID.put(id, tagInfo);
        m_tagsByName.put(name, tagInfo);
    }

    private int readValue(LCByteBuffer buf, int offset, int tagID) throws IOException {
        long n;
        switch (tagID) {
            case 0: {
                String model = buf.getString(offset, 8, "ASCII").trim();
                StringMetaValue value = new StringMetaValue(model);
                this.putValue(tagID, value);
                return 8;
            }
        }
        ImageMetaTagInfo tag = this.getTagInfoFor(tagID);
        if (tag == null) {
            return 1;
        }
        ImageMetaValue value = tag.createValue();
        int size = tag.getSize();
        switch (size) {
            case 1: {
                n = buf.getUnsignedByte(offset);
                break;
            }
            case 2: {
                n = buf.getUnsignedShort(offset);
                break;
            }
            case 4: {
                n = buf.getLong(offset);
                break;
            }
            default: {
                throw new IllegalStateException("bad size: " + size);
            }
        }
        value.setLongValue(n);
        this.putValue(tagID, value);
        return size;
    }

    static {
        KodakDirectory.add(10, "BurstMode", ImageMetaType.META_UBYTE);
        KodakDirectory.add(104, "DigitalZoom", ImageMetaType.META_USHORT);
        KodakDirectory.add(36, "ExposureCompensation", ImageMetaType.META_SSHORT);
        KodakDirectory.add(32, "ExposureTime", ImageMetaType.META_ULONG);
        KodakDirectory.add(93, "FlashFired", ImageMetaType.META_UBYTE);
        KodakDirectory.add(30, "FNumber", ImageMetaType.META_USHORT);
        KodakDirectory.add(56, "FocusMode", ImageMetaType.META_UBYTE);
        KodakDirectory.add(14, "ImageHeight", ImageMetaType.META_USHORT);
        KodakDirectory.add(12, "ImageWidth", ImageMetaType.META_USHORT);
        KodakDirectory.add(96, "ISO", ImageMetaType.META_USHORT);
        KodakDirectory.add(94, "ISOSetting", ImageMetaType.META_USHORT);
        KodakDirectory.add(28, "MeteringMode", ImageMetaType.META_USHORT);
        KodakDirectory.add(0, "Model", ImageMetaType.META_STRING);
        KodakDirectory.add(18, "MonthDayCreated", ImageMetaType.META_USHORT);
        KodakDirectory.add(9, "Quality", ImageMetaType.META_UBYTE);
        KodakDirectory.add(29, "SequenceNumber", ImageMetaType.META_UBYTE);
        KodakDirectory.add(107, "Sharpness", ImageMetaType.META_SSHORT);
        KodakDirectory.add(27, "ShutterMode", ImageMetaType.META_UBYTE);
        KodakDirectory.add(20, "TimeCreated", ImageMetaType.META_ULONG);
        KodakDirectory.add(98, "TotalZoom", ImageMetaType.META_USHORT);
        KodakDirectory.add(64, "WhiteBalance", ImageMetaType.META_UBYTE);
        KodakDirectory.add(16, "YearCreated", ImageMetaType.META_USHORT);
        KodakDirectory.add(24, "Unknown0x18", ImageMetaType.META_USHORT);
        KodakDirectory.add(38, "Unknown0x26", ImageMetaType.META_USHORT);
        KodakDirectory.add(40, "Unknown0x28", ImageMetaType.META_ULONG);
        KodakDirectory.add(44, "Unknown0x2C", ImageMetaType.META_ULONG);
        KodakDirectory.add(48, "Unknown0x30", ImageMetaType.META_ULONG);
        KodakDirectory.add(52, "Unknown0x34", ImageMetaType.META_ULONG);
        KodakDirectory.add(58, "Unknown0x3A", ImageMetaType.META_USHORT);
        KodakDirectory.add(60, "Unknown0x3C", ImageMetaType.META_USHORT);
        KodakDirectory.add(62, "Unknown0x3E", ImageMetaType.META_USHORT);
        KodakDirectory.add(66, "Unknown0x42", ImageMetaType.META_ULONG);
        KodakDirectory.add(70, "Unknown0x46", ImageMetaType.META_ULONG);
        KodakDirectory.add(74, "Unknown0x4A", ImageMetaType.META_ULONG);
        KodakDirectory.add(78, "Unknown0x4E", ImageMetaType.META_ULONG);
        KodakDirectory.add(82, "Unknown0x52", ImageMetaType.META_ULONG);
        KodakDirectory.add(86, "Unknown0x56", ImageMetaType.META_ULONG);
        KodakDirectory.add(90, "Unknown0x5A", ImageMetaType.META_ULONG);
    }
}

