/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.values;

import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.values.ShortMetaValue;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ByteMetaValue
extends ShortMetaValue {
    public ByteMetaValue() {
    }

    public ByteMetaValue(long ... values) {
        super(values);
    }

    public ByteMetaValue(String ... values) {
        super(values);
    }

    public byte[] getByteValues() {
        long[] values = this.getLongValues();
        byte[] temp = new byte[values.length];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = (byte)values[i];
        }
        return temp;
    }

    @Override
    public ImageMetaType getType() {
        return ImageMetaType.META_SBYTE;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int length = this.readHeader(in);
        this.m_value = new long[length];
        for (int i = 0; i < length; ++i) {
            this.m_value[i] = in.readByte();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeHeader(out);
        for (long value : this.m_value) {
            out.writeByte((byte)value);
        }
    }

    @Override
    protected long constrain(long value) {
        return (byte)value;
    }

    @Override
    protected long parseValue(String newValue) {
        return Byte.parseByte(newValue);
    }
}

