/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.values;

import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.values.NumericMetaValue;
import com.lightcrafts.utils.LCArrays;
import com.lightcrafts.utils.Rational;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class DoubleMetaValue
extends NumericMetaValue {
    private double[] m_value;

    public DoubleMetaValue() {
    }

    public DoubleMetaValue(double ... values) {
        this.m_value = values;
    }

    public DoubleMetaValue(String ... values) {
        this.setValuesImpl(values);
    }

    @Override
    public DoubleMetaValue clone() {
        DoubleMetaValue copy = (DoubleMetaValue)super.clone();
        copy.m_value = (double[])this.m_value.clone();
        return copy;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof NumericMetaValue) {
            NumericMetaValue rightVal = (NumericMetaValue)o;
            double leftDouble = this.getDoubleValue();
            double rightDouble = rightVal.getDoubleValue();
            return Double.compare(leftDouble, rightDouble);
        }
        return super.compareTo(o);
    }

    @Override
    public int compareTo(String s) {
        try {
            double rightDouble = s.indexOf(47) > 0 ? Rational.parseRational(s).doubleValue() : Double.parseDouble(s);
            double leftDouble = this.getDoubleValue();
            return Double.compare(leftDouble, rightDouble);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    @Override
    public double getDoubleValue() {
        return this.m_value[0];
    }

    public double[] getDoubleValues() {
        return this.m_value;
    }

    @Override
    public long getLongValue() {
        return (long)this.getDoubleValue();
    }

    @Override
    public ImageMetaType getType() {
        return ImageMetaType.META_DOUBLE;
    }

    @Override
    public int getValueCount() {
        return this.m_value != null ? this.m_value.length : 0;
    }

    @Override
    public boolean isLegalValue(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void setDoubleValue(double newValue) {
        this.setDoubleValueAt(newValue, 0);
    }

    public synchronized void setDoubleValueAt(double newValue, int index) {
        this.checkIsEditable();
        if (this.m_value == null) {
            this.m_value = new double[index + 1];
        } else if (index >= this.m_value.length) {
            this.m_value = (double[])LCArrays.resize(this.m_value, index + 1);
        }
        this.m_value[index] = newValue;
        this.dirty();
    }

    @Override
    public void setLongValue(long newValue) {
        this.setDoubleValueAt(newValue, 0);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int length = this.readHeader(in);
        this.m_value = new double[length];
        for (int i = 0; i < length; ++i) {
            this.m_value[i] = in.readDouble();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeHeader(out);
        for (double value : this.m_value) {
            out.writeDouble(value);
        }
    }

    @Override
    protected void appendValueImpl(String newValue) {
        double newDouble = Double.parseDouble(newValue);
        if (this.m_value == null) {
            this.m_value = new double[]{newDouble};
        } else {
            this.m_value = (double[])LCArrays.resize(this.m_value, this.m_value.length + 1);
            this.m_value[this.m_value.length - 1] = newDouble;
        }
    }

    @Override
    protected String[] getValuesImpl() {
        if (this.m_value == null) {
            return null;
        }
        String[] value = new String[this.m_value.length];
        for (int i = 0; i < this.m_value.length; ++i) {
            value[i] = Double.toString(this.m_value[i]);
        }
        return value;
    }

    @Override
    protected void setValuesImpl(String[] newValue) {
        if (this.m_value == null || this.m_value.length != newValue.length) {
            this.m_value = new double[newValue.length];
        }
        for (int i = 0; i < newValue.length; ++i) {
            this.m_value[i] = Double.parseDouble(newValue[i]);
        }
    }

    @Override
    protected String toStringImpl() {
        if (this.m_value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean comma = false;
        for (double value : this.m_value) {
            if (!comma) {
                comma = true;
            } else {
                sb.append(',');
            }
            sb.append(value);
        }
        return sb.toString();
    }
}

