/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.values;

import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.utils.LCArrays;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class StringMetaValue
extends ImageMetaValue {
    private String[] m_value;

    public StringMetaValue() {
    }

    public StringMetaValue(String ... values) {
        if (values != null && values.length > 0) {
            this.m_value = new String[values.length];
            System.arraycopy(values, 0, this.m_value, 0, values.length);
        }
    }

    @Override
    public StringMetaValue clone() {
        StringMetaValue copy = (StringMetaValue)super.clone();
        copy.m_value = (String[])this.m_value.clone();
        return copy;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof StringMetaValue) {
            StringMetaValue rightValue = (StringMetaValue)o;
            String leftString = this.getStringValue().toLowerCase();
            String rightString = rightValue.getStringValue().toLowerCase();
            return leftString.compareTo(rightString);
        }
        return super.compareTo(o);
    }

    @Override
    public int compareTo(String s) {
        String leftString = this.getStringValue();
        if (leftString == null) {
            return s == null ? 0 : -1;
        }
        return leftString.toLowerCase().compareTo(s.toLowerCase());
    }

    @Override
    public double getDoubleValue() {
        try {
            return Double.parseDouble(this.getStringValue());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    public long getLongValue() {
        try {
            return Long.parseLong(this.getStringValue());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public ImageMetaType getType() {
        return ImageMetaType.META_STRING;
    }

    @Override
    public int getValueCount() {
        return this.m_value != null ? this.m_value.length : 0;
    }

    @Override
    public void setDoubleValue(double newValue) {
        this.setStringValueAt(Double.toString(newValue), 0);
    }

    @Override
    public void setLongValue(long newValue) {
        this.setStringValueAt(Long.toString(newValue), 0);
    }

    public synchronized void setStringValueAt(String newValue, int index) {
        this.checkIsEditable();
        if (this.m_value == null) {
            this.m_value = new String[index + 1];
        } else if (index >= this.m_value.length) {
            this.m_value = (String[])LCArrays.resize(this.m_value, index + 1);
        }
        this.m_value[index] = newValue;
        this.dirty();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int length = this.readHeader(in);
        this.m_value = new String[length];
        for (int i = 0; i < length; ++i) {
            this.m_value[i] = in.readUTF();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeHeader(out);
        for (String value : this.m_value) {
            out.writeUTF(value);
        }
    }

    @Override
    protected void appendValueImpl(String newValue) {
        if (this.m_value == null) {
            this.m_value = new String[]{newValue};
        } else {
            this.m_value = (String[])LCArrays.resize(this.m_value, this.m_value.length + 1);
            this.m_value[this.m_value.length - 1] = newValue;
        }
    }

    @Override
    protected String[] getValuesImpl() {
        if (this.m_value == null) {
            return null;
        }
        String[] value = new String[this.m_value.length];
        System.arraycopy(this.m_value, 0, value, 0, this.m_value.length);
        return value;
    }

    @Override
    protected void setValuesImpl(String[] newValue) {
        if (newValue == null) {
            this.m_value = null;
            return;
        }
        if (this.m_value == null || this.m_value.length != newValue.length) {
            this.m_value = new String[newValue.length];
        }
        System.arraycopy(newValue, 0, this.m_value, 0, newValue.length);
    }

    @Override
    protected String toStringImpl() {
        if (this.m_value == null) {
            return null;
        }
        ImageMetadataDirectory owningDir = this.getOwningDirectory();
        int tagID = this.getOwningTagID();
        StringBuilder sb = new StringBuilder();
        boolean comma = false;
        for (String value : this.m_value) {
            if (!comma) {
                comma = true;
            } else {
                sb.append(',');
            }
            if (owningDir != null) {
                value = owningDir.getTagValueLabelFor(tagID, value);
            }
            sb.append(value);
        }
        return sb.toString();
    }
}

