/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.DNGDirectory;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.TIFFMetadataReader;
import com.lightcrafts.image.metadata.XMPMetadataReader;
import com.lightcrafts.image.types.RawImageType;
import com.lightcrafts.image.types.TIFFImageType;
import java.io.IOException;
import org.w3c.dom.Document;

public final class DNGImageType
extends RawImageType {
    public static final DNGImageType INSTANCE = new DNGImageType();
    private static final String[] EXTENSIONS = new String[]{"dng"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return "DNG";
    }

    @Override
    public Document getXMP(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        return TIFFImageType.getXMP(imageInfo, DNGDirectory.class);
    }

    @Override
    public void readMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        TIFFMetadataReader reader = new TIFFMetadataReader(imageInfo, DNGDirectory.class);
        ImageMetadata metadata = reader.readMetadata();
        Document xmpDoc = this.getXMP(imageInfo);
        if (xmpDoc != null) {
            ImageMetadata xmpMetadata = XMPMetadataReader.readFrom(xmpDoc);
            metadata.mergeFrom(xmpMetadata);
        }
    }

    @Override
    public boolean hasFastPreview() {
        return true;
    }

    private DNGImageType() {
    }
}

