/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.types.AuxiliaryImageInfo;
import com.lightcrafts.image.types.JPEGParser;
import com.lightcrafts.image.types.JPEGParserEventHandler;
import com.lightcrafts.image.types.JPEGSegmentFilter;
import com.lightcrafts.utils.bytebuffer.LCByteBuffer;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JPEGImageInfo
extends AuxiliaryImageInfo {
    private final Map<Byte, ArrayList<ByteBuffer>> m_segMap = new HashMap<Byte, ArrayList<ByteBuffer>>();

    public JPEGImageInfo(ImageInfo jpegInfo, byte ... segIDs) throws BadImageFileException, IOException {
        new SegmentReader().readSegments(jpegInfo, segIDs);
    }

    public List<ByteBuffer> getAllSegmentsFor(Byte segID) {
        return this.getAllSegmentsFor(segID, null);
    }

    public List<ByteBuffer> getAllSegmentsFor(Byte segID, JPEGSegmentFilter filter) {
        List segList = this.m_segMap.get(segID);
        if (segList == null) {
            return null;
        }
        if (filter == null) {
            return new ArrayList<ByteBuffer>(segList);
        }
        ArrayList<ByteBuffer> filteredSegList = null;
        for (ByteBuffer segBuf : segList) {
            if (!filter.accept(segID, segBuf)) continue;
            if (filteredSegList == null) {
                filteredSegList = new ArrayList<ByteBuffer>();
            }
            filteredSegList.add(segBuf);
        }
        return filteredSegList;
    }

    public ByteBuffer getFirstSegmentFor(Byte segID) {
        return this.getFirstSegmentFor(segID, null);
    }

    public ByteBuffer getFirstSegmentFor(Byte segID, JPEGSegmentFilter filter) {
        List segList = this.m_segMap.get(segID);
        if (segList == null) {
            return null;
        }
        if (filter == null) {
            return (ByteBuffer)segList.get(0);
        }
        for (ByteBuffer segBuf : segList) {
            if (!filter.accept(segID, segBuf)) continue;
            return segBuf;
        }
        return null;
    }

    private final class SegmentReader
    implements JPEGParserEventHandler {
        private Set<Byte> m_segsToKeep;

        private SegmentReader() {
        }

        @Override
        public boolean gotSegment(byte segID, int segLength, File jpegFile, LCByteBuffer buf) throws IOException {
            if (this.m_segsToKeep.contains(segID)) {
                ArrayList<ByteBuffer> list = (ArrayList<ByteBuffer>)JPEGImageInfo.this.m_segMap.get(segID);
                if (list == null) {
                    list = new ArrayList<ByteBuffer>();
                    JPEGImageInfo.this.m_segMap.put(segID, list);
                }
                list.add(ByteBuffer.wrap(buf.getBytes(segLength)));
            }
            return true;
        }

        void readSegments(ImageInfo jpegInfo, byte ... segIDs) throws BadImageFileException, IOException {
            this.m_segsToKeep = new HashSet<Byte>();
            if (segIDs != null) {
                for (byte segmentMarker : segIDs) {
                    this.m_segsToKeep.add(segmentMarker);
                }
            }
            JPEGParser.parse(this, jpegInfo.getFile(), jpegInfo.getByteBuffer());
        }
    }
}

